/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.laps.db;

import com.j256.ormlite.dao.ForeignCollection;
import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.field.ForeignCollectionField;
import com.j256.ormlite.table.DatabaseTable;
import com.ksoft.laps.db.SecretModel;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.log4j.Logger;

@DatabaseTable(tableName="computers")
@XmlRootElement
public class HostModel {
    static Logger logger = Logger.getLogger((String)HostModel.class.getName());
    @DatabaseField(generatedId=true)
    public Integer id;
    @DatabaseField(canBeNull=false, index=true, unique=true)
    public String name;
    @DatabaseField(canBeNull=false)
    public String ip;
    @DatabaseField(canBeNull=false, index=true)
    public String node_id;
    @DatabaseField(canBeNull=false)
    public String version;
    @DatabaseField(canBeNull=true, dataType=DataType.LONG_STRING)
    @XmlTransient
    public String pubkey;
    @DatabaseField(defaultValue="0")
    public Long ts_created;
    @DatabaseField(defaultValue="0")
    public Long ts_lastseen;
    @DatabaseField(canBeNull=true)
    public String managedby;
    @XmlTransient
    @ForeignCollectionField(eager=true)
    public ForeignCollection<SecretModel> secrets;
    @DatabaseField(canBeNull=false, index=true, unique=true)
    public String uuid;

    public void beforeCreate() {
        long date = ZonedDateTime.now(ZoneOffset.UTC).toEpochSecond();
        this.ts_created = date;
        this.ts_lastseen = date;
    }

    public void beforeUpdate() {
        long changedDate = ZonedDateTime.now(ZoneOffset.UTC).toEpochSecond();
        this.ts_lastseen = changedDate;
    }

    public void touchLastSeen() {
        this.ts_lastseen = ZonedDateTime.now(ZoneOffset.UTC).toEpochSecond();
    }
}

