/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.laps.db;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import com.ksoft.laps.core.LibraryManager;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.function.Function;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

@DatabaseTable(tableName="Library")
@XmlRootElement
public class LibraryModel {
    static Logger logger = Logger.getLogger((String)LibraryModel.class.getName());
    private static Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
    private Function<String, String> creationHook = null;
    @DatabaseField(generatedId=true)
    @XmlElement
    @Expose
    public Integer id;
    @DatabaseField(canBeNull=false, index=true)
    @XmlElement
    @Expose
    public String type;
    @DatabaseField(canBeNull=false, index=true)
    @XmlElement
    @Expose
    public String name;
    @DatabaseField(canBeNull=false, defaultValue="true")
    @XmlElement
    @Expose
    public Boolean enabled;
    @DatabaseField(canBeNull=false, dataType=DataType.LONG_STRING)
    @Expose(deserialize=false, serialize=false)
    @XmlElement
    public String config;
    @DatabaseField(canBeNull=false, defaultValue="0")
    @XmlElement
    @Expose
    public Integer version;
    @DatabaseField(canBeNull=false, defaultValue="0")
    @XmlElement
    @Expose(serialize=true, deserialize=false)
    public Long modified;

    public JSONObject toJSON() {
        JSONObject json = null;
        String jString = gson.toJson((Object)this);
        try {
            json = new JSONObject(jString);
            json.put("config", (Object)new JSONObject(this.config));
        }
        catch (JSONException e) {
            logger.error((Object)("Failed to conver to json " + this.getClass()));
        }
        return json;
    }

    @XmlTransient
    public JSONObject getConfigJSON() throws JSONException {
        return new JSONObject(this.config);
    }

    public static LibraryModel fromJSONString(String request) {
        LibraryModel model = (LibraryModel)gson.fromJson(request, LibraryModel.class);
        try {
            JSONObject json = new JSONObject(request);
            if (json.has("config")) {
                try {
                    JSONObject c = json.getJSONObject("config");
                    model.config = c.toString();
                }
                catch (JSONException e1) {
                    model.config = json.getString("config");
                }
            }
        }
        catch (JSONException e) {
            logger.error((Object)"Failed to convert config section");
        }
        return model;
    }

    public void beforeCreate() throws Exception {
        this.version = 0;
        long changedDate = ZonedDateTime.now(ZoneOffset.UTC).toEpochSecond();
        this.modified = changedDate;
        this.config = LibraryManager.getManager(this.type).beforeCreate(this.config);
    }

    public void beforeUpdate() throws Exception {
        this.version = this.version + 1;
        long changedDate = ZonedDateTime.now(ZoneOffset.UTC).toEpochSecond();
        this.modified = changedDate;
        this.config = LibraryManager.getManager(this.type).beforeUpdate(this.config);
    }
}

