/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.laps.db;

import com.google.gson.annotations.Expose;
import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import com.ksoft.core.ISecurityLogger;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.log4j.Logger;

@DatabaseTable(tableName="logs")
@XmlRootElement
public class LogModel
implements ISecurityLogger {
    static Logger logger = Logger.getLogger((String)LogModel.class.getName());
    static LinkedBlockingQueue<LogModel> queue;
    @DatabaseField(generatedId=true)
    @XmlElement
    @Expose
    public Integer id;
    @DatabaseField(canBeNull=false, defaultValue="0", index=true)
    @XmlElement
    @Expose(serialize=true, deserialize=false)
    public Long ts_created;
    @DatabaseField(canBeNull=false, index=true)
    @XmlElement
    @Expose
    public String event_type;
    @DatabaseField(canBeNull=true, index=true)
    @XmlElement
    @Expose
    public String source_ip;
    @DatabaseField(canBeNull=true, index=true)
    @XmlElement
    @Expose
    public String user_src;
    @DatabaseField(canBeNull=true, index=true)
    @XmlElement
    @Expose
    public String user_dst;
    @DatabaseField(canBeNull=true, index=true)
    @XmlElement
    @Expose
    public String computer;
    @DatabaseField(canBeNull=true, dataType=DataType.LONG_STRING)
    @Expose
    @XmlElement
    public String message;
    @DatabaseField(canBeNull=true, index=true)
    @XmlElement
    @Expose
    public String category;

    public static void registerTask(EVENT_TYPE event_type, String message) {
        LogModel model = new LogModel();
        model.event_type = event_type.toString();
        model.category = CATEGORY.system.toString();
        model.message = message;
        model.ts_created = Instant.now().toEpochMilli();
        LogModel.registerModel(model);
    }

    private static void registerModel(LogModel model) {
        try {
            queue.put(model);
        }
        catch (InterruptedException e) {
            logger.error((Object)"Log register error", (Throwable)e);
        }
    }

    public static void register(EVENT_TYPE event_type, String source_ip, String user_src, String computer, String message) {
        LogModel.register(event_type, source_ip, user_src, "", computer, message);
    }

    public void register(String event_type, String source_ip, String user_src, String message) {
        EVENT_TYPE et = EVENT_TYPE.valueOf(event_type);
        LogModel.register(et, source_ip, user_src, "", message);
    }

    public static void register(EVENT_TYPE event_type, String source_ip, String user_src, String user_dst, String computer, String message) {
        LogModel model = new LogModel();
        model.event_type = event_type.toString();
        model.source_ip = source_ip;
        model.user_src = user_src;
        model.user_dst = user_dst;
        model.computer = computer;
        model.message = message;
        model.ts_created = Instant.now().toEpochMilli();
        switch (event_type) {
            case PASSWORD_ACCESS: 
            case PASSWORD_ACCESS_FAIL: 
            case SET_EXPIRE: 
            case SET_EXPIRE_FAIL: {
                model.category = CATEGORY.laps.toString();
                break;
            }
            case JITA_ROLE_APPLY: 
            case JITA_ROLE_APPLY_FAIL: 
            case JITA_ROLE_STOP: 
            case JITA_ROLE_STOP_FAIL: {
                model.category = CATEGORY.jita.toString();
                break;
            }
            case TASK: {
                model.category = CATEGORY.system.toString();
                break;
            }
            case AGENT_EVENT: {
                model.category = CATEGORY.agent.toString();
                break;
            }
            default: {
                model.category = CATEGORY.audit.toString();
            }
        }
        try {
            queue.put(model);
        }
        catch (InterruptedException e) {
            logger.error((Object)"Unable to put log in queue", (Throwable)e);
        }
    }

    public List<String> getValues() {
        ArrayList<String> values = new ArrayList<String>();
        values.add(this.id.toString());
        values.add(this.ts_created.toString());
        values.add(Instant.ofEpochMilli(this.ts_created).toString());
        values.add(this.category);
        values.add(this.event_type);
        values.add(this.source_ip);
        values.add(this.user_src);
        values.add(this.user_dst);
        values.add(this.computer);
        values.add(this.message);
        return values;
    }

    public static void setQueue(LinkedBlockingQueue<LogModel> queue) {
        LogModel.queue = queue;
    }

    public static enum CATEGORY {
        laps,
        audit,
        system,
        jita,
        agent;

    }

    public static enum EVENT_TYPE {
        PASSWORD_ACCESS,
        PASSWORD_ACCESS_FAIL,
        SET_EXPIRE,
        SET_EXPIRE_FAIL,
        LOGIN_SUCCESS,
        LOGIN_FAIL,
        USER_ADD,
        USER_MODIFY,
        USER_DELETE,
        USER_PASSWORD_UPDATE,
        USER_ENABLED,
        USER_DISABLED,
        GENERATE_TOTP_SECRET,
        DELETE_TOTP,
        INIT_TOTP,
        TASK,
        COMPUTER_MOVE,
        COMPUTER_MOVE_FAIL,
        MOBILE_DEVICE_ADD,
        MOBILE_DEVICE_ADD_FAIL,
        PUSH_AUTH_FAIL,
        SET_PIN,
        DEVICE_TOKEN_UPDATED,
        JITA_ROLE_APPLY,
        JITA_ROLE_APPLY_FAIL,
        JITA_ROLE_STOP,
        JITA_ROLE_STOP_FAIL,
        AGENT_EVENT;

    }
}

