/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.laps.db;

import com.google.gson.annotations.Expose;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.SelectArg;
import com.j256.ormlite.stmt.Where;
import com.ksoft.core.DBManager;
import com.ksoft.laps.db.HostModel;
import java.sql.SQLException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;

public class SecretModel {
    @DatabaseField(generatedId=true)
    @XmlElement
    @Expose
    public Integer id;
    @DatabaseField(canBeNull=false, index=true)
    @XmlTransient
    public String type;
    @DatabaseField(canBeNull=false, index=true)
    @XmlTransient
    public String subject;
    @DatabaseField(canBeNull=true)
    @XmlTransient
    public String secret;
    @DatabaseField(canBeNull=true)
    @XmlTransient
    public String oldsecret;
    @DatabaseField(canBeNull=true)
    @XmlTransient
    public String tempsecret;
    @DatabaseField(canBeNull=true)
    @XmlTransient
    public String commituuid;
    @DatabaseField(defaultValue="0")
    public Long ts_created;
    @DatabaseField(defaultValue="0")
    public Long ts_modified;
    @DatabaseField(defaultValue="0")
    public Long ts_expire;
    @XmlTransient
    @DatabaseField(canBeNull=true, foreign=true, foreignAutoCreate=true, foreignAutoRefresh=true)
    public HostModel host;

    public void beforeCreate() {
        long date = ZonedDateTime.now(ZoneOffset.UTC).toEpochSecond();
        this.ts_created = date;
    }

    public void beforeUpdate() {
        long changedDate = ZonedDateTime.now(ZoneOffset.UTC).toEpochSecond();
        this.ts_modified = changedDate;
    }

    public static SecretModel getSecretModelByHostAndSubject(Integer hostId, String subject) throws SQLException {
        QueryBuilder qb = DBManager.getDao(SecretModel.class).queryBuilder();
        Where where = qb.where().eq("host_id", (Object)new SelectArg((Object)hostId)).and().eq("subject", (Object)new SelectArg((Object)subject));
        qb.setWhere(where);
        SecretModel model = (SecretModel)DBManager.getDao(SecretModel.class).queryForFirst(qb.prepare());
        return model;
    }

    public static enum TYPE {
        Windows_Local;

    }
}

