/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.laps.db;

import com.google.gson.annotations.Expose;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import com.ksoft.core.DBManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.sql.SQLException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

@DatabaseTable(tableName="Settings")
@XmlRootElement
public class SettingModel {
    static Logger logger = Logger.getLogger((String)SettingModel.class.getName());
    public static String SEC_CONST = "oneTWOth";
    public static SecretKey secretKey = null;
    private static HashMap<String, String> cache = new HashMap();
    private static HashMap<String, Long> cacheModifiedTime = new HashMap();
    @DatabaseField(id=true)
    @XmlElement
    @Expose
    public String key;
    @DatabaseField(canBeNull=false)
    @XmlElement
    @Expose
    public String caption;
    @DatabaseField(canBeNull=false)
    @XmlElement
    @Expose
    public String description;
    @DatabaseField(canBeNull=true)
    @XmlElement
    @Expose
    public String type;
    @DatabaseField(canBeNull=false, dataType=DataType.LONG_STRING)
    @XmlElement
    @Expose
    public String value;
    @DatabaseField(canBeNull=false, defaultValue="false")
    @XmlElement
    @Expose
    public Boolean required;
    @DatabaseField(canBeNull=true)
    @XmlElement
    @Expose
    public Integer order;
    @DatabaseField(canBeNull=true, dataType=DataType.LONG_STRING)
    @XmlElement
    @Expose(deserialize=false, serialize=false)
    public String extra;
    @DatabaseField(defaultValue="0")
    @XmlElement
    @Expose
    public Long modified;

    public SettingModel() {
    }

    public static void setInternalSecretKey(String seed) throws Exception {
        if ((String.valueOf(SEC_CONST) + seed).length() != 16) {
            throw new Exception("Wrong encryption key length!");
        }
        secretKey = SettingModel.createSecretKey(String.valueOf(SEC_CONST) + seed);
    }

    public SettingModel(String key, String caption, String value, Boolean required, Integer order) {
        this.key = key;
        this.caption = caption;
        this.value = value;
        this.required = required;
        this.order = order;
    }

    public static void create(String key, String caption, String value, Boolean required, Integer order) throws SQLException {
        SettingModel model = new SettingModel(key, caption, value, required, order);
        model.beforeCreate();
        DBManager.getDao((Object)model).create((Object)model);
    }

    public static boolean getBool(String key) {
        boolean result = false;
        result = Boolean.parseBoolean(SettingModel.get(key));
        return result;
    }

    public static String get(String key) {
        String result;
        block11: {
            result = null;
            if (cache.containsKey(key)) {
                String value = cache.get(key);
                if (key.toLowerCase().endsWith("password")) {
                    try {
                        value = SettingModel.decrypt(value, secretKey);
                    }
                    catch (Exception e) {
                        logger.error((Object)("decrypt error " + key), (Throwable)e);
                    }
                }
                return value;
            }
            try {
                SettingModel model = (SettingModel)DBManager.getDao(SettingModel.class).queryForId((Object)key);
                if (model != null) {
                    if (model.key.toLowerCase().endsWith("password")) {
                        try {
                            model.value = SettingModel.decrypt(model.value, secretKey);
                        }
                        catch (Exception e) {
                            model.value = "";
                            logger.error((Object)("decrypt error " + key), (Throwable)e);
                        }
                    }
                    if ((result = model.value) != null) {
                        cache.put(key, result);
                    }
                    break block11;
                }
                logger.error((Object)("Unable to find setting for key: " + key));
            }
            catch (Exception e) {
                logger.error((Object)("ERROR: Unable to get setting for key: " + key), (Throwable)e);
            }
        }
        return result;
    }

    public static Long getModified(String key) {
        return cacheModifiedTime.get(key);
    }

    public static String get(String key, String defaultValue) {
        String result = SettingModel.get(key);
        if (result == null) {
            result = defaultValue;
            cache.put(key, result);
        }
        return result;
    }

    public static int getInt(String key, int defaultVulue) {
        Integer result = SettingModel.getInt(key);
        if (result == null) {
            result = defaultVulue;
        }
        return result;
    }

    public static Integer getInt(String key) {
        Integer result = null;
        String temp = SettingModel.get(key);
        if (temp != null) {
            result = Integer.parseInt(temp);
            cache.put(key, temp);
        }
        return result;
    }

    public static Long getLong(String key) {
        Long result = null;
        String temp = SettingModel.get(key);
        if (temp != null) {
            result = Long.parseLong(temp);
            cache.put(key, temp);
        }
        return result;
    }

    public static boolean set(String key, String value) {
        boolean result = false;
        try {
            SettingModel model = (SettingModel)DBManager.getDao(SettingModel.class).queryForId((Object)key);
            if (model != null) {
                model.value = model.key.toLowerCase().endsWith("password") ? SettingModel.encrypt(value, secretKey) : value;
                model.beforeUpdate();
                DBManager.getDao(SettingModel.class).update((Object)model);
                cache.put(key, model.value);
                cacheModifiedTime.put(key, model.modified);
                result = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)("ERROR: Unable to set " + key), (Throwable)e);
        }
        return result;
    }

    public static SecretKey createSecretKey(String password) {
        SecretKeySpec skeySpec = null;
        try {
            skeySpec = new SecretKeySpec(password.getBytes(), "AES");
        }
        catch (Exception e) {
            logger.error((Object)"createSecretKey error", (Throwable)e);
        }
        return skeySpec;
    }

    public static String encrypt(String text) throws UnsupportedEncodingException, GeneralSecurityException {
        return SettingModel.encrypt(text, secretKey);
    }

    public static String encrypt(String property, SecretKey key) throws GeneralSecurityException, UnsupportedEncodingException {
        Cipher pbeCipher = Cipher.getInstance("AES/ECB/PKCS5PADDING");
        pbeCipher.init(1, key);
        byte[] cryptoText = pbeCipher.doFinal(property.getBytes());
        return Base64.encodeBase64String((byte[])cryptoText);
    }

    public static String decrypt(String string, SecretKey key) throws GeneralSecurityException, IOException {
        Cipher pbeCipher = Cipher.getInstance("AES/ECB/PKCS5PADDING");
        pbeCipher.init(2, key);
        byte[] encrypted = Base64.decodeBase64((String)string);
        byte[] decrypted = pbeCipher.doFinal(encrypted);
        return new String(decrypted);
    }

    public static String decrypt(String encrypted) throws GeneralSecurityException, IOException {
        return SettingModel.decrypt(encrypted, secretKey);
    }

    public void setValue(String value) throws UnsupportedEncodingException, GeneralSecurityException {
        this.value = this.key.toLowerCase().endsWith("password") ? SettingModel.encrypt(value, secretKey) : value;
    }

    public static void updateCache(String key, String value, Long modified) {
        cache.put(key, value);
        cacheModifiedTime.put(key, modified);
    }

    public static void initCache() {
        cache.clear();
        int count = 0;
        int all = 0;
        try {
            List models = DBManager.getDao(SettingModel.class).queryForAll();
            all = models.size();
            for (SettingModel model : models) {
                if (model.value == null) continue;
                cache.put(model.key, model.value);
                if (model.modified != null && model.modified > 0L) {
                    cacheModifiedTime.put(model.key, model.modified);
                }
                ++count;
            }
        }
        catch (Exception e) {
            logger.error((Object)"Init cache error", (Throwable)e);
        }
        logger.debug((Object)("Settings cache init completed. Loaded " + count + "/" + all + " values"));
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        InputStream input = classLoader.getResourceAsStream("resources/default.conf");
        try {
            int read;
            File file = File.createTempFile(String.valueOf(new Date().getTime()) + "_lps", ".tmp");
            FileOutputStream out = new FileOutputStream(file);
            byte[] bytes = new byte[1024];
            while ((read = input.read(bytes)) != -1) {
                ((OutputStream)out).write(bytes, 0, read);
            }
            out.flush();
            ((OutputStream)out).close();
            input.close();
            SettingModel.importNewSettings(file, false);
            file.delete();
        }
        catch (Exception e) {
            logger.error((Object)"load from jar error", (Throwable)e);
        }
    }

    public void beforeCreate() {
        long changedDate = ZonedDateTime.now(ZoneOffset.UTC).toEpochSecond();
        this.modified = changedDate;
    }

    public void beforeUpdate() {
        long changedDate = ZonedDateTime.now(ZoneOffset.UTC).toEpochSecond();
        this.modified = changedDate;
    }

    public static void importNewSettings(File file, boolean deleteOld) {
        String line = "";
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader br = new BufferedReader(new FileReader(file));){
                String tableName = "";
                String claz = "";
                JSONArray jColumns = new JSONArray();
                Dao dao = DBManager.getDao(SettingModel.class);
                boolean gotTable = false;
                int keyColIndex = -1;
                while ((line = br.readLine()) != null) {
                    JSONArray jValues;
                    String key;
                    if (line.isEmpty()) continue;
                    JSONObject json = new JSONObject(line);
                    if (json.has("table")) {
                        tableName = json.getString("table");
                        if (!tableName.matches("[a-zA-Z0-9]+")) {
                            logger.error((Object)(String.valueOf(tableName) + " not matched regexp [a-zA-Z0-9]+"));
                        }
                        if (gotTable) {
                            return;
                        }
                        if (tableName.toLowerCase().equals("settings")) {
                            gotTable = true;
                        }
                    }
                    if (json.has("columns")) {
                        jColumns = json.getJSONArray("columns");
                        if (gotTable) {
                            int i = 0;
                            while (i < jColumns.length()) {
                                if (jColumns.getString(i).toLowerCase().equals("key")) {
                                    keyColIndex = i;
                                    break;
                                }
                                ++i;
                            }
                        }
                    }
                    if (!json.has("values") || cache.containsKey(key = (jValues = json.getJSONArray("values")).getString(keyColIndex))) continue;
                    logger.debug((Object)("New settings: " + key));
                    String[] vals = new String[jValues.length()];
                    String SQL = "INSERT INTO " + tableName + " (";
                    int i = 0;
                    while (i < jColumns.length()) {
                        SQL = String.valueOf(SQL) + "`" + jColumns.getString(i) + "`";
                        if (i < jColumns.length() - 1) {
                            SQL = String.valueOf(SQL) + ",";
                        }
                        ++i;
                    }
                    SQL = String.valueOf(SQL) + ")";
                    SQL = String.valueOf(SQL) + " values (";
                    i = 0;
                    while (i < jValues.length()) {
                        SQL = String.valueOf(SQL) + "?";
                        if (i < jValues.length() - 1) {
                            SQL = String.valueOf(SQL) + ",";
                        }
                        vals[i] = jValues.get(i).toString();
                        ++i;
                    }
                    SQL = String.valueOf(SQL) + ")";
                    try {
                        dao.executeRaw(SQL, vals);
                    }
                    catch (SQLException e) {
                        logger.error((Object)("Unable to insert values " + SQL + " " + jValues.toString()), (Throwable)e);
                    }
                }
                br.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            logger.error((Object)("importNewSettings error " + file + ". Last line: " + line), (Throwable)e);
        }
    }
}

