/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.laps.db;

import com.google.gson.annotations.Expose;
import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.SelectArg;
import com.j256.ormlite.stmt.Where;
import com.j256.ormlite.table.DatabaseTable;
import com.ksoft.core.DBManager;
import java.sql.SQLException;
import java.time.Instant;
import javax.xml.bind.annotation.XmlElement;
import org.apache.log4j.Logger;

@DatabaseTable(tableName="transactions")
public class TransactionModel {
    static Logger logger = Logger.getLogger((String)TransactionModel.class.getName());
    @DatabaseField(generatedId=true)
    @XmlElement
    @Expose
    public Integer id;
    @DatabaseField(canBeNull=false, index=true)
    @XmlElement
    @Expose
    public String type;
    @DatabaseField(canBeNull=false, index=true)
    @XmlElement
    @Expose
    public String name;
    @DatabaseField(canBeNull=false, defaultValue="0", index=true)
    @XmlElement
    @Expose(serialize=true, deserialize=false)
    public Long ts_created;
    @DatabaseField(canBeNull=false, defaultValue="0", index=true)
    @XmlElement
    @Expose
    public Long ts_till;
    @DatabaseField(canBeNull=false, defaultValue="0", index=true)
    @XmlElement
    @Expose(serialize=true, deserialize=false)
    public Long ts_committed;
    @DatabaseField(canBeNull=true, index=true)
    @XmlElement
    @Expose
    public String owner;
    @DatabaseField(canBeNull=true)
    @XmlElement
    @Expose
    public String value;
    @DatabaseField(canBeNull=true, dataType=DataType.LONG_STRING)
    @XmlElement
    @Expose(deserialize=false, serialize=false)
    public String extra;

    public static int addOrUpdateTransaction(String owner, TRANS_TYPE type, String name, String value, String extra, Long validTill) {
        int transactionId = -1;
        TransactionModel model = null;
        try {
            Long now = Instant.now().toEpochMilli();
            QueryBuilder qb = DBManager.getDao(TransactionModel.class).queryBuilder();
            Where where = qb.where().eq("owner", (Object)new SelectArg((Object)owner)).and().eq("type", (Object)new SelectArg((Object)type.toString())).and().eq("name", (Object)new SelectArg((Object)name)).and().ge("ts_till", (Object)now);
            if (value != null) {
                where.and().eq("value", (Object)new SelectArg((Object)value));
            }
            qb.setWhere(where);
            model = (TransactionModel)DBManager.getDao(TransactionModel.class).queryForFirst(qb.prepare());
            if (model != null) {
                model.ts_till = validTill;
                model.value = value;
                model.extra = extra;
                transactionId = model.id;
                DBManager.getDao(TransactionModel.class).update((Object)model);
            } else {
                model = new TransactionModel();
                model.owner = owner.toLowerCase();
                model.type = type.toString();
                model.name = name;
                model.ts_created = Instant.now().toEpochMilli();
                if (value != null) {
                    model.value = value;
                }
                if (extra != null) {
                    model.extra = extra;
                }
                if (validTill != null) {
                    model.ts_till = validTill;
                }
                if (DBManager.getDao((Object)model).create((Object)model) == 1) {
                    transactionId = model.id;
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)("Unable to register transaction " + type.toString() + " owner: " + owner), (Throwable)e);
        }
        return transactionId;
    }

    public static boolean commitTransaction(int id) {
        boolean result = false;
        try {
            TransactionModel model = (TransactionModel)DBManager.getDao(TransactionModel.class).queryForId((Object)id);
            if (model != null) {
                model.ts_committed = Instant.now().toEpochMilli();
                DBManager.getDao(TransactionModel.class).update((Object)model);
                result = true;
            } else {
                logger.error((Object)("Transaction " + id + " not found"));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Unable to commit transaction");
        }
        return result;
    }

    public static boolean removeTransaction(int id) {
        boolean result = false;
        try {
            TransactionModel model = (TransactionModel)DBManager.getDao(TransactionModel.class).queryForId((Object)id);
            if (model != null) {
                DBManager.getDao(TransactionModel.class).delete((Object)model);
                result = true;
            } else {
                logger.error((Object)("Transaction " + id + " not found"));
            }
        }
        catch (Exception e) {
            logger.error((Object)("Unable to delete transaction " + id));
        }
        return result;
    }

    public static enum TRANS_TYPE {
        GROUP_APPLY,
        ROLE_APPLY;

    }
}

