/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.laps.output;

import com.ksoft.laps.core.LapsLauncher;
import com.ksoft.laps.db.LogModel;
import com.lespea.cef.CEF;
import com.lespea.cef.Extension;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class SyslogOutput {
    static Logger logger = Logger.getLogger((String)SyslogOutput.class.getName());
    private int port;
    private String ip;
    private InetAddress address;
    private DatagramSocket socket;
    int buffer_size;
    String msg;
    String format;
    String event_format;

    public SyslogOutput(String host, int port) {
        this.port = port;
        this.ip = host;
        try {
            this.socket = new DatagramSocket();
            this.address = InetAddress.getByName(this.ip);
        }
        catch (Exception e) {
            logger.error((Object)"Syslog output init error", (Throwable)e);
        }
    }

    public void sendEvent(LogModel model) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            if (model.user_src != null && !model.user_src.isEmpty()) {
                map.put("suser", model.user_src);
            }
            if (model.user_dst != null && !model.user_dst.isEmpty()) {
                map.put("duser", model.user_dst);
            }
            if (model.source_ip != null && !model.source_ip.isEmpty()) {
                map.put("src", model.source_ip);
            }
            map.put("cat", model.category);
            if (model.computer != null && !model.computer.isEmpty()) {
                map.put("dhost", model.computer);
            }
            Extension extension = new Extension(map);
            CEF cef = new CEF("WebLAPS", "Laps", LapsLauncher.getVersion(), model.event_type, model.event_type, 0, extension);
            String out = "<46>" + cef.toString();
            byte[] buffer = out.getBytes();
            DatagramPacket packet = new DatagramPacket(buffer, buffer.length, this.address, this.port);
            this.socket.send(packet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

