/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.web;

import com.ksoft.core.DBManager;
import com.ksoft.laps.db.AccountModel;
import com.ksoft.web.LAPSextra;
import com.ksoft.web.MySecurityContext;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Provider
public class AuthFilter
implements ContainerRequestFilter {
    @Context
    private ResourceInfo resourceInfo;
    @Context
    private UriInfo uriInfo;
    @Context
    HttpServletRequest servletRequest;
    public static final String AUTH_COOKIE = "X-Token";
    public static final String CSRF_HEADER = "X-XSRF-TOKEN";
    public static boolean IS_SECURE = true;
    public static String REAL_IP_HEADER = "";
    public static int tokenExpirationMinutes = 15;
    private static Logger logger = Logger.getLogger((String)AuthFilter.class.getName());
    private static PublicKey publicKey = null;
    private static PrivateKey privateKey = null;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String ip = AuthFilter.getSourceIP(this.servletRequest);
        Method method = this.resourceInfo.getResourceMethod();
        String className = this.resourceInfo.getResourceClass().getSimpleName();
        if (method.isAnnotationPresent(PermitAll.class)) {
            return;
        }
        if (requestContext.getMethod().equals("OPTIONS")) {
            return;
        }
        if (method.isAnnotationPresent(DenyAll.class)) {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"{\"reason\":\"access denied\"}").build());
            return;
        }
        MultivaluedMap headers = requestContext.getHeaders();
        Map cookies = requestContext.getCookies();
        if (!cookies.containsKey(AUTH_COOKIE)) {
            try {
                requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).location(new URI("/web/")).entity((Object)"{\"error\":\"Auth header not present\"}").build());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            return;
        }
        String token = ((Cookie)cookies.get(AUTH_COOKIE)).getValue();
        try {
            RolesAllowed rolesAnnotation = method.getAnnotation(RolesAllowed.class);
            HashSet<String> rolesSet = null;
            if (rolesAnnotation != null) {
                rolesSet = new HashSet<String>(Arrays.asList(rolesAnnotation.value()));
            }
            if (rolesSet != null && this.isPeerAllowed(token, rolesSet)) {
                logger.debug((Object)("Peer allowed to call method " + className + "." + method.getName() + " from " + ip));
                return;
            }
            String accessMode = "general";
            if (method.isAnnotationPresent(LAPSextra.class) && method.getAnnotation(LAPSextra.class).allowMobile()) {
                accessMode = "mobile";
            }
            if (!AuthFilter.isTokenValid(token, accessMode, ip)) {
                try {
                    logger.error((Object)("Token from " + ip + " is invalid. Token " + token + " " + className + "." + method.getName()));
                    requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).location(new URI("/web/")).entity((Object)"{\"reason\":\"Token invalid\"}").build());
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
                return;
            }
            if (!method.isAnnotationPresent(LAPSextra.class) || method.isAnnotationPresent(LAPSextra.class) && !method.getAnnotation(LAPSextra.class).noCSRFCheck()) {
                String csrfToken;
                boolean csrfPass = false;
                List csrfHeaders = (List)headers.get((Object)CSRF_HEADER);
                if (csrfHeaders != null && !csrfHeaders.isEmpty() && AuthFilter.isTokenValid(csrfToken = ((String)csrfHeaders.get(0)).replace(" ", ""), "csrf", ip)) {
                    csrfPass = true;
                }
                if (!csrfPass) {
                    try {
                        logger.error((Object)("CSRF check not passed " + className + "." + method.getName()));
                        requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).location(new URI("/web/")).entity((Object)"{\"error\":\"CSRF token invalid\"}").build());
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                    return;
                }
            }
            AccountModel accountModel = new AccountModel();
            accountModel = AuthFilter.getUserModelByToken(token);
            if (accountModel.id == null) {
                logger.error((Object)("Invalid token recieved from " + ip + ", no accounts found"));
                try {
                    requestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).location(new URI("/web/")).entity((Object)"{\"reason\":\"User not found for this token\"}").build());
                }
                catch (URISyntaxException csrfHeaders) {
                    // empty catch block
                }
                return;
            }
            if (!accountModel.getEnabled().booleanValue()) {
                logger.debug((Object)("User " + accountModel.login + " is disabled"));
                try {
                    requestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).location(new URI("/web/")).entity((Object)"{\"reason\":\"User is disabled\"}").build());
                }
                catch (URISyntaxException csrfHeaders) {
                    // empty catch block
                }
                return;
            }
            logger.trace((Object)("Auth token for user " + accountModel.login + " recieved"));
            if (method.isAnnotationPresent(RolesAllowed.class)) {
                String scheme = this.uriInfo.getRequestUri().getScheme();
                if (!this.isUserAllowed(accountModel, rolesSet)) {
                    requestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"{\"reason\":\"User not allowed to call this method\"}").build());
                    return;
                }
                requestContext.setSecurityContext((SecurityContext)new MySecurityContext(accountModel, scheme));
            }
        }
        catch (Exception e) {
            try {
                requestContext.abortWith(Response.status((Response.Status)Response.Status.NOT_FOUND).location(new URI("/web/")).entity((Object)"Unknown error").build());
                logger.error((Object)("Invalid token from " + ip + " token: " + token), (Throwable)e);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            return;
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean isTokenValid(String token, String audience, String ip) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[8] lbl68 : CaseStatement: default:\u000a, @NONE, blocks:[8] lbl68 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static AccountModel getUserModelByToken(String token) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException, SQLException, IOException {
        String login = ((Claims)Jwts.parser().requireAudience("general").setAllowedClockSkewSeconds(60L).setSigningKey((Key)AuthFilter.getPublicKey()).parseClaimsJws(token).getBody()).getSubject();
        AccountModel model = (AccountModel)DBManager.findOne(AccountModel.class, (String)"login", (Object)login);
        return model;
    }

    private boolean isUserAllowed(AccountModel accountModel, Set<String> rolesSet) {
        boolean isAllowed = false;
        if (!accountModel.enabled.booleanValue()) {
            return isAllowed;
        }
        String userRole = accountModel.roles;
        ArrayList<String> userRoles = accountModel.getRolesArray();
        if (rolesSet.contains("AUTHED")) {
            isAllowed = true;
        }
        for (String role : userRoles) {
            if (!rolesSet.contains(role)) continue;
            isAllowed = true;
            break;
        }
        return isAllowed;
    }

    private boolean isPeerAllowed(String token, Set<String> rolesSet) {
        String peerType;
        boolean isAllowed = false;
        Claims claims = (Claims)Jwts.parser().setAllowedClockSkewSeconds(60L).setSigningKey((Key)AuthFilter.getPublicKey()).parseClaimsJws(token).getBody();
        if (claims.containsKey((Object)"peerType") && rolesSet.contains(peerType = (String)claims.get((Object)"peerType"))) {
            String path = this.uriInfo.getRequestUri().getPath();
            String scope = (String)claims.get((Object)"scope");
            try {
                JSONArray scopes = new JSONArray(scope);
                int i = 0;
                while (i < scopes.length()) {
                    String s = scopes.getString(i);
                    if (path.startsWith(s)) {
                        isAllowed = true;
                        break;
                    }
                    ++i;
                }
            }
            catch (JSONException e) {
                logger.error((Object)("isPeerAllowed error " + path), (Throwable)e);
            }
        }
        return isAllowed;
    }

    public static String getAuthToken(ContainerRequestContext requestContext) {
        String token = null;
        Map cookies = requestContext.getCookies();
        if (cookies.containsKey(AUTH_COOKIE)) {
            token = ((Cookie)cookies.get(AUTH_COOKIE)).getValue();
        }
        return token;
    }

    public static String getAuthToken(HttpServletRequest servletRequest) {
        String token = null;
        javax.servlet.http.Cookie[] cookies = servletRequest.getCookies();
        if (cookies != null) {
            int i = 0;
            while (i < cookies.length) {
                javax.servlet.http.Cookie cookie = cookies[i];
                if (cookie.getName().equals(AUTH_COOKIE)) {
                    token = cookie.getValue();
                }
                ++i;
            }
        }
        return token;
    }

    public static String getSourceIP(HttpServletRequest servletRequest) {
        String ip = servletRequest.getRemoteAddr();
        return ip;
    }

    public static JSONArray getAllRoles() throws JSONException {
        JSONArray array = new JSONArray();
        ROLE[] values = ROLE.values();
        int i = 0;
        while (i < values.length) {
            JSONObject json = new JSONObject();
            json.put("code", (Object)values[i].name());
            json.put("name", (Object)values[i].toString());
            array.put((Object)json);
            ++i;
        }
        return array;
    }

    public static PublicKey getPublicKey() {
        return publicKey;
    }

    public static void setPublicKey(PublicKey publicKey) {
        AuthFilter.publicKey = publicKey;
    }

    public static PrivateKey getPrivateKey() {
        return privateKey;
    }

    public static void setPrivateKey(PrivateKey privateKey) {
        AuthFilter.privateKey = privateKey;
    }

    public static String generateTokenForEngine() {
        JSONArray scopes = new JSONArray(Arrays.asList("/api/cluster"));
        String jwtToken = Jwts.builder().claim("peerType", (Object)"ENGINE").claim("scope", (Object)scopes.toString()).setIssuedAt(new Date(System.currentTimeMillis())).setExpiration(new Date(System.currentTimeMillis() + 300000L)).signWith(SignatureAlgorithm.RS512, (Key)AuthFilter.getPrivateKey()).compact();
        return jwtToken;
    }

    public static String generateTokenForPCAgent(String uuid, int validDays) {
        JSONArray scopes = new JSONArray(Arrays.asList("/api/v1/remotepc/"));
        String jwtToken = Jwts.builder().setSubject(uuid).claim("peerType", (Object)"PCAGENT").claim("scope", (Object)scopes.toString()).setIssuedAt(new Date(System.currentTimeMillis())).setExpiration(new Date(System.currentTimeMillis() + 86400000L * (long)validDays)).signWith(SignatureAlgorithm.RS512, (Key)AuthFilter.getPrivateKey()).compact();
        return jwtToken;
    }

    public static String getAuthenticatedPCUUID(HttpServletRequest servletRequest) {
        String result = null;
        String ipsrc = AuthFilter.getSourceIP(servletRequest);
        try {
            String uuid;
            String token = AuthFilter.getAuthToken(servletRequest);
            result = uuid = ((Claims)Jwts.parser().require("peerType", (Object)"PCAGENT").setAllowedClockSkewSeconds(60L).setSigningKey((Key)AuthFilter.getPublicKey()).parseClaimsJws(token).getBody()).getSubject();
        }
        catch (Exception e) {
            logger.error((Object)("getAuthenticatedPCUUID  error from " + ipsrc), (Throwable)e);
        }
        return result;
    }

    public static String getAuthenticatedLogin(HttpServletRequest servletRequest) {
        String result = null;
        String ip = AuthFilter.getSourceIP(servletRequest);
        try {
            String token = AuthFilter.getAuthToken(servletRequest);
            if (token != null && AuthFilter.isTokenValid(token, "general", ip)) {
                AccountModel model = AuthFilter.getUserModelByToken(token);
                if (model != null) {
                    if (model.getEnabled().booleanValue()) {
                        result = model.getLogin();
                    }
                } else {
                    String tokenLogin = ((Claims)Jwts.parser().requireAudience("general").setAllowedClockSkewSeconds(60L).setSigningKey((Key)AuthFilter.getPublicKey()).parseClaimsJws(token).getBody()).getSubject();
                    logger.error((Object)("Unable to find model for login" + tokenLogin));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"getAuthenticatedLogin", (Throwable)e);
        }
        return result;
    }

    public static AccountModel getAuthenticatedModel(HttpServletRequest servletRequest) {
        String ip = AuthFilter.getSourceIP(servletRequest);
        AccountModel model = null;
        try {
            String token = AuthFilter.getAuthToken(servletRequest);
            if (token != null && !token.isEmpty() && AuthFilter.isTokenValid(token, "general", ip)) {
                model = AuthFilter.getUserModelByToken(token);
            }
        }
        catch (Exception e) {
            logger.error((Object)"getAuthenticatedLogin", (Throwable)e);
        }
        return model;
    }

    public static int getTokenExpirationMinutes() {
        return tokenExpirationMinutes;
    }

    public static enum ROLE {
        ADMIN("Administrator"),
        LAPSUSER("LAPS access"),
        USERMANAGEMENT("Users management"),
        JIAUSER("Just in time administration");

        private final String role;

        private ROLE(String role) {
            this.role = role;
        }

        public String getValue() {
            return this.role;
        }

        public String toString() {
            return this.role;
        }
    }
}

