/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.web;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;

@Provider
public class CORSFilter
implements Filter,
ContainerResponseFilter {
    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        MultivaluedMap headers = responseContext.getHeaders();
        headers.add((Object)"Access-Control-Allow-Origin", (Object)"*");
        headers.add((Object)"Access-Control-Allow-Methods", (Object)"GET, POST, DELETE, PUT");
        headers.add((Object)"Access-Control-Allow-Headers", (Object)"X-Requested-With, Content-Type,X-Auth");
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        chain.doFilter(servletRequest, (ServletResponse)new CORSResponseWrapper((HttpServletResponse)resp));
    }

    public void init(FilterConfig arg0) throws ServletException {
    }

    public class CORSResponseWrapper
    extends HttpServletResponseWrapper {
        public CORSResponseWrapper(HttpServletResponse response) {
            super(response);
            response.addHeader("Access-Control-Allow-Origin", "*");
            response.addHeader("Access-Control-Allow-Methods", "GET, POST, DELETE, PUT, OPTIONS");
            response.addHeader("Access-Control-Allow-Headers", "X-Requested-With, Content-Type, X-Auth");
        }
    }
}

