/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.web;

import com.ksoft.web.CacheControl;
import com.ksoft.web.CacheControlExtension;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.Provider;

@Provider
public class CacheFilterFactory
implements DynamicFeature {
    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        javax.ws.rs.core.CacheControl cc;
        String value;
        Method resourceMethod = resourceInfo.getResourceMethod();
        if (resourceMethod.isAnnotationPresent(CacheControl.class) && !(value = (cc = this.createCacheControl(resourceMethod.getAnnotation(CacheControl.class))).toString()).isEmpty()) {
            context.register((Object)new CacheResponseFilter(value));
        }
    }

    private javax.ws.rs.core.CacheControl createCacheControl(CacheControl annotation) {
        javax.ws.rs.core.CacheControl cacheControl = new javax.ws.rs.core.CacheControl();
        cacheControl.setPrivate(annotation._private() || annotation.privateFields().length > 0);
        cacheControl.getPrivateFields().addAll(Arrays.asList(annotation.privateFields()));
        cacheControl.setMustRevalidate(annotation.mustRevalidate());
        cacheControl.setNoCache(annotation.noCache() || annotation.noCacheFields().length > 0);
        cacheControl.getNoCacheFields().addAll(Arrays.asList(annotation.noCacheFields()));
        cacheControl.setNoStore(annotation.noStore());
        cacheControl.setNoTransform(annotation.noTransform());
        cacheControl.setProxyRevalidate(annotation.proxyRevalidate());
        cacheControl.setMaxAge(annotation.maxAge());
        cacheControl.setSMaxAge(annotation.sMaxAge());
        CacheControlExtension[] cacheControlExtensionArray = annotation.extensions();
        int n = cacheControlExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            CacheControlExtension e = cacheControlExtensionArray[n2];
            cacheControl.getCacheExtension().put(e.key(), e.value());
            ++n2;
        }
        return cacheControl;
    }

    private static class CacheResponseFilter
    implements ContainerResponseFilter {
        private final String headerValue;

        CacheResponseFilter(String headerValue) {
            this.headerValue = headerValue;
        }

        public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
            responseContext.getHeaders().putSingle((Object)"Cache-Control", (Object)this.headerValue);
        }
    }
}

