/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.web;

import com.ksoft.web.ErrorMessage;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.log4j.Logger;

@Provider
public class GenericExceptionMapper
implements ExceptionMapper<Throwable> {
    @Context
    UriInfo uriInfo;
    static Logger logger = Logger.getLogger((String)GenericExceptionMapper.class.getName());
    static boolean displayErrorInfo = false;

    public static void setDisplayErrorInfo(boolean displayErrorInfo) {
        GenericExceptionMapper.displayErrorInfo = displayErrorInfo;
    }

    public Response toResponse(Throwable ex) {
        logger.error((Object)("Generic exception occured at " + this.uriInfo.getAbsolutePath()), ex);
        StringWriter errorStackTrace = new StringWriter();
        ex.printStackTrace(new PrintWriter(errorStackTrace));
        logger.error((Object)errorStackTrace.toString());
        ErrorMessage errorMessage = new ErrorMessage();
        if (displayErrorInfo) {
            errorMessage.setMessage(ex.getMessage());
            errorMessage.setFullMessage(errorStackTrace.toString());
        } else {
            errorMessage.setMessage("Error occured");
            errorMessage.setFullMessage("Error occured");
        }
        return Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).entity((Object)errorMessage).type("application/json").build();
    }
}

