/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.web;

import com.ksoft.laps.db.AccountModel;
import com.ksoft.web.AuthFilter;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.Key;
import java.util.List;
import java.util.Map;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;

public class ResponseFilter
implements ContainerResponseFilter {
    @Context
    HttpServletRequest servletContext;
    @Context
    private ResourceInfo resourceInfo;
    static Logger logger = Logger.getLogger((String)ResponseFilter.class.getName());

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        Method method = this.resourceInfo.getResourceMethod();
        if (method == null) {
            return;
        }
        if (method.isAnnotationPresent(PermitAll.class)) {
            return;
        }
        if (method.isAnnotationPresent(DenyAll.class)) {
            return;
        }
        if (requestContext.getUriInfo().getRequestUri().toString().toLowerCase().endsWith("/logout")) {
            return;
        }
        if (requestContext.getUriInfo().getRequestUri().toString().toLowerCase().contains("/mobile")) {
            return;
        }
        if (requestContext.getUriInfo().getRequestUri().toString().toLowerCase().contains("/remotepc")) {
            return;
        }
        if (!responseContext.getStatusInfo().equals(Response.Status.OK)) {
            return;
        }
        String ip = AuthFilter.getSourceIP(this.servletContext);
        MultivaluedMap headers = requestContext.getHeaders();
        List authHeaders = (List)headers.get((Object)"X-Token");
        Map cookies = requestContext.getCookies();
        if (cookies.containsKey("X-Token")) {
            String token = ((Cookie)cookies.get("X-Token")).getValue();
            try {
                Claims claims;
                if (!token.isEmpty() && !(claims = (Claims)Jwts.parser().setAllowedClockSkewSeconds(60L).setSigningKey((Key)AuthFilter.getPublicKey()).parseClaimsJws(token).getBody()).containsKey((Object)"peerType")) {
                    String login = claims.getSubject();
                    Object roles = claims.get((Object)"roles");
                    if (login != null && !login.isEmpty()) {
                        int tokenExpirationMinutes = AuthFilter.getTokenExpirationMinutes();
                        String newToken = AccountModel.generateJWTtoken(AuthFilter.getPrivateKey(), login, roles, ip, tokenExpirationMinutes);
                        NewCookie authCookie = new NewCookie("X-Token", newToken, "/", null, null, AuthFilter.tokenExpirationMinutes * 60, AuthFilter.IS_SECURE, true);
                        responseContext.getHeaders().add((Object)"Set-Cookie", (Object)authCookie);
                    }
                }
            }
            catch (Exception e) {
                logger.debug((Object)"InvalidClaimException, this is OK in case of node registration process", (Throwable)e);
            }
        }
    }
}

