/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.web;

import com.ksoft.laps.core.LapsLauncher;
import com.ksoft.laps.core.SettingsManager;
import com.ksoft.laps.db.SettingModel;
import com.ksoft.tls.TlsHelper;
import com.ksoft.web.AuthFilter;
import com.ksoft.web.CORSFilter;
import com.ksoft.web.GenericExceptionMapper;
import com.ksoft.web.MyDoSServletFilter;
import java.io.IOException;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.eclipse.jetty.rewrite.handler.RewriteHandler;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.glassfish.jersey.servlet.ServletContainer;

public class WebServer {
    private Server server;
    private Server remoteComputersServer;
    static Logger logger = Logger.getLogger((String)WebServer.class.getName());
    boolean isRemotePCserverEnabled = false;

    public WebServer(int sslport) {
        HandlerList contexts = new HandlerList();
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/api");
        ServletHolder jerseyServlet = context.addServlet(ServletContainer.class, "/*");
        jerseyServlet.setInitOrder(0);
        jerseyServlet.setInitParameter("javax.ws.rs.Application", "com.ksoft.web.WebApplication");
        jerseyServlet.setInitParameter("com.sun.jersey.api.json.POJOMappingFeature", "true");
        ServletContextHandler staticCcontext = new ServletContextHandler(1);
        staticCcontext.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        staticCcontext.setContextPath("/web");
        staticCcontext.setWelcomeFiles(new String[]{"index.html"});
        staticCcontext.setResourceBase(String.valueOf(SettingsManager.getBaseFolder()) + "UI");
        staticCcontext.addServlet(DefaultServlet.class, "/*");
        FilterHolder ddosHolder = new FilterHolder(MyDoSServletFilter.class);
        ddosHolder.setInitParameter("maxRequestsPerSec", String.valueOf(SettingModel.getInt("network:laps_req_per_sec", 1)));
        ddosHolder.setInitParameter("delayMs", "-1");
        ddosHolder.setInitParameter("remotePort", "false");
        EnumSet<DispatcherType> SCOPE = EnumSet.of(DispatcherType.REQUEST);
        context.addFilter("com.ksoft.web.UserServletFilter", "/laps/password/*", SCOPE);
        context.addFilter("com.ksoft.web.UserServletFilter", "/laps/expire", SCOPE);
        context.addFilter("com.ksoft.web.UserServletFilter", "/laps/passwordbyotp", SCOPE);
        context.addFilter(ddosHolder, "/laps/password/*", SCOPE);
        context.addFilter(ddosHolder, "/laps/passwordbyotp", SCOPE);
        context.addFilter(ddosHolder, "/laps/expire", SCOPE);
        context.addFilter(ddosHolder, "/account/auth", SCOPE);
        context.addFilter(ddosHolder, "/account/logout", SCOPE);
        context.addFilter(ddosHolder, "/v1/secret/get/*", SCOPE);
        FilterHolder corsHolder = new FilterHolder(CORSFilter.class);
        context.addFilter(corsHolder, "/mobile/*", SCOPE);
        boolean showStackTrace = SettingModel.getBool("network:show_stacktrace");
        GenericExceptionMapper.setDisplayErrorInfo(showStackTrace);
        RewriteHandler rewriteHandler = new RewriteHandler();
        rewriteHandler.addRule(new Rule(){

            public String matchAndApply(String target, HttpServletRequest request, HttpServletResponse response) throws IOException {
                if (target.startsWith("/api/") || target.startsWith("/web/app/") || target.startsWith("/web/vendor/") || target.startsWith("/ws/") || target.startsWith("/web/app.js")) {
                    return null;
                }
                return "/web/index.html";
            }
        });
        rewriteHandler.setHandler((Handler)staticCcontext);
        contexts.setHandlers(new Handler[]{rewriteHandler, context});
        this.server = new Server();
        ServerConnector connector = null;
        ServerConnector tlsConnector = null;
        if (sslport > 0) {
            HttpConfiguration https = new HttpConfiguration();
            https.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            if (SettingModel.getBool("network:enable_forwarded")) {
                https.addCustomizer((HttpConfiguration.Customizer)new ForwardedRequestCustomizer());
            }
            https.setSendServerVersion(false);
            https.setSendXPoweredBy(false);
            tlsConnector = new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory(TlsHelper.getSslContextFactory(), "http/1.1"), new HttpConnectionFactory(https)});
            tlsConnector.setPort(sslport);
            this.server.addConnector((Connector)tlsConnector);
            AuthFilter.IS_SECURE = true;
        }
        if (LapsLauncher.debugMobile) {
            HttpConfiguration http = new HttpConfiguration();
            http.setSendServerVersion(false);
            http.setSendXPoweredBy(false);
            HttpConnectionFactory httpFactory = new HttpConnectionFactory(http);
            connector = new ServerConnector(this.server, new ConnectionFactory[]{httpFactory});
            int mobilePort = 54545;
            connector.setPort(mobilePort);
            this.server.addConnector((Connector)connector);
            AuthFilter.IS_SECURE = false;
            logger.info((Object)("Rest Server initialized for mobile app debug. Non secure server at port " + mobilePort));
        }
        this.initAuthFilter();
        this.server.setHandler((Handler)contexts);
        logger.info((Object)("Rest Server init completed (TLSv1.2). Started on port " + sslport));
        Integer sslportRemotePC = SettingModel.getInt("computers_agent:server_port", 0);
        if (sslportRemotePC != null && sslportRemotePC > 0 && sslportRemotePC != sslport) {
            HandlerList remotePCcontexts = new HandlerList();
            ServletContextHandler remotePCcontext = new ServletContextHandler(1);
            remotePCcontext.setContextPath("/api");
            ServletHolder jerseyServletRemotePC = remotePCcontext.addServlet(ServletContainer.class, "/*");
            jerseyServletRemotePC.setInitOrder(0);
            jerseyServletRemotePC.setInitParameter("javax.ws.rs.Application", "com.ksoft.web.WebApplicationRemoteComputer");
            jerseyServletRemotePC.setInitParameter("com.sun.jersey.api.json.POJOMappingFeature", "true");
            remotePCcontexts.setHandlers(new Handler[]{remotePCcontext});
            this.remoteComputersServer = new Server();
            HttpConfiguration httpsRemoteComputers = new HttpConfiguration();
            httpsRemoteComputers.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            if (SettingModel.getBool("network:enable_forwarded")) {
                httpsRemoteComputers.addCustomizer((HttpConfiguration.Customizer)new ForwardedRequestCustomizer());
            }
            httpsRemoteComputers.setSendServerVersion(false);
            httpsRemoteComputers.setSendXPoweredBy(false);
            ServerConnector tlsRemoteComputerConnector = new ServerConnector(this.remoteComputersServer, new ConnectionFactory[]{new SslConnectionFactory(TlsHelper.getSslContextFactory(), "http/1.1"), new HttpConnectionFactory(httpsRemoteComputers)});
            tlsRemoteComputerConnector.setPort(sslportRemotePC.intValue());
            this.remoteComputersServer.addConnector((Connector)tlsRemoteComputerConnector);
            this.remoteComputersServer.setHandler((Handler)remotePCcontexts);
            logger.info((Object)("Rest Server for remote computers completed (TLSv1.2). Started on port " + sslportRemotePC));
            this.isRemotePCserverEnabled = true;
        }
    }

    private void initAuthFilter() {
        AuthFilter.tokenExpirationMinutes = SettingModel.getInt("token:user_expiration_minutes", 15);
    }

    public boolean start() {
        boolean result = false;
        try {
            logger.info((Object)"Rest Server starting");
            this.server.start();
            if (this.isRemotePCserverEnabled) {
                this.remoteComputersServer.start();
            }
            logger.info((Object)"Rest Server started");
            result = true;
        }
        catch (Exception e) {
            logger.error((Object)"EngineServer start error", (Throwable)e);
        }
        return result;
    }
}

