/*
 * Decompiled with CFR 0.152.
 */
package com.lespea.cef;

import com.lespea.cef.Extension;
import com.lespea.cef.InvalidField;
import com.lespea.cef.utils.StringUtils;
import java.io.Serializable;

public class CEF
implements Serializable {
    public static final int DEFAULT_CEF_VERSION = 0;
    private static final int FIELD_SIZE_GUESS = 50;
    public static final int MAX_SEVERITY = 10;
    public static final int MIN_SEVERITY = 0;
    private static final long serialVersionUID = 1L;
    private final String asString;
    private final int cefVersion;
    private final Extension extension;
    private final int hashCode;
    private final String id;
    private final String name;
    private final String product;
    private final int severity;
    private final String vendor;
    private final String version;

    public CEF(String vendor, String product, String version, int id, String name, int severity, Extension extension) throws InvalidField {
        this(vendor, product, version, Integer.toString(id), name, severity, extension);
    }

    public CEF(String vendor, String product, String version, String id, String name, int severity, Extension extension) throws InvalidField {
        this(0, vendor, product, version, id, name, severity, extension);
    }

    public CEF(int cefVersion, String vendor, String product, String version, String id, String name, int severity, Extension extension) throws InvalidField {
        this.cefVersion = cefVersion;
        this.vendor = vendor;
        this.product = product;
        this.version = version;
        this.id = id;
        this.name = name;
        this.severity = severity;
        this.extension = extension;
        assert (vendor != null) : "The vendor cannot be null";
        assert (product != null) : "The product cannot be null";
        assert (version != null) : "The version cannot be null";
        assert (id != null) : "The id cannot be null";
        assert (name != null) : "The name cannot be null";
        assert (extension != null) : "The extension cannot be null";
        assert (severity >= 0 && severity <= 10) : "The severity must be between 0 and 10";
        StringBuilder sb = new StringBuilder(50 + extension.toString().length());
        sb.append("CEF:");
        sb.append(cefVersion);
        sb.append("|");
        sb.append(StringUtils.escapeField(vendor));
        sb.append("|");
        sb.append(StringUtils.escapeField(product));
        sb.append("|");
        sb.append(StringUtils.escapeField(version));
        sb.append("|");
        sb.append(StringUtils.escapeField(id));
        sb.append("|");
        sb.append(StringUtils.escapeField(name));
        sb.append("|");
        sb.append(severity);
        sb.append("|");
        sb.append(extension);
        this.asString = sb.toString();
        this.hashCode = this.asString.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CEF other = (CEF)obj;
        if (this.cefVersion != other.getCefVersion()) {
            return false;
        }
        if (!this.id.equals(other.getId())) {
            return false;
        }
        if (!this.name.equals(other.getName())) {
            return false;
        }
        if (!this.product.equals(other.getProduct())) {
            return false;
        }
        if (this.severity != other.getSeverity()) {
            return false;
        }
        if (!this.vendor.equals(other.getVendor())) {
            return false;
        }
        if (!this.version.equals(other.getVersion())) {
            return false;
        }
        return this.extension.equals(other.getExtension());
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.asString;
    }

    public int getCefVersion() {
        return this.cefVersion;
    }

    public Extension getExtension() {
        return this.extension;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getProduct() {
        return this.product;
    }

    public int getSeverity() {
        return this.severity;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getVersion() {
        return this.version;
    }
}

