/*
 * Decompiled with CFR 0.152.
 */
package com.lespea.cef;

import com.lespea.cef.InvalidExtensionKey;
import com.lespea.cef.utils.StringUtils;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class Extension
implements Serializable {
    static Logger LOG = Logger.getLogger((String)Extension.class.getName());
    private static final long serialVersionUID = 1L;
    private final String asString;
    private final Map<String, String> fields;
    private final int hashCode;

    public Extension(Map<String, String> extensionFields) throws InvalidExtensionKey {
        StringBuilder sb = new StringBuilder(extensionFields.size() * 20);
        Boolean first = true;
        for (Map.Entry<String, String> entry : extensionFields.entrySet()) {
            if (first.booleanValue()) {
                first = false;
            } else {
                sb.append(" ");
            }
            sb.append(StringUtils.escapeExtensionKey(entry.getKey()));
            sb.append("=");
            sb.append(StringUtils.escapeExtensionValue(entry.getValue()));
        }
        this.fields = Collections.unmodifiableMap(extensionFields);
        LOG.debug((Object)("The extension's string was calculated as " + sb.toString()));
        this.asString = sb.toString();
        this.hashCode = this.fields.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.fields.equals(((Extension)obj).getFields());
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.asString;
    }

    public Map<String, String> getFields() {
        return new HashMap<String, String>(this.fields);
    }
}

