/*
 * Decompiled with CFR 0.152.
 */
package com.lespea.cef.utils;

import com.lespea.cef.InvalidExtensionKey;
import com.lespea.cef.InvalidField;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public final class StringUtils {
    static Logger LOG = Logger.getLogger((String)StringUtils.class.getName());
    private static final Pattern INVALID_FIELD_PATTERN = Pattern.compile("[\r\n]");
    private static final Pattern INVALID_EXTENSION_KEY_PATTERN = Pattern.compile("\\s");
    private static final Pattern ESCAPE_FIELD_PATTERN = Pattern.compile("([|\\\\])");
    private static final Pattern ESCAPE_EXTENSION_VALUE_PATTERN = Pattern.compile("[=\r\n]");
    private static final Pattern ESCAPE_EXTENSION_KEY_PATTERN = Pattern.compile("=");

    private StringUtils() {
    }

    public static String escapeExtensionKey(String keyStr) throws InvalidExtensionKey {
        if (keyStr == null) {
            LOG.warn((Object)"Tried to escape a null CEF extension key");
            return null;
        }
        if (INVALID_EXTENSION_KEY_PATTERN.matcher(keyStr).find()) {
            LOG.error((Object)"The field string contained an invalid character");
            throw new InvalidExtensionKey("The field string " + keyStr + " contained an invalid character");
        }
        String escapedStr = ESCAPE_EXTENSION_KEY_PATTERN.matcher(keyStr).replaceAll("\\\\=");
        LOG.debug((Object)("The CEF extension key \"{" + keyStr + "}\" was escaped to \"{" + escapedStr + "}\""));
        return escapedStr;
    }

    public static String escapeExtensionValue(String valueStr) {
        if (valueStr == null) {
            LOG.warn((Object)"Tried to escape a null CEF extension value");
            return null;
        }
        Matcher matcher = ESCAPE_EXTENSION_VALUE_PATTERN.matcher(valueStr);
        StringBuffer escapedStrBuf = new StringBuffer(valueStr.length());
        while (matcher.find()) {
            String replacement;
            char letter = matcher.group(0).charAt(0);
            switch (letter) {
                case '\r': {
                    replacement = "\\\\r";
                    break;
                }
                case '\n': {
                    replacement = "\\\\n";
                    break;
                }
                case '\\': {
                    replacement = "\\\\\\\\";
                    break;
                }
                default: {
                    replacement = "\\\\" + letter;
                }
            }
            matcher.appendReplacement(escapedStrBuf, replacement);
        }
        matcher.appendTail(escapedStrBuf);
        String escapedStr = escapedStrBuf.toString();
        LOG.debug((Object)("The CEF extension value \"{" + valueStr + "}\" was escaped to \"{" + escapedStr + "}\""));
        return escapedStr;
    }

    public static String escapeField(String fieldStr) throws InvalidField {
        if (fieldStr == null) {
            LOG.warn((Object)"Tried to escape a null CEF field");
            return null;
        }
        if (INVALID_FIELD_PATTERN.matcher(fieldStr).find()) {
            LOG.error((Object)"The field string contained an invalid character");
            throw new InvalidField("The field string " + fieldStr + " contained an invalid character");
        }
        String escapedStr = ESCAPE_FIELD_PATTERN.matcher(fieldStr).replaceAll("\\\\$1");
        LOG.debug((Object)("The CEF field \"{" + fieldStr + "}\" was escaped to \"{" + escapedStr + "}\""));
        return escapedStr;
    }

    public static Boolean isValidExtensionKey(String extensionKeyStr) {
        Boolean isValid;
        if (extensionKeyStr == null) {
            LOG.warn((Object)"Tried to detect if a null string was a valid extension key string");
            isValid = false;
        } else {
            isValid = INVALID_EXTENSION_KEY_PATTERN.matcher(extensionKeyStr).find() ? Boolean.valueOf(false) : Boolean.valueOf(true);
        }
        return isValid;
    }

    public static Boolean isValidExtensionValue(String extensionValueStr) {
        if (extensionValueStr == null) {
            LOG.warn((Object)"Tried to detect if a null string was a valid extension value string");
            return false;
        }
        LOG.debug((Object)("The extension value \"{" + extensionValueStr + "}\" is valid"));
        return true;
    }

    public static Boolean isValidField(String fieldStr) {
        Boolean isValid;
        if (fieldStr == null) {
            LOG.warn((Object)"Tried to detect if a null string was a valid field string");
            isValid = false;
        } else {
            isValid = INVALID_FIELD_PATTERN.matcher(fieldStr).find() ? Boolean.valueOf(false) : Boolean.valueOf(true);
        }
        return isValid;
    }
}

