/*
 * Decompiled with CFR 0.152.
 */
package com.github.cage;

import com.github.cage.IGenerator;
import com.github.cage.ObjectRoulette;
import com.github.cage.image.Painter;
import com.github.cage.image.RgbColorGenerator;
import com.github.cage.token.RandomTokenGenerator;
import java.awt.Color;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Random;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cage {
    public static final Float DEFAULT_COMPRESS_RATIO = Float.valueOf(0.5f);
    public static final String DEFAULT_FORMAT = "jpeg";
    private final Painter painter;
    private final IGenerator<Font> fonts;
    private final IGenerator<Color> foregrounds;
    private final String format;
    private final Float compressRatio;
    private final IGenerator<String> tokenGenerator;

    public Cage() {
        this(null, null, null, null, DEFAULT_COMPRESS_RATIO, null, null);
    }

    public Cage(Painter painter, IGenerator<Font> fonts, IGenerator<Color> foregrounds, String format, Float compressRatio, IGenerator<String> tokenGenerator, Random rnd) {
        if (rnd == null) {
            rnd = new Random();
        }
        this.painter = painter != null ? painter : new Painter(rnd);
        int defFontHeight = this.painter.getHeight() / 2;
        this.fonts = fonts != null ? fonts : new ObjectRoulette<Font>(rnd, new Font("SansSerif", 0, defFontHeight), new Font("Serif", 0, defFontHeight), new Font("Monospaced", 1, defFontHeight));
        this.foregrounds = foregrounds != null ? foregrounds : new RgbColorGenerator(rnd);
        this.format = format != null ? format : DEFAULT_FORMAT;
        this.compressRatio = compressRatio;
        this.tokenGenerator = tokenGenerator != null ? tokenGenerator : new RandomTokenGenerator(rnd);
    }

    public void draw(String text, OutputStream ostream) throws IOException {
        BufferedImage img = this.drawImage(text);
        this.serialize(img, ostream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] draw(String text) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            try {
                this.draw(text, baos);
            }
            finally {
                baos.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("IO error while writing captcha image to memory.", e);
        }
        return baos.toByteArray();
    }

    public BufferedImage drawImage(String text) {
        Font font = this.fonts.next();
        Color fground = this.foregrounds.next();
        return this.painter.draw(font, fground, text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serialize(BufferedImage img, OutputStream ostream) throws IOException {
        ImageTypeSpecifier type = ImageTypeSpecifier.createFromRenderedImage(img);
        Iterator<ImageWriter> iwi = ImageIO.getImageWriters(type, this.format);
        if (iwi == null || !iwi.hasNext()) {
            throw new IllegalStateException("No image writer found for format = " + this.format);
        }
        ImageWriter iw = iwi.next();
        try {
            ImageWriteParam iwp;
            if (this.compressRatio != null) {
                iwp = iw.getDefaultWriteParam();
                iwp.setCompressionMode(2);
                iwp.setCompressionQuality(this.compressRatio.floatValue());
            } else {
                iwp = null;
            }
            ImageOutputStream ios = ImageIO.createImageOutputStream(ostream);
            try {
                iw.setOutput(ios);
                iw.write(null, new IIOImage(img, null, null), iwp);
            }
            finally {
                ios.close();
            }
        }
        finally {
            iw.dispose();
        }
    }

    public Painter getPainter() {
        return this.painter;
    }

    public IGenerator<Font> getFonts() {
        return this.fonts;
    }

    public IGenerator<Color> getForegrounds() {
        return this.foregrounds;
    }

    public String getFormat() {
        return this.format;
    }

    public Float getCompressRatio() {
        return this.compressRatio;
    }

    public IGenerator<String> getTokenGenerator() {
        return this.tokenGenerator;
    }
}

