/*
 * Decompiled with CFR 0.152.
 */
package com.github.cage.image;

import com.github.cage.image.EffectConfig;
import com.github.cage.image.Rippler;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.util.Random;

public class Painter {
    public static final int DEFAULT_WIDTH = 200;
    public static final int DEFAULT_HEIGHT = 70;
    private final int width;
    private final int height;
    private final Color background;
    private final Quality quality;
    private final EffectConfig effectConfig;
    private final Random rnd;

    public Painter() {
        this(200, 70, null, null, null, null);
    }

    public Painter(Random rnd) {
        this(200, 70, null, null, null, rnd);
    }

    public Painter(int width, int height, Color bGround, Quality quality, EffectConfig effectConfig, Random rnd) {
        this.width = width;
        this.height = height;
        this.background = bGround != null ? bGround : Color.WHITE;
        this.quality = quality != null ? quality : Quality.MAX;
        this.effectConfig = effectConfig != null ? effectConfig : new EffectConfig();
        this.rnd = rnd != null ? rnd : new Random();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage draw(Font font, Color fGround, String text) {
        if (font == null) {
            throw new IllegalArgumentException("Font can not be null.");
        }
        if (fGround == null) {
            throw new IllegalArgumentException("Foreground color can not be null.");
        }
        if (text == null || text.length() < 1) {
            throw new IllegalArgumentException("No text given.");
        }
        BufferedImage img = this.createImage();
        Graphics g = img.getGraphics();
        try {
            Graphics2D g2 = this.configureGraphics(g, font, fGround);
            this.draw(g2, text);
        }
        finally {
            g.dispose();
        }
        img = this.postProcess(img);
        return img;
    }

    protected BufferedImage createImage() {
        return new BufferedImage(this.width, this.height, 5);
    }

    protected Graphics2D configureGraphics(Graphics g, Font font, Color fGround) {
        if (!(g instanceof Graphics2D)) {
            throw new IllegalStateException("Graphics (" + g + ") that is not an instance of Graphics2D.");
        }
        Graphics2D g2 = (Graphics2D)g;
        this.configureGraphicsQuality(g2);
        g2.setColor(fGround);
        g2.setBackground(this.background);
        g2.setFont(font);
        g2.clearRect(0, 0, this.width, this.height);
        return g2;
    }

    protected void configureGraphicsQuality(Graphics2D g2) {
        if (this.quality == Quality.MAX) {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            g2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        } else if (this.quality == Quality.MIN) {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
            g2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        }
    }

    protected void draw(Graphics2D g, String text) {
        GlyphVector vector = g.getFont().createGlyphVector(g.getFontRenderContext(), text);
        this.transform(g, text, vector);
        Rectangle bounds = vector.getPixelBounds(null, 0.0f, this.height);
        float bw = (float)bounds.getWidth();
        float bh = (float)bounds.getHeight();
        boolean outlineEnabled = this.effectConfig.isOutlineEnabled();
        float wr = (float)this.width / bw * (this.rnd.nextFloat() / 20.0f + (outlineEnabled ? 0.89f : 0.92f)) * this.effectConfig.getScaleConfig().getX();
        float hr = (float)this.height / bh * (this.rnd.nextFloat() / 20.0f + (outlineEnabled ? 0.68f : 0.75f)) * this.effectConfig.getScaleConfig().getY();
        g.translate(((float)this.width - bw * wr) / 2.0f, ((float)this.height - bh * hr) / 2.0f);
        g.scale(wr, hr);
        float bx = (float)bounds.getX();
        float by = (float)bounds.getY();
        if (outlineEnabled) {
            g.draw(vector.getOutline(Math.signum(this.rnd.nextFloat() - 0.5f) * 1.0f * (float)this.width / 200.0f - bx, Math.signum(this.rnd.nextFloat() - 0.5f) * 1.0f * (float)this.height / 70.0f + (float)this.height - by));
        }
        g.drawGlyphVector(vector, -bx, (float)this.height - by);
    }

    protected void transform(Graphics2D g, String text, GlyphVector v) {
        int glyphNum = v.getNumGlyphs();
        Point2D.Double prePos = null;
        RectangularShape preBounds = null;
        double rotateCur = (this.rnd.nextDouble() - 0.5) * Math.PI / 8.0;
        double rotateStep = Math.signum(rotateCur) * (this.rnd.nextDouble() * 3.0 * Math.PI / 8.0 / (double)glyphNum);
        boolean rotateEnabled = this.effectConfig.isRotateEnabled();
        for (int fi = 0; fi < glyphNum; ++fi) {
            if (rotateEnabled) {
                AffineTransform tr = AffineTransform.getRotateInstance(rotateCur);
                if (this.rnd.nextDouble() < 0.25) {
                    rotateStep *= -1.0;
                }
                rotateCur += rotateStep;
                v.setGlyphTransform(fi, tr);
            }
            Point2D pos = v.getGlyphPosition(fi);
            Rectangle2D bounds = v.getGlyphVisualBounds(fi).getBounds2D();
            Point2D.Double newPos = prePos == null ? new Point2D.Double(pos.getX() - bounds.getX(), pos.getY()) : new Point2D.Double(preBounds.getMaxX() + pos.getX() - bounds.getX() - Math.min(preBounds.getWidth(), bounds.getWidth()) * (this.rnd.nextDouble() / 20.0 + (rotateEnabled ? 0.27 : 0.1)), pos.getY());
            v.setGlyphPosition(fi, newPos);
            prePos = newPos;
            preBounds = v.getGlyphVisualBounds(fi).getBounds2D();
        }
    }

    protected BufferedImage postProcess(BufferedImage img) {
        if (this.effectConfig.isRippleEnabled()) {
            Rippler.AxisConfig vertical = new Rippler.AxisConfig(this.rnd.nextDouble() * 2.0 * Math.PI, (1.0 + this.rnd.nextDouble() * 2.0) * Math.PI, (double)img.getHeight() / 10.0);
            Rippler.AxisConfig horizontal = new Rippler.AxisConfig(this.rnd.nextDouble() * 2.0 * Math.PI, (2.0 + this.rnd.nextDouble() * 2.0) * Math.PI, (double)img.getWidth() / 100.0);
            Rippler op = new Rippler(vertical, horizontal);
            img = op.filter(img, this.createImage());
        }
        if (this.effectConfig.isBlurEnabled()) {
            float[] blurArray = new float[9];
            this.fillBlurArray(blurArray);
            ConvolveOp op = new ConvolveOp(new Kernel(3, 3, blurArray), 1, null);
            img = op.filter(img, this.createImage());
        }
        return img;
    }

    protected void fillBlurArray(float[] array) {
        int fi;
        float sum = 0.0f;
        for (fi = 0; fi < array.length; ++fi) {
            array[fi] = this.rnd.nextFloat();
            sum += array[fi];
        }
        fi = 0;
        while (fi < array.length) {
            int n = fi++;
            array[n] = array[n] / sum;
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Color getBackground() {
        return this.background;
    }

    public Quality getQuality() {
        return this.quality;
    }

    public EffectConfig getEffectConfig() {
        return this.effectConfig;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Quality {
        MIN,
        DEFAULT,
        MAX;

    }
}

