/*
 * Decompiled with CFR 0.152.
 */
package com.github.cage.token;

import com.github.cage.IGenerator;
import com.github.cage.IGeneratorFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomCharacterGeneratorFactory
implements IGeneratorFactory<Character> {
    public static final char[] ENGLISH_VOWELS = "aeiou".toCharArray();
    public static final char[] ENGLISH_CONSONANTS = "bcdfghjklmnpqrstxyvz".toCharArray();
    public static final char[] ARABIC_NUMERALS = "0123456789".toCharArray();
    public static final char[] DEFAULT_DEFAULT_CHARACTER_SET = (new String(ENGLISH_VOWELS) + new String(ENGLISH_CONSONANTS)).toCharArray();
    public static final Map<Character, char[]> DEFAULT_SPECIAL_CHARACTER_SETS = Collections.unmodifiableMap(RandomCharacterGeneratorFactory.createDefaultSpecialCharacterSets());
    private final char[] defaultCharacterSet;
    private final Map<Character, char[]> specialCharacterSets;
    private final Random rnd;

    public RandomCharacterGeneratorFactory() {
        this(null);
    }

    public RandomCharacterGeneratorFactory(Random rnd) {
        this(null, DEFAULT_SPECIAL_CHARACTER_SETS, rnd);
    }

    public RandomCharacterGeneratorFactory(char[] defaultCharacterSet, Map<Character, char[]> specialCharacterSets, Random rnd) {
        this.defaultCharacterSet = defaultCharacterSet != null && defaultCharacterSet.length > 0 ? defaultCharacterSet : DEFAULT_DEFAULT_CHARACTER_SET;
        this.specialCharacterSets = specialCharacterSets != null && !specialCharacterSets.isEmpty() ? specialCharacterSets : null;
        this.rnd = rnd != null ? rnd : new Random();
    }

    protected static Map<Character, char[]> createDefaultSpecialCharacterSets() {
        HashMap<Character, char[]> m = new HashMap<Character, char[]>();
        char[] con = ENGLISH_CONSONANTS;
        String conS = new String(con);
        char[] vow = ENGLISH_VOWELS;
        String vowS = new String(vow);
        m.put(Character.valueOf('a'), con);
        m.put(Character.valueOf('b'), vow);
        m.put(Character.valueOf('c'), vowS.replaceAll("o", "").toCharArray());
        m.put(Character.valueOf('d'), vowS.replaceAll("o", "").toCharArray());
        m.put(Character.valueOf('e'), con);
        m.put(Character.valueOf('f'), vow);
        m.put(Character.valueOf('g'), vow);
        m.put(Character.valueOf('h'), vow);
        m.put(Character.valueOf('i'), conS.replaceAll("j|l", "").toCharArray());
        m.put(Character.valueOf('j'), vowS.replaceAll("i", "").toCharArray());
        m.put(Character.valueOf('k'), vow);
        m.put(Character.valueOf('l'), vowS.replaceAll("i|o", "").toCharArray());
        m.put(Character.valueOf('m'), vow);
        m.put(Character.valueOf('n'), vowS.replaceAll("u", "").toCharArray());
        m.put(Character.valueOf('o'), conS.replaceAll("b|l|p", "").toCharArray());
        m.put(Character.valueOf('p'), vow);
        m.put(Character.valueOf('q'), vowS.replaceAll("o", "").toCharArray());
        m.put(Character.valueOf('r'), vowS.replaceAll("u", "").toCharArray());
        m.put(Character.valueOf('s'), vow);
        m.put(Character.valueOf('t'), vow);
        m.put(Character.valueOf('u'), con);
        m.put(Character.valueOf('v'), vow);
        m.put(Character.valueOf('w'), vow);
        m.put(Character.valueOf('x'), vow);
        m.put(Character.valueOf('y'), vow);
        m.put(Character.valueOf('z'), vow);
        return m;
    }

    @Override
    public IGenerator<Character> next() {
        return new RandomCharacterGenerator();
    }

    public char[] getDefaultCharacterSet() {
        return this.defaultCharacterSet;
    }

    public Map<Character, char[]> getSpecialCharacterSets() {
        return this.specialCharacterSets;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RandomCharacterGenerator
    implements IGenerator<Character> {
        private char[] currentCharacterSet;

        public RandomCharacterGenerator() {
            this.currentCharacterSet = RandomCharacterGeneratorFactory.this.defaultCharacterSet;
        }

        @Override
        public Character next() {
            char next = this.currentCharacterSet[RandomCharacterGeneratorFactory.this.rnd.nextInt(this.currentCharacterSet.length)];
            if (RandomCharacterGeneratorFactory.this.specialCharacterSets != null) {
                char[] nextCharacterSet = (char[])RandomCharacterGeneratorFactory.this.specialCharacterSets.get(Character.valueOf(next));
                if (nextCharacterSet != null) {
                    if (nextCharacterSet.length < 1) {
                        throw new IllegalStateException("specialCharacterSets should not hold an empty char[] value");
                    }
                    this.currentCharacterSet = nextCharacterSet;
                } else {
                    this.currentCharacterSet = RandomCharacterGeneratorFactory.this.defaultCharacterSet;
                }
            }
            return Character.valueOf(next);
        }
    }
}

