/*
 * Decompiled with CFR 0.152.
 */
package com.github.cage.token;

import com.github.cage.IGenerator;
import com.github.cage.IGeneratorFactory;
import com.github.cage.token.RandomCharacterGeneratorFactory;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomTokenGenerator
implements IGenerator<String> {
    protected static final int DEFAULT_TOKEN_LEN_MIN = 8;
    protected static final int DEFAULT_TOKEN_LEN_DELTA = 2;
    private final IGeneratorFactory<Character> characterGeneratorFactory;
    private final int minLength;
    private final int delta;
    private final Random rnd;

    public RandomTokenGenerator() {
        this(null);
    }

    public RandomTokenGenerator(Random rnd) {
        this(rnd, 8, 2);
    }

    public RandomTokenGenerator(Random rnd, int length) {
        this(rnd, length, 0);
    }

    public RandomTokenGenerator(Random rnd, int minLength, int delta) {
        this(rnd, new RandomCharacterGeneratorFactory(rnd != null ? rnd : new Random()), minLength, delta);
    }

    public RandomTokenGenerator(Random rnd, IGeneratorFactory<Character> characterGeneratorFactory, int minLength, int delta) {
        this.characterGeneratorFactory = characterGeneratorFactory != null ? characterGeneratorFactory : new RandomCharacterGeneratorFactory();
        this.minLength = Math.abs(minLength);
        this.delta = Math.abs(delta);
        this.rnd = rnd != null ? rnd : new Random();
    }

    @Override
    public String next() {
        int length = (this.delta <= 1 ? 0 : this.rnd.nextInt(this.delta) + 1) + this.minLength;
        char[] word = new char[length];
        IGenerator generator = (IGenerator)this.characterGeneratorFactory.next();
        for (int fi = 0; fi < word.length; ++fi) {
            word[fi] = ((Character)generator.next()).charValue();
        }
        return new String(word);
    }

    public IGeneratorFactory<Character> getCharacterGeneratorFactory() {
        return this.characterGeneratorFactory;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getDelta() {
        return this.delta;
    }
}

