/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.linking;

import java.util.HashMap;
import java.util.Map;
import org.glassfish.jersey.linking.Binding;
import org.glassfish.jersey.linking.InjectLink;
import org.glassfish.jersey.linking.InjectLinkDescriptor;
import org.glassfish.jersey.linking.InjectLinkFieldDescriptor;
import org.glassfish.jersey.linking.mapping.ResourceMappingContext;

class LinkHeaderDescriptor
implements InjectLinkDescriptor {
    private InjectLink linkHeader;
    private Map<String, String> bindings;

    LinkHeaderDescriptor(InjectLink linkHeader) {
        this.linkHeader = linkHeader;
        this.bindings = new HashMap<String, String>();
        for (Binding binding : linkHeader.bindings()) {
            this.bindings.put(binding.name(), binding.value());
        }
    }

    public InjectLink getLinkHeader() {
        return this.linkHeader;
    }

    @Override
    public String getLinkTemplate(ResourceMappingContext rmc) {
        return InjectLinkFieldDescriptor.getLinkTemplate(rmc, this.linkHeader);
    }

    @Override
    public InjectLink.Style getLinkStyle() {
        return this.linkHeader.style();
    }

    @Override
    public String getBinding(String name) {
        return this.bindings.get(name);
    }

    @Override
    public String getCondition() {
        return this.linkHeader.condition();
    }
}

