/*
 * Decompiled with CFR 0.152.
 */
package liquibase.statement;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.UUID;
import liquibase.change.ColumnConfig;
import liquibase.change.core.LoadDataChange;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.database.PreparedStatementFactory;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.logging.LogService;
import liquibase.logging.LogType;
import liquibase.logging.Logger;
import liquibase.resource.ResourceAccessor;
import liquibase.resource.UtfBomAwareReader;
import liquibase.statement.ExecutablePreparedStatement;
import liquibase.util.JdbcUtils;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtils;
import liquibase.util.file.FilenameUtils;

public abstract class ExecutablePreparedStatementBase
implements ExecutablePreparedStatement {
    private static final Logger LOG = LogService.getLog(ExecutablePreparedStatementBase.class);
    private static ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
    protected Database database;
    private String catalogName;
    private String schemaName;
    private String tableName;
    private List<ColumnConfig> columns;
    private ChangeSet changeSet;
    private Set<Closeable> closeables;
    private ResourceAccessor resourceAccessor;

    protected ExecutablePreparedStatementBase(Database database, String catalogName, String schemaName, String tableName, List<ColumnConfig> columns, ChangeSet changeSet, ResourceAccessor resourceAccessor) {
        this.database = database;
        this.changeSet = changeSet;
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.columns = columns;
        this.changeSet = changeSet;
        this.closeables = new HashSet<Closeable>();
        this.resourceAccessor = resourceAccessor;
    }

    private static InputStream createStream(InputStream in) {
        return in instanceof BufferedInputStream ? in : new BufferedInputStream(in);
    }

    private static Reader createReader(InputStream in, String encoding) {
        return new BufferedReader(StringUtils.trimToNull(encoding) == null ? new UtfBomAwareReader(in) : new UtfBomAwareReader(in, encoding));
    }

    @Override
    public void execute(PreparedStatementFactory factory) throws DatabaseException {
        ArrayList<ColumnConfig> cols = new ArrayList<ColumnConfig>(this.getColumns().size());
        String sql = this.generateSql(cols);
        LOG.info(LogType.WRITE_SQL, sql);
        LOG.debug(LogType.LOG, "Number of columns = " + cols.size());
        PreparedStatement stmt = factory.create(sql);
        try {
            this.attachParams(cols, stmt);
            this.executePreparedStatement(stmt);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            for (Closeable closeable : this.closeables) {
                StreamUtil.closeQuietly(closeable);
            }
            JdbcUtils.closeStatement(stmt);
        }
    }

    protected void executePreparedStatement(PreparedStatement stmt) throws SQLException {
        stmt.execute();
    }

    protected void attachParams(List<ColumnConfig> cols, PreparedStatement stmt) throws SQLException, DatabaseException {
        int i = 1;
        for (ColumnConfig col : cols) {
            LOG.debug(LogType.LOG, "Applying column parameter = " + i + " for column " + col.getName());
            this.applyColumnParameter(stmt, i, col);
            ++i;
        }
    }

    protected abstract String generateSql(List<ColumnConfig> var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void applyColumnParameter(PreparedStatement stmt, int i, ColumnConfig col) throws SQLException, DatabaseException {
        if (col.getValue() != null) {
            LOG.debug(LogType.LOG, "value is string = " + col.getValue());
            if (col.getType() != null && col.getType().equalsIgnoreCase(LoadDataChange.LOAD_DATA_TYPE.UUID.name())) {
                stmt.setObject(i, UUID.fromString(col.getValue()));
                return;
            } else {
                stmt.setString(i, col.getValue());
            }
            return;
        } else if (col.getValueBoolean() != null) {
            LOG.debug(LogType.LOG, "value is boolean = " + col.getValueBoolean());
            stmt.setBoolean(i, col.getValueBoolean());
            return;
        } else if (col.getValueNumeric() != null) {
            LOG.debug(LogType.LOG, "value is numeric = " + col.getValueNumeric());
            Number number = col.getValueNumeric();
            if (number instanceof ColumnConfig.ValueNumeric) {
                ColumnConfig.ValueNumeric valueNumeric = (ColumnConfig.ValueNumeric)number;
                number = valueNumeric.getDelegate();
            }
            if (number instanceof Long) {
                stmt.setLong(i, number.longValue());
                return;
            } else if (number instanceof Integer) {
                stmt.setInt(i, number.intValue());
                return;
            } else if (number instanceof Double) {
                stmt.setDouble(i, number.doubleValue());
                return;
            } else if (number instanceof Float) {
                stmt.setFloat(i, number.floatValue());
                return;
            } else if (number instanceof BigDecimal) {
                stmt.setBigDecimal(i, (BigDecimal)number);
                return;
            } else {
                if (!(number instanceof BigInteger)) throw new UnexpectedLiquibaseException(String.format(coreBundle.getString("jdbc.bind.parameter.unknown.numeric.value.type"), col.getName(), col.getValueNumeric().toString(), col.getValueNumeric().getClass().getName()));
                stmt.setInt(i, number.intValue());
            }
            return;
        } else if (col.getValueDate() != null) {
            LOG.debug(LogType.LOG, "value is date = " + col.getValueDate());
            if (col.getValueDate() instanceof Timestamp) {
                stmt.setTimestamp(i, (Timestamp)col.getValueDate());
                return;
            } else {
                stmt.setDate(i, new Date(col.getValueDate().getTime()));
            }
            return;
        } else if (col.getValueBlobFile() != null) {
            LOG.debug(LogType.LOG, "value is blob = " + col.getValueBlobFile());
            try {
                LOBContent<InputStream> lob = this.toBinaryStream(col.getValueBlobFile());
                if (((LOBContent)lob).length <= Integer.MAX_VALUE) {
                    stmt.setBinaryStream(i, (InputStream)((LOBContent)lob).content, (int)((LOBContent)lob).length);
                    return;
                }
                stmt.setBinaryStream(i, (InputStream)((LOBContent)lob).content, ((LOBContent)lob).length);
                return;
            }
            catch (IOException e) {
                throw new DatabaseException(e.getMessage(), e);
            }
        } else if (col.getValueClobFile() != null) {
            try {
                LOG.debug(LogType.LOG, "value is clob = " + col.getValueClobFile());
                LOBContent<Reader> lob = this.toCharacterStream(col.getValueClobFile(), col.getEncoding());
                if (((LOBContent)lob).length <= Integer.MAX_VALUE) {
                    stmt.setCharacterStream(i, (Reader)((LOBContent)lob).content, (int)((LOBContent)lob).length);
                    return;
                }
                stmt.setCharacterStream(i, (Reader)((LOBContent)lob).content, ((LOBContent)lob).length);
                return;
            }
            catch (IOException e) {
                throw new DatabaseException(e.getMessage(), e);
            }
        } else {
            LOG.debug(LogType.LOG, "value is explicit null");
            stmt.setNull(i, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LOBContent<InputStream> toBinaryStream(String valueLobFile) throws DatabaseException, IOException {
        InputStream in = this.getResourceAsStream(valueLobFile);
        if (in == null) {
            throw new DatabaseException("BLOB resource not found: " + valueLobFile);
        }
        try {
            if (in instanceof FileInputStream) {
                InputStream bufferedInput = ExecutablePreparedStatementBase.createStream(in);
                LOBContent<InputStream> lOBContent = new LOBContent<InputStream>(bufferedInput, ((FileInputStream)in).getChannel().size());
                return lOBContent;
            }
            in = ExecutablePreparedStatementBase.createStream(in);
            int IN_MEMORY_THRESHOLD = 100000;
            if (in.markSupported()) {
                in.mark(100000);
            }
            long length = StreamUtil.getContentLength(in);
            if (in.markSupported() && length <= 100000L) {
                in.reset();
            } else {
                StreamUtil.closeQuietly(in);
                in = this.getResourceAsStream(valueLobFile);
                in = ExecutablePreparedStatementBase.createStream(in);
            }
            LOBContent<InputStream> lOBContent = new LOBContent<InputStream>(in, length);
            return lOBContent;
        }
        finally {
            if (in != null) {
                this.closeables.add(in);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LOBContent<Reader> toCharacterStream(String valueLobFile, String encoding) throws IOException, DatabaseException {
        InputStream in = this.getResourceAsStream(valueLobFile);
        if (in == null) {
            throw new DatabaseException("CLOB resource not found: " + valueLobFile);
        }
        int IN_MEMORY_THRESHOLD = 100000;
        Reader reader = null;
        try {
            reader = ExecutablePreparedStatementBase.createReader(in, encoding);
            if (reader.markSupported()) {
                reader.mark(100000);
            }
            long length = StreamUtil.getContentLength(reader);
            if (reader.markSupported() && length <= 100000L) {
                reader.reset();
            } else {
                StreamUtil.closeQuietly(reader);
                in = this.getResourceAsStream(valueLobFile);
                reader = ExecutablePreparedStatementBase.createReader(in, encoding);
            }
            LOBContent<Reader> lOBContent = new LOBContent<Reader>(reader, length);
            return lOBContent;
        }
        finally {
            if (reader != null) {
                this.closeables.add(reader);
            }
            if (in != null) {
                this.closeables.add(in);
            }
        }
    }

    private InputStream getResourceAsStream(String valueLobFile) throws IOException {
        String fileName = this.getFileName(valueLobFile);
        Set<InputStream> streams = this.resourceAccessor.getResourcesAsStream(fileName);
        if (streams == null || streams.isEmpty()) {
            return null;
        }
        if (streams.size() > 1) {
            for (InputStream stream : streams) {
                stream.close();
            }
            throw new IOException(streams.size() + " matched " + valueLobFile);
        }
        return streams.iterator().next();
    }

    private String getFileName(String fileName) {
        String relativeBaseFileName = this.changeSet.getChangeLog().getPhysicalFilePath();
        String tempFile = FilenameUtils.concat(FilenameUtils.getFullPath(relativeBaseFileName), fileName);
        fileName = tempFile != null ? tempFile : FilenameUtils.getFullPath(relativeBaseFileName) + fileName;
        return fileName;
    }

    public String getAbsolutePath(String path) {
        String p = path;
        File f = new File(p);
        if (!f.isAbsolute()) {
            String basePath = FilenameUtils.getFullPath(this.changeSet.getChangeLog().getPhysicalFilePath());
            p = FilenameUtils.normalize(basePath + p);
        }
        return p;
    }

    @Override
    public boolean skipOnUnsupported() {
        return false;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<ColumnConfig> getColumns() {
        return this.columns;
    }

    private class LOBContent<T> {
        private final T content;
        private final long length;

        LOBContent(T content, long length) {
            this.content = content;
            this.length = length;
        }
    }
}

