/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.auth;

import com.ksoft.auth.IAccountModel;
import com.ksoft.auth.IAuthProvider;
import com.ksoft.core.ISecurityLogger;
import org.apache.log4j.Logger;
import org.json.JSONArray;

public class AuthManager {
    static Logger logger = Logger.getLogger((String)AuthManager.class.getName());
    static ISecurityLogger securityLogger = null;
    boolean requirePasswordExt = true;
    boolean requirePasswordInt = true;
    boolean requireOtpForExternal = false;
    boolean requireOtpForInternal = false;
    IAuthProvider extOtpAuthProvider = null;
    IAuthProvider intOtpAuthProvider = null;
    IAuthProvider extAuthProvider = null;

    public AuthManager(boolean requirePasswordExt, boolean requirePasswordInt, boolean requireOtpForExternal, boolean requireOtpForInternal, IAuthProvider extAuthProvider, IAuthProvider extOTPAuthProvider, IAuthProvider intOTPAuthProvider) {
        this.requirePasswordExt = requirePasswordExt;
        this.requirePasswordInt = requirePasswordInt;
        this.requireOtpForExternal = requireOtpForExternal;
        this.requireOtpForInternal = requireOtpForInternal;
        this.extAuthProvider = extAuthProvider;
        this.extOtpAuthProvider = extOTPAuthProvider;
        this.intOtpAuthProvider = intOTPAuthProvider;
    }

    public AUTHSTATUS authNonExisting(String login, String password, String totp, String source_ip) {
        AUTHSTATUS status = AUTHSTATUS.FAIL;
        logger.debug((Object)("authNonExisting " + login + " started"));
        try {
            if (!this.requireOtpForExternal && !this.requirePasswordExt) {
                throw new Exception("Wrong configuration: password check is false and otp check for external users is false. Login:[" + login + "]");
            }
            if (!this.requireOtpForInternal && !this.requirePasswordInt) {
                throw new Exception("Wrong configuration: password check is false and otp check for internal users is false. Login:[" + login + "]");
            }
            if (this.requireOtpForExternal && this.extOtpAuthProvider == null) {
                throw new Exception("Wrong configuration: otp check required but OTP auth provider is null");
            }
            String extOtpAuthProviderClass = "";
            if (this.extOtpAuthProvider != null) {
                extOtpAuthProviderClass = this.extOtpAuthProvider.getClass().getSimpleName();
            }
            if (this.extAuthProvider.isUserAllowedToLogin(login)) {
                logger.debug((Object)("authNonExisting " + login + " allowed via LDAP"));
                if (this.requirePasswordExt) {
                    logger.debug((Object)("authNonExisting " + login + " password check required"));
                    status = this.extAuthProvider.auth(login, password, null);
                    if (status.equals((Object)AUTHSTATUS.SUCCESS)) {
                        logger.debug((Object)("authNonExisting " + login + " password OK via " + this.extAuthProvider.getClass()));
                    } else {
                        if (securityLogger != null) {
                            securityLogger.register("LOGIN_FAIL", source_ip, login, "LDAP authentication fail");
                        }
                        logger.debug((Object)("authNonExisting " + login + " password fail via LDAP"));
                        return status;
                    }
                }
                if (this.requireOtpForExternal) {
                    logger.debug((Object)("authNonExisting " + login + " external otp required"));
                    status = this.extOtpAuthProvider.auth(login, password, totp);
                    logger.debug((Object)("authNonExisting " + login + " external otp check: " + status.toString()));
                    if (!status.equals((Object)AUTHSTATUS.SUCCESS)) {
                        if (securityLogger != null) {
                            securityLogger.register("LOGIN_FAIL", source_ip, login, "OTP " + extOtpAuthProviderClass + " authentication fail: " + status.toString());
                        }
                        return status;
                    }
                }
            } else {
                status = AUTHSTATUS.NOTALLOWED;
                if (securityLogger != null) {
                    securityLogger.register("LOGIN_FAIL", source_ip, login, "Not allowed to login");
                }
                logger.debug((Object)("authNonExisting " + login + " not allowed via LDAP"));
            }
        }
        catch (Exception e) {
            logger.error((Object)"firstTimeAuth error", (Throwable)e);
        }
        return status;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AUTHSTATUS authExisting(IAccountModel accountModel, String password, String totp, String source_ip) {
        logger.debug((Object)("authExisting " + accountModel.getLogin() + " started"));
        AUTHSTATUS status = AUTHSTATUS.FAIL;
        try {
            if (!this.requireOtpForExternal && !this.requirePasswordExt && accountModel.getExternal().booleanValue()) {
                throw new Exception("Wrong configuration: password check is false and otp check for external users is false");
            }
            if (!(this.requireOtpForInternal || this.requirePasswordInt || accountModel.getExternal().booleanValue())) {
                throw new Exception("Wrong configuration: password check is false and otp check for internal users is false");
            }
            String login = accountModel.getLogin();
            String extAuthProviderClass = "";
            if (this.extOtpAuthProvider != null) {
                extAuthProviderClass = this.extOtpAuthProvider.getClass().getSimpleName();
            }
            if (!accountModel.getExternal().booleanValue()) {
                if (accountModel.getEnabled().booleanValue()) {
                    if (this.requirePasswordInt) {
                        logger.debug((Object)("authExisting " + login + " [internal] password check is required"));
                        status = accountModel.checkPassword(password);
                        if (!status.equals((Object)AUTHSTATUS.SUCCESS)) {
                            if (securityLogger != null) {
                                securityLogger.register("LOGIN_FAIL", source_ip, login, "Internal authentication: " + status.toString());
                            }
                            logger.debug((Object)("authExisting " + login + " [internal] password: " + status.toString()));
                            return status;
                        }
                    }
                    if (!this.requireOtpForInternal) return status;
                    logger.debug((Object)("authExisting " + login + " [internal] otp check required"));
                    status = this.intOtpAuthProvider.auth(accountModel.getLogin(), password, totp);
                    logger.debug((Object)("authExisting " + login + " [internal] otp check:" + status.toString()));
                    if (status.equals((Object)AUTHSTATUS.SUCCESS)) return status;
                    if (securityLogger != null) {
                        securityLogger.register("LOGIN_FAIL", source_ip, login, "OTP " + extAuthProviderClass + " authentication fail: " + status.toString());
                    }
                    logger.debug((Object)("authExisting " + login + " [internal] otp check: " + status.toString()));
                    return status;
                }
                status = AUTHSTATUS.NOTALLOWED;
                if (securityLogger != null) {
                    securityLogger.register("LOGIN_FAIL", source_ip, login, "Not allowed to login");
                }
                logger.debug((Object)("authExisting " + login + " [internal] " + status.toString()));
                return status;
            }
            if (this.extAuthProvider.isUserAllowedToLogin(accountModel.getLogin()) && accountModel.getEnabled().booleanValue()) {
                logger.debug((Object)("authExisting " + login + " [external] LDAP login allowed"));
                if (this.requirePasswordExt) {
                    logger.debug((Object)("authExisting " + login + " [external] LDAP password check required"));
                    status = this.extAuthProvider.auth(accountModel.getLogin(), password, totp);
                    if (status.equals((Object)AUTHSTATUS.SUCCESS)) {
                        logger.debug((Object)("authExisting " + login + " [external] LDAP password OK"));
                    } else {
                        if (securityLogger != null) {
                            securityLogger.register("LOGIN_FAIL", source_ip, login, "External authentication fail");
                        }
                        logger.debug((Object)("authExisting " + login + " [external] LDAP password FAIL"));
                        return status;
                    }
                }
                if (!this.requireOtpForExternal) return status;
                logger.debug((Object)("authExisting " + login + " [external] OTP check required"));
                status = this.extOtpAuthProvider.auth(accountModel.getLogin(), password, totp);
                logger.debug((Object)("authExisting " + login + " [external] OTP check: " + status.toString()));
                if (status.equals((Object)AUTHSTATUS.SUCCESS)) return status;
                if (securityLogger == null) return status;
                securityLogger.register("LOGIN_FAIL", source_ip, login, "OTP " + extAuthProviderClass + " authentication fail: " + status.toString());
                return status;
            }
            status = AUTHSTATUS.NOTALLOWED;
            if (securityLogger != null) {
                securityLogger.register("LOGIN_FAIL", source_ip, login, "Not allowed to login");
            }
            logger.debug((Object)("authExisting " + login + " [external] LDAP not allowed to login"));
            return status;
        }
        catch (Exception e) {
            logger.error((Object)("Auth error for login " + accountModel.getLogin()), (Throwable)e);
        }
        return status;
    }

    public boolean isOTPrequredForInternal() {
        return this.requireOtpForInternal;
    }

    public boolean isOTPrequiredForExternal() {
        return this.requireOtpForExternal;
    }

    public IAuthProvider getExtAuthProvider() {
        return this.extOtpAuthProvider;
    }

    public void setSecurityLogger(ISecurityLogger logger) {
        securityLogger = logger;
    }

    public static JSONArray getSupportedExtAuthProviders() {
        JSONArray providers = new JSONArray();
        providers.put((Object)"linotp");
        providers.put((Object)"multifactor");
        providers.put((Object)"fortiauth");
        providers.put((Object)"radius");
        providers.put((Object)"duo");
        providers.put((Object)"totp");
        return providers;
    }

    public static enum AUTHSTATUS {
        SUCCESS,
        WRONG_PASSWORD,
        WRONG_OTP,
        GENERATE_OTP,
        INITIAL_OTP_NEEDED,
        PASSWORD_CHANGE,
        FAIL,
        NOTALLOWED,
        CAPCHA_REQUIRED,
        WRONG_CAPCHA;

    }
}

