/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.auth;

import com.ksoft.auth.AuthManager;
import com.ksoft.auth.IAuthProvider;
import com.ksoft.tls.TlsHelper;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class DuoAuthProvider
implements IAuthProvider {
    static Logger logger = Logger.getLogger((String)DuoAuthProvider.class.getName());
    String hostname;
    String integrationKey;
    String secretKey;
    String factor;
    String authorizationHeaderValue;
    int sig_version = 2;
    private boolean useProxy = false;
    private boolean doTlsCheck;
    public static SimpleDateFormat RFC_2822_DATE_FORMAT = new SimpleDateFormat("EEE', 'dd' 'MMM' 'yyyy' 'HH:mm:ss' 'Z", Locale.US);

    public DuoAuthProvider(String hostname, String integrationKey, String secretKey, boolean usePorxy, boolean doTlsChek) {
        this.hostname = hostname;
        this.integrationKey = integrationKey;
        this.secretKey = secretKey;
        this.useProxy = usePorxy;
        this.doTlsCheck = doTlsChek;
    }

    @Override
    public AuthManager.AUTHSTATUS auth(String login, String password, String otp) {
        AuthManager.AUTHSTATUS result = AuthManager.AUTHSTATUS.FAIL;
        JSONObject json = new JSONObject();
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("username", login);
            params.put("factor", "passcode");
            params.put("passcode", otp);
            String method = "POST";
            String uri = "/auth/v2/auth";
            String date = this.formatDate(new Date());
            String canon = this.canonRequest(date, method, this.hostname, uri, this.sig_version, params);
            String sig = this.signHMAC(this.secretKey, canon);
            String auth = String.valueOf(this.integrationKey) + ":" + sig;
            String authorizationHeaderValue = "Basic " + new String(Base64.encodeBase64((byte[])auth.getBytes()));
            String payload = this.createQueryString(params);
            Client client = TlsHelper.getTlsClient(this.doTlsCheck, this.useProxy);
            String apiURL = "https://" + this.hostname + uri;
            Response responseEntity = TlsHelper.getTrustAllTlsClient().target(apiURL).request().header("Authorization", (Object)authorizationHeaderValue).header("Date", (Object)date).post(Entity.entity((Object)payload, (String)"application/x-www-form-urlencoded"));
            String resp = (String)responseEntity.readEntity(String.class);
            if (responseEntity.getStatus() == 200) {
                json = new JSONObject(resp);
                String _result = json.getJSONObject("response").getString("result");
                if (_result.equals("allow")) {
                    logger.debug((Object)("DUO response " + _result + " for login " + login));
                    result = AuthManager.AUTHSTATUS.SUCCESS;
                } else {
                    result = AuthManager.AUTHSTATUS.WRONG_OTP;
                    logger.debug((Object)("DUO response " + _result + " for login " + login + ". " + resp));
                }
            } else {
                logger.error((Object)("DUO response with code " + responseEntity.getStatus() + ". Content: " + resp));
                result = AuthManager.AUTHSTATUS.FAIL;
            }
        }
        catch (Exception e) {
            logger.error((Object)("Forti auth error for " + login), (Throwable)e);
        }
        return result;
    }

    @Override
    public boolean isUserAllowedToLogin(String login) {
        return false;
    }

    public static byte[] hmacSha1(byte[] key_bytes, byte[] text_bytes) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac hmacSha1;
        try {
            hmacSha1 = Mac.getInstance("HmacSHA1");
        }
        catch (NoSuchAlgorithmException nsae) {
            hmacSha1 = Mac.getInstance("HMAC-SHA-1");
        }
        SecretKeySpec macKey = new SecretKeySpec(key_bytes, "RAW");
        hmacSha1.init(macKey);
        return hmacSha1.doFinal(text_bytes);
    }

    public static String bytes_to_hex(byte[] b) {
        String result = "";
        int i = 0;
        while (i < b.length) {
            result = String.valueOf(result) + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
            ++i;
        }
        return result;
    }

    public static String join(Object[] s, String joiner) {
        int itemCount = s.length;
        if (itemCount == 0) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        out.append(s[0]);
        int x = 1;
        while (x < itemCount) {
            String item = (String)s[x];
            if (!"".equals(item)) {
                out.append(joiner).append(item);
            }
            ++x;
        }
        return out.toString();
    }

    protected String signHMAC(String skey, String msg) {
        try {
            byte[] sig_bytes = DuoAuthProvider.hmacSha1(skey.getBytes(), msg.getBytes());
            String sig = DuoAuthProvider.bytes_to_hex(sig_bytes);
            return sig;
        }
        catch (Exception e) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String formatDate(Date date) {
        SimpleDateFormat simpleDateFormat = RFC_2822_DATE_FORMAT;
        synchronized (simpleDateFormat) {
            return RFC_2822_DATE_FORMAT.format(date);
        }
    }

    protected String canonRequest(String date, String method, String host, String uri, int sig_version, HashMap<String, String> params) throws UnsupportedEncodingException {
        String canon = "";
        if (sig_version == 2) {
            canon = String.valueOf(canon) + date + "\n";
        }
        canon = String.valueOf(canon) + method.toUpperCase() + "\n";
        canon = String.valueOf(canon) + host.toLowerCase() + "\n";
        canon = String.valueOf(canon) + uri + "\n";
        canon = String.valueOf(canon) + this.createQueryString(params);
        return canon;
    }

    private String createQueryString(HashMap<String, String> params) throws UnsupportedEncodingException {
        ArrayList<String> args = new ArrayList<String>();
        ArrayList<String> keys = new ArrayList<String>();
        for (String key : params.keySet()) {
            keys.add(key);
        }
        Collections.sort(keys);
        for (String key : keys) {
            String name = URLEncoder.encode(key, "UTF-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
            String value = URLEncoder.encode(params.get(key), "UTF-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
            args.add(String.valueOf(name) + "=" + value);
        }
        return DuoAuthProvider.join(args.toArray(), "&");
    }

    public static void main(String[] args) {
        BasicConfigurator.configure();
        DuoAuthProvider duo = new DuoAuthProvider("api-3057e699.duosecurity.com", "DI8K8NCGBX0EM92J0XTQ", "33vW3NPwJioeewqf7UgOUCxXG5nah8AF0wiR3dWd", false, true);
        System.out.print((Object)duo.auth("nklendar", "a", "738021"));
    }
}

