/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.auth;

import com.ksoft.auth.AuthManager;
import com.ksoft.auth.IAuthProvider;
import com.ksoft.tls.TlsHelper;
import java.util.Base64;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class FortiAuthProvider
implements IAuthProvider {
    static Logger logger = Logger.getLogger((String)FortiAuthProvider.class.getName());
    String apiURL;
    String authorizationHeaderValue;

    public FortiAuthProvider(String apiURL, String user, String apiKey) {
        this.apiURL = apiURL;
        String usernameAndPassword = String.valueOf(user) + ":" + apiKey;
        this.authorizationHeaderValue = "Basic " + Base64.getEncoder().encodeToString(usernameAndPassword.getBytes());
    }

    @Override
    public AuthManager.AUTHSTATUS auth(String login, String password, String otp) {
        AuthManager.AUTHSTATUS result = AuthManager.AUTHSTATUS.FAIL;
        JSONObject json = new JSONObject();
        try {
            json.put("username", (Object)login);
            json.put("token_code", (Object)otp);
            Response responseEntity = null;
            responseEntity = this.apiURL.toLowerCase().startsWith("https") ? TlsHelper.getTrustAllTlsClient().target(this.apiURL).request().header("Authorization", (Object)this.authorizationHeaderValue).post(Entity.entity((Object)json.toString(), (String)"application/json")) : ClientBuilder.newClient().target(this.apiURL).request().header("Authorization", (Object)this.authorizationHeaderValue).post(Entity.entity((Object)json.toString(), (String)"application/json"));
            String resp = (String)responseEntity.readEntity(String.class);
            if (responseEntity.getStatus() == 200) {
                result = AuthManager.AUTHSTATUS.SUCCESS;
                logger.debug((Object)("Forti response OK for login " + login));
            } else {
                logger.error((Object)("Forti response with code " + responseEntity.getStatus() + ". Content: " + resp));
                result = AuthManager.AUTHSTATUS.WRONG_OTP;
            }
        }
        catch (Exception e) {
            logger.error((Object)("Forti auth error for " + login), (Throwable)e);
        }
        return result;
    }

    public void init(String url) {
        this.apiURL = url;
    }

    @Override
    public boolean isUserAllowedToLogin(String login) {
        return false;
    }
}

