/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.auth;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.ksoft.auth.AuthManager;
import com.ksoft.auth.IAuthProvider;
import com.ksoft.tls.TlsHelper;
import java.util.Base64;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class MultifactorAuthProvider
implements IAuthProvider {
    static Logger logger = Logger.getLogger((String)MultifactorAuthProvider.class.getName());
    String apiURL;
    String nasIdentifier;
    String sharedSecret;
    String authorizationHeaderValue;
    private boolean useProxy = false;
    private boolean doTlsCheck = false;
    private boolean isPush = false;
    public static LoadingCache<String, String> otpExpireCache = CacheBuilder.newBuilder().concurrencyLevel(4).maximumSize(10000L).expireAfterWrite(30L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, String>(){

        public String load(String key) throws Exception {
            return null;
        }
    });

    public MultifactorAuthProvider(String apiURL, String nasIdentifier, String sharedSecret, boolean isPush, boolean usePorxy, boolean doTlsChek) {
        this.apiURL = apiURL;
        this.nasIdentifier = nasIdentifier;
        this.sharedSecret = sharedSecret;
        this.useProxy = usePorxy;
        this.doTlsCheck = doTlsChek;
        this.authorizationHeaderValue = "Basic " + Base64.getEncoder().encodeToString((String.valueOf(nasIdentifier) + ":" + sharedSecret).getBytes());
        this.isPush = isPush;
    }

    @Override
    public AuthManager.AUTHSTATUS auth(String login, String password, String otp) {
        AuthManager.AUTHSTATUS result = AuthManager.AUTHSTATUS.FAIL;
        boolean mfaResult = false;
        JSONObject json = new JSONObject();
        try {
            String otpCacheKey;
            block17: {
                String status;
                otpCacheKey = String.valueOf(login) + ":" + otp;
                String otpCached = (String)otpExpireCache.getIfPresent((Object)otpCacheKey);
                if (otpCached != null) {
                    logger.error((Object)("OTP reuse. otpExpireCache already has key " + otpCacheKey));
                    return AuthManager.AUTHSTATUS.WRONG_OTP;
                }
                Client client = TlsHelper.getTlsClient(this.doTlsCheck, this.useProxy);
                json.put("Identity", (Object)login);
                if (this.isPush) {
                    json.put("PassCode", (Object)"m");
                } else {
                    json.put("PassCode", (Object)otp);
                }
                Response responseEntity = null;
                responseEntity = client.target(this.apiURL).request().header("Authorization", (Object)this.authorizationHeaderValue).post(Entity.entity((Object)json.toString(), (String)"application/json"));
                String resp = (String)responseEntity.readEntity(String.class);
                JSONObject jResp = new JSONObject(resp);
                logger.debug((Object)("Multifactor /ra response for login " + login + " " + resp));
                if (!jResp.has("success")) break block17;
                switch (status = jResp.getJSONObject("model").getString("status").toLowerCase()) {
                    case "granted": {
                        mfaResult = true;
                        break;
                    }
                    case "awaitingauthentication": {
                        String requestId = jResp.getJSONObject("model").getString("id");
                        json = new JSONObject();
                        json.put("Identity", (Object)login);
                        json.put("Challenge", (Object)otp);
                        json.put("RequestId", (Object)requestId);
                        Response responseEntity2 = client.target(String.valueOf(this.apiURL) + "/challenge").request().header("Authorization", (Object)this.authorizationHeaderValue).post(Entity.entity((Object)json.toString(), (String)"application/json"));
                        logger.debug((Object)("Multifactor /challenge response for login " + login + " " + resp));
                        String resp2 = (String)responseEntity2.readEntity(String.class);
                        JSONObject jResp2 = new JSONObject(resp2);
                        status = jResp2.getJSONObject("model").getString("status").toLowerCase();
                        if (status.equals("granted")) {
                            mfaResult = true;
                            break;
                        }
                        logger.error((Object)("Multifactor returned unknown request for challenge request for " + login));
                        break;
                    }
                    default: {
                        logger.error((Object)("Multifactor returned unknown status for " + login + " " + status));
                    }
                }
            }
            AuthManager.AUTHSTATUS aUTHSTATUS = result = mfaResult ? AuthManager.AUTHSTATUS.SUCCESS : AuthManager.AUTHSTATUS.WRONG_OTP;
            if (mfaResult) {
                otpExpireCache.put((Object)otpCacheKey, (Object)otp);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Multifactor auth error for " + login), (Throwable)e);
        }
        return result;
    }

    @Override
    public boolean isUserAllowedToLogin(String login) {
        return false;
    }

    public static void main(String[] args) {
        BasicConfigurator.configure();
        MultifactorAuthProvider mfa = new MultifactorAuthProvider("https://api.multifactor.ru/access/requests/ra", "rs_23b4ce5bdd9ca8041c3305a145310", "27dd1ecfc3468446ef3f4fbdfd917f20", false, false, false);
        System.out.print((Object)mfa.auth("n.klendar", "a", "746618"));
    }
}

