/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.auth;

import com.ksoft.auth.AuthManager;
import com.ksoft.auth.IAuthProvider;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import net.jradius.client.RadiusClient;
import net.jradius.client.auth.CHAPAuthenticator;
import net.jradius.client.auth.EAPMD5Authenticator;
import net.jradius.client.auth.EAPMSCHAPv2Authenticator;
import net.jradius.client.auth.EAPTLSAuthenticator;
import net.jradius.client.auth.MSCHAPv2Authenticator;
import net.jradius.client.auth.PAPAuthenticator;
import net.jradius.client.auth.PEAPAuthenticator;
import net.jradius.client.auth.RadiusAuthenticator;
import net.jradius.dictionary.Attr_NASIdentifier;
import net.jradius.dictionary.Attr_UserName;
import net.jradius.dictionary.Attr_UserPassword;
import net.jradius.exception.RadiusException;
import net.jradius.exception.UnknownAttributeException;
import net.jradius.packet.AccessAccept;
import net.jradius.packet.AccessChallenge;
import net.jradius.packet.AccessRequest;
import net.jradius.packet.RadiusResponse;
import net.jradius.packet.attribute.AttributeFactory;
import net.jradius.packet.attribute.AttributeList;
import net.jradius.packet.attribute.RadiusAttribute;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;

public class RadiusProvider
implements IAuthProvider {
    static Logger logger = Logger.getLogger((String)RadiusProvider.class.getName());
    InetAddress host;
    String sharedSecret;
    String identifier;
    RadiusAuthenticator authenticator = null;
    boolean isChallangeResponseMode = false;

    public void init(String sharedSecret, String indetifier, boolean isChallangeResponseMode) {
        this.sharedSecret = sharedSecret;
        this.identifier = indetifier;
        this.isChallangeResponseMode = isChallangeResponseMode;
    }

    public RadiusProvider(String host, String sharedSecret, String identifier, String authType, boolean isChallangeResponseMode) {
        try {
            this.host = InetAddress.getByName(host);
            switch (authType) {
                case "mschap": {
                    this.authenticator = new MSCHAPv2Authenticator();
                    break;
                }
                case "chap": {
                    this.authenticator = new CHAPAuthenticator();
                    break;
                }
                case "pap": {
                    this.authenticator = new PAPAuthenticator();
                    break;
                }
                case "eap-md5": {
                    this.authenticator = new EAPMD5Authenticator();
                    break;
                }
                case "eap-tls": {
                    this.authenticator = new EAPTLSAuthenticator();
                    break;
                }
                case "eap-mschap": {
                    this.authenticator = new EAPMSCHAPv2Authenticator();
                    break;
                }
                case "peap": {
                    this.authenticator = new PEAPAuthenticator();
                }
            }
        }
        catch (UnknownHostException e) {
            logger.error((Object)("Radius host " + host + " not found"), (Throwable)e);
        }
        this.sharedSecret = sharedSecret;
        this.identifier = identifier;
        this.isChallangeResponseMode = isChallangeResponseMode;
        AttributeFactory.loadAttributeDictionary((String)"net.jradius.dictionary.AttributeDictionaryImpl");
    }

    @Override
    public AuthManager.AUTHSTATUS auth(String login, String password, String otp) {
        AuthManager.AUTHSTATUS result = AuthManager.AUTHSTATUS.FAIL;
        try {
            String replyMessage = "";
            RadiusClient rc = new RadiusClient(this.host, this.sharedSecret, 1812, 1813, 20);
            AttributeList attrs = new AttributeList();
            attrs.add((RadiusAttribute)new Attr_UserName((Serializable)((Object)login)));
            attrs.add((RadiusAttribute)new Attr_NASIdentifier((Serializable)((Object)this.identifier)));
            AccessRequest request = new AccessRequest(rc, attrs);
            if (this.isChallangeResponseMode) {
                request.addAttribute((RadiusAttribute)new Attr_UserPassword((Serializable)((Object)password)));
            } else {
                request.addAttribute((RadiusAttribute)new Attr_UserPassword((Serializable)((Object)otp)));
            }
            logger.debug((Object)("Sending radius " + this.authenticator.getAuthName() + " request for " + login + " challangeResponseMode: " + String.valueOf(this.isChallangeResponseMode)));
            RadiusResponse reply = rc.authenticate(request, this.authenticator, 1);
            if (reply.getAttributeValue("Reply-Message") != null) {
                replyMessage = (String)reply.getAttributeValue("Reply-Message");
            }
            logger.debug((Object)("Received radius reply: " + reply.toString() + " for " + login + ". reply-message: " + replyMessage));
            boolean isAuthenticated = reply instanceof AccessAccept;
            if (isAuthenticated) {
                result = AuthManager.AUTHSTATUS.SUCCESS;
                this.closeSession(login);
            } else {
                if (reply instanceof AccessChallenge) {
                    String state = (String)reply.getAttributeValue("State");
                    logger.debug((Object)("Got state " + state + " for challange " + login));
                    AttributeList attrs1 = new AttributeList();
                    attrs1.add((RadiusAttribute)new Attr_UserName((Serializable)((Object)login)));
                    AccessRequest otpRequest = new AccessRequest(rc);
                    otpRequest.addAttribute((RadiusAttribute)new Attr_UserName((Serializable)((Object)login)));
                    otpRequest.addAttribute((RadiusAttribute)new Attr_UserPassword((Serializable)((Object)otp)));
                    logger.debug((Object)("Sending radius " + this.authenticator.getAuthName() + " OTP request for " + login + " challangeResponseMode: " + String.valueOf(this.isChallangeResponseMode)));
                    RadiusResponse otpReply = rc.authenticate(otpRequest, this.authenticator, 3);
                    boolean isOTPAuthenticated = reply instanceof AccessAccept;
                    if (isOTPAuthenticated) {
                        result = AuthManager.AUTHSTATUS.SUCCESS;
                        this.closeSession(login);
                    } else {
                        result = AuthManager.AUTHSTATUS.WRONG_OTP;
                    }
                }
                result = AuthManager.AUTHSTATUS.WRONG_OTP;
            }
        }
        catch (Exception e) {
            logger.error((Object)("Raduis auth error for login " + login), (Throwable)e);
        }
        return result;
    }

    @Override
    public boolean isUserAllowedToLogin(String login) {
        return false;
    }

    private void closeSession(String login) throws IOException, RadiusException {
    }

    public static void main(String[] args) throws UnknownAttributeException, NoSuchAlgorithmException, RadiusException, IOException {
        BasicConfigurator.configure();
        RadiusProvider rp = new RadiusProvider("radius.multifactor.ru", "27dd1ecfc3468446ef3f4fbdfd917f20", "rs_23b4ce5bdd9ca8041c3305a145310", "pap", false);
        rp.auth("n.klendar", " ", "223440");
        RadiusClient rc = new RadiusClient(rp.host, rp.sharedSecret, 1812, 1813, 20);
        AttributeList attrs = new AttributeList();
        attrs.add((RadiusAttribute)new Attr_UserName((Serializable)((Object)"n.klendar")));
        attrs.add((RadiusAttribute)new Attr_NASIdentifier((Serializable)((Object)rp.identifier)));
        AccessRequest request = new AccessRequest(rc, attrs);
        request.addAttribute((RadiusAttribute)new Attr_UserPassword((Serializable)((Object)"challange")));
        RadiusResponse reply = rc.authenticate(request, (RadiusAuthenticator)new PAPAuthenticator(), 1);
        System.out.println(reply.toString());
    }
}

