/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.auth;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.ksoft.auth.AuthManager;
import com.ksoft.auth.IAuthProvider;
import com.warrenstrange.googleauth.GoogleAuthenticator;
import com.warrenstrange.googleauth.GoogleAuthenticatorKey;
import com.warrenstrange.googleauth.GoogleAuthenticatorQRGenerator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.glxn.qrgen.core.image.ImageType;
import net.glxn.qrgen.javase.QRCode;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;

public class TOTPProvider
implements IAuthProvider {
    static Logger logger = Logger.getLogger((String)TOTPProvider.class.getName());
    static GoogleAuthenticator gAuth = new GoogleAuthenticator();
    private Function<String, String> getTOTPSecretForLogin;
    private Function<String, String> getInitialTOTPForLogin;
    public static LoadingCache<String, String> usedTOTPCache = CacheBuilder.newBuilder().concurrencyLevel(4).maximumSize(10000L).expireAfterWrite(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, String>(){

        public String load(String key) throws Exception {
            return null;
        }
    });

    private void setSecretKeyFunction(Function<String, String> function) {
        this.getTOTPSecretForLogin = function;
    }

    public TOTPProvider(Function<String, String> getTOTPSecretForLogin, Function<String, String> getInitialTOTPForLogin) {
        this.getTOTPSecretForLogin = getTOTPSecretForLogin;
        this.getInitialTOTPForLogin = getInitialTOTPForLogin;
    }

    @Override
    public AuthManager.AUTHSTATUS auth(String login, String password, String otp) {
        AuthManager.AUTHSTATUS status = AuthManager.AUTHSTATUS.WRONG_OTP;
        String secretKey = this.getTOTPSecretForLogin.apply(login);
        String initialTOTP = this.getInitialTOTPForLogin.apply(login);
        try {
            if (secretKey != null && !secretKey.equals(AuthManager.AUTHSTATUS.INITIAL_OTP_NEEDED.toString())) {
                boolean autResult = gAuth.authorize(secretKey, Integer.parseInt(otp.trim()));
                if (autResult && usedTOTPCache.getIfPresent((Object)(String.valueOf(login.toLowerCase()) + ":" + otp.trim())) == null) {
                    status = AuthManager.AUTHSTATUS.SUCCESS;
                    usedTOTPCache.put((Object)(String.valueOf(login.toLowerCase()) + ":" + otp.trim()), (Object)otp);
                } else {
                    status = AuthManager.AUTHSTATUS.WRONG_OTP;
                }
            } else if (initialTOTP == null) {
                status = AuthManager.AUTHSTATUS.INITIAL_OTP_NEEDED;
            } else if (initialTOTP.trim().equals(otp.trim())) {
                status = AuthManager.AUTHSTATUS.GENERATE_OTP;
                logger.debug((Object)("initialTOTP check passed for login " + login));
            }
        }
        catch (Exception e) {
            logger.error((Object)("TOTP verificatione error for login " + login), (Throwable)e);
        }
        return status;
    }

    public static GoogleAuthenticatorKey generateSecret(String login) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException, SQLException, IOException {
        GoogleAuthenticatorKey key = null;
        key = gAuth.createCredentials();
        return key;
    }

    public static String generateQRcode(String system, String login, GoogleAuthenticatorKey key) {
        String result = "";
        try {
            if (key != null) {
                String totpURL = GoogleAuthenticatorQRGenerator.getOtpAuthTotpURL((String)system, (String)login, (GoogleAuthenticatorKey)key);
                ByteArrayOutputStream bytes = QRCode.from((String)totpURL).withSize(250, 250).to(ImageType.JPG).stream();
                byte[] encodedBytes = Base64.encodeBase64((byte[])bytes.toByteArray());
                result = new String(encodedBytes);
                logger.debug((Object)("TOTP QRCode created for " + login));
            }
        }
        catch (Exception e) {
            logger.error((Object)"generateQRcode error", (Throwable)e);
        }
        return result;
    }

    public static boolean checkTOTPbyKey(String key, String totp) {
        boolean result = false;
        try {
            result = gAuth.authorize(key, Integer.parseInt(totp));
        }
        catch (Exception e) {
            logger.error((Object)"TOTP check error", (Throwable)e);
        }
        return result;
    }

    @Override
    public boolean isUserAllowedToLogin(String login) {
        return false;
    }
}

