/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.core;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.dao.GenericRawResults;
import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.db.MariaDbDatabaseType;
import com.j256.ormlite.db.MysqlDatabaseType;
import com.j256.ormlite.db.OracleDatabaseType;
import com.j256.ormlite.db.PostgresDatabaseType;
import com.j256.ormlite.db.SqlServerDatabaseType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.jdbc.JdbcConnectionSource;
import com.j256.ormlite.jdbc.JdbcPooledConnectionSource;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.SelectArg;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.DatabaseTable;
import com.j256.ormlite.table.TableUtils;
import com.ksoft.db.DummyModel;
import com.ksoft.db.MySQLiteDatabase;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MariaDBDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.resource.FileSystemResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class DBManagerLocal {
    static Logger logger = Logger.getLogger((String)DBManagerLocal.class.getName());
    private ConnectionSource connectionSource;
    private ConcurrentHashMap<Class, Dao> daos = new ConcurrentHashMap();
    private ArrayList<Class> classes = new ArrayList();

    public void init(String className, String hostOrFile, int port, String db, String username, String password, ArrayList<String> classesToInit) throws ClassNotFoundException, SQLException, IOException {
        Class.forName(className);
        this.initClasses(classesToInit);
        String jdbcString = "";
        DBManagerLocal.initDataBase(className, hostOrFile, port, db, username, password);
        if (className.contains("mysql")) {
            jdbcString = "jdbc:mysql://" + hostOrFile + ":" + port + "/" + db + "?serverTimezone=UTC&useUnicode=true&characterEncoding=utf-8";
            this.connectionSource = new JdbcPooledConnectionSource(jdbcString, username, password, (DatabaseType)new MysqlDatabaseType());
            ((JdbcPooledConnectionSource)this.connectionSource).setCheckConnectionsEveryMillis(60000L);
        }
        if (className.contains("mariadb")) {
            jdbcString = "jdbc:mariadb://" + hostOrFile + ":" + port + "/" + db + "?serverTimezone=UTC&useUnicode=true&characterEncoding=utf-8";
            this.connectionSource = new JdbcPooledConnectionSource(jdbcString, username, password, (DatabaseType)new MysqlDatabaseType());
        } else if (className.contains("postgre")) {
            this.connectionSource = new JdbcPooledConnectionSource(jdbcString, username, password, (DatabaseType)new PostgresDatabaseType());
        } else if (className.contains("microsoft.sqlserver")) {
            this.connectionSource = new JdbcPooledConnectionSource(jdbcString, username, password, (DatabaseType)new SqlServerDatabaseType());
        } else if (className.contains("oracle")) {
            this.connectionSource = new JdbcConnectionSource(jdbcString, username, password, (DatabaseType)new OracleDatabaseType());
        } else if (className.contains("sqlite")) {
            jdbcString = "jdbc:sqlite:" + hostOrFile;
            this.connectionSource = new JdbcConnectionSource(jdbcString);
        }
        this.initDAOs();
        this.createTables();
    }

    public static String getConnectionString(String className, String hostOrFile, int port, String db, String username, String password) {
        String jdbcString = "";
        if (className.contains("mysql")) {
            jdbcString = "jdbc:mysql://" + hostOrFile + ":" + port + "/" + db + "?serverTimezone=UTC&useUnicode=true&characterEncoding=utf-8";
        }
        if (className.contains("mariadb")) {
            jdbcString = "jdbc:mariadb://" + hostOrFile + ":" + port + "/" + db + "?serverTimezone=UTC&useUnicode=true&characterEncoding=utf-8";
        } else if (!className.contains("postgre") && !className.contains("microsoft.sqlserver") && !className.contains("oracle") && className.contains("sqlite")) {
            jdbcString = "jdbc:sqlite:" + hostOrFile;
        }
        return jdbcString;
    }

    private static void initDataBase(String className, String host, int port, String db, String username, String password) throws SQLException {
        String dbSQL = "";
        String jdbcString = "";
        JdbcConnectionSource connSource = null;
        if (className.contains("mysql")) {
            jdbcString = "jdbc:mysql://" + host + ":" + port + "/?serverTimezone=UTC&useUnicode=true&characterEncoding=utf-8";
            connSource = new JdbcConnectionSource(jdbcString, username, password, (DatabaseType)new MysqlDatabaseType());
            dbSQL = "create database if not exists " + db + " character set UTF8 collate utf8_general_ci";
        } else if (className.contains("mariadb")) {
            jdbcString = "jdbc:mariadb://" + host + ":" + port + "/?serverTimezone=UTC&useUnicode=true&characterEncoding=utf-8";
            connSource = new JdbcConnectionSource(jdbcString, username, password, (DatabaseType)new MariaDbDatabaseType());
            dbSQL = "create database if not exists " + db + " character set UTF8 collate utf8_general_ci";
        } else if (className.contains("postgre")) {
            dbSQL = "";
        } else if (className.contains("microsoft.sqlserver")) {
            dbSQL = "";
        } else if (className.contains("oracle")) {
            dbSQL = "";
        }
        if (!dbSQL.isEmpty()) {
            try {
                Dao dao = DaoManager.createDao(connSource, DummyModel.class);
                dao.executeRawNoArgs(dbSQL);
            }
            catch (Exception e) {
                logger.error((Object)"Unable to create database ", (Throwable)e);
            }
        }
    }

    private void initClasses(ArrayList<String> classesToInit) throws SQLException, IOException, ClassNotFoundException {
        this.classes.clear();
        for (String className : classesToInit) {
            try {
                Class<?> claz = Class.forName(className);
                this.classes.add(claz);
            }
            catch (Exception e) {
                logger.error((Object)("Init class " + className + " error"), (Throwable)e);
            }
        }
    }

    public static void migrate(String className, String host, int port, String db, String username, String password, String changelogFile) {
        try {
            Class.forName(className);
            String databaseUrl = DBManagerLocal.getConnectionString(className, host, port, db, username, password);
            Connection conn = DriverManager.getConnection(databaseUrl);
            JdbcConnection liquibaseConnection = new JdbcConnection(conn);
            Database database = DBManagerLocal.getDatabaseForMigration(className);
            database.setConnection((DatabaseConnection)liquibaseConnection);
            Liquibase liquibase = new Liquibase(changelogFile, (ResourceAccessor)new FileSystemResourceAccessor(), database);
            liquibase.update("prod");
            conn.close();
        }
        catch (Exception e) {
            logger.error((Object)"DB migration error", (Throwable)e);
        }
    }

    private static Database getDatabaseForMigration(String className) {
        Object database = null;
        if (className.contains("mysql")) {
            database = new MySQLDatabase();
        }
        if (className.contains("mariadb")) {
            database = new MariaDBDatabase();
        } else if (className.contains("postgre")) {
            database = new PostgresDatabase();
        } else if (className.contains("microsoft.sqlserver")) {
            database = new MSSQLDatabase();
        } else if (className.contains("oracle")) {
            database = new OracleDatabase();
        } else if (className.contains("sqlite")) {
            database = new MySQLiteDatabase();
        }
        return database;
    }

    private void createTables() {
        for (Class claz : this.classes) {
            try {
                Dao dao = this.getDao(claz);
                if (dao.isTableExists()) continue;
                TableUtils.createTableIfNotExists((ConnectionSource)this.connectionSource, (Class)claz);
            }
            catch (SQLException e) {
                logger.error((Object)("Error while creating table for class:" + claz), (Throwable)e);
            }
        }
    }

    public Dao createDao(Class claz) {
        Dao result = null;
        try {
            result = DaoManager.createDao((ConnectionSource)this.connectionSource, (Class)claz);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public Dao getDao(Object entity) {
        Class<?> claz = entity.getClass();
        if (!this.daos.containsKey(claz)) {
            try {
                Dao dao = DaoManager.createDao((ConnectionSource)this.connectionSource, claz);
                this.daos.put(claz, dao);
                this.classes.add(claz);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        Dao result = this.daos.get(entity.getClass());
        return result;
    }

    public Dao getDao(String className) throws ClassNotFoundException {
        Class<?> claz = Class.forName(className);
        return this.getDao(claz);
    }

    public Dao getDao(Class claz) {
        if (!this.daos.containsKey(claz)) {
            try {
                Dao dao = DaoManager.createDao((ConnectionSource)this.connectionSource, (Class)claz);
                this.daos.put(claz, dao);
                this.classes.add(claz);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        Dao result = this.daos.get(claz);
        return result;
    }

    private void initDAOs() {
        for (Class claz : this.classes) {
            try {
                Dao dao = DaoManager.createDao((ConnectionSource)this.connectionSource, (Class)claz);
                this.daos.put(claz, dao);
            }
            catch (Exception e) {
                logger.error((Object)("Init DAO error for class:" + claz), (Throwable)e);
            }
        }
    }

    public void close() {
        if (this.connectionSource != null) {
            this.connectionSource.closeQuietly();
        }
    }

    public static void main(String[] args) {
        BasicConfigurator.configure();
        DBManagerLocal manager = new DBManagerLocal();
        try {
            String jdbcClaz = "com.mysql.cj.jdbc.Driver";
            String connString = "jdbc:mysql://localhost:3306/?serverTimezone=UTC&useUnicode=true&characterEncoding=utf-8";
            String dbLogin = "laps";
            String dbPass = "laps123";
            String string = "C:/CloudM/Projects/LAPS/conf/db_export.txt";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object findOne(Class claz, String column, Object value) throws SQLException, IOException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException {
        Dao dao = this.getDao(claz);
        QueryBuilder qb = dao.queryBuilder();
        SelectArg selectArg = new SelectArg(value);
        qb.where().eq(column, (Object)selectArg);
        Object result = dao.queryForFirst(qb.prepare());
        return result;
    }

    public void findOne(Object model, String column, Object value) throws SQLException, IOException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException {
        Dao dao = this.getDao(model);
        QueryBuilder qb = dao.queryBuilder();
        SelectArg selectArg = new SelectArg();
        selectArg.setValue(value);
        qb.where().eq(column, (Object)selectArg);
        Object result = dao.queryForFirst(qb.prepare());
        if (result != null) {
            BeanUtils.copyProperties((Object)model, (Object)result);
        }
    }

    public List findAll(Class claz) throws SQLException, IOException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException {
        Dao dao = this.daos.get(claz);
        List results = dao.queryForAll();
        return results;
    }

    public List findAll(Class claz, String column, Object value) throws SQLException, IOException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException {
        Dao dao = this.daos.get(claz);
        QueryBuilder qb = dao.queryBuilder();
        SelectArg selectArg = new SelectArg();
        selectArg.setValue(value);
        qb.where().eq(column, (Object)selectArg);
        List results = dao.query(qb.prepare());
        return results;
    }

    public List findAllIn(Class claz, String column, ArrayList<Object> values) throws SQLException, IOException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException {
        Dao dao = this.daos.get(claz);
        QueryBuilder qb = dao.queryBuilder();
        ArrayList<SelectArg> selectArgs = new ArrayList<SelectArg>();
        for (Object o : values) {
            selectArgs.add(new SelectArg(o));
        }
        qb.where().in(column, selectArgs);
        List results = dao.query(qb.prepare());
        return results;
    }

    public ArrayList<String> getColumnsForClass(Class claz) {
        Field[] fields;
        ArrayList<String> result = new ArrayList<String>();
        Field[] fieldArray = fields = claz.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            DatabaseField dataField = field.getAnnotation(DatabaseField.class);
            if (field != null) {
                String columnName = dataField.columnName();
                result.add(columnName);
            }
            ++n2;
        }
        return result;
    }

    public void restoreFromFile(String fileName, boolean deleteOld) {
        File file = new File(fileName);
        if (file.exists()) {
            this.restoreFromFile(file, deleteOld);
        }
    }

    public void restoreFromFile(File file, boolean deleteOld) {
        String line = "";
        int linesCount = 0;
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
                String tableName = "";
                String claz = "";
                JSONArray jColumns = new JSONArray();
                Dao dao = DaoManager.createDao((ConnectionSource)this.connectionSource, DummyModel.class);
                while ((line = br.readLine()) != null) {
                    if (line.isEmpty()) continue;
                    JSONObject json = new JSONObject(line);
                    if (json.has("table")) {
                        if (!tableName.isEmpty() && linesCount > 0) {
                            logger.debug((Object)("Inserted " + linesCount + " lines to" + tableName));
                        }
                        linesCount = 0;
                        tableName = json.getString("table");
                        if (!tableName.matches("[a-zA-Z0-9]+")) {
                            logger.error((Object)(String.valueOf(tableName) + " not matched regexp [a-zA-Z0-9]+"));
                        }
                    }
                    if (json.has("class")) {
                        claz = json.getString("class");
                        if (deleteOld) {
                            int a = dao.executeRawNoArgs("delete from " + tableName);
                            logger.info((Object)("Records deleted from " + tableName + " " + a));
                        }
                    }
                    if (json.has("columns")) {
                        jColumns = json.getJSONArray("columns");
                    }
                    if (!json.has("values")) continue;
                    ++linesCount;
                    JSONArray jValues = json.getJSONArray("values");
                    String[] vals = new String[jValues.length()];
                    String SQL = "INSERT INTO " + tableName + " (";
                    int i = 0;
                    while (i < jColumns.length()) {
                        if (!jValues.get(i).equals(null) && !jValues.getString(i).equals("null")) {
                            SQL = String.valueOf(SQL) + "`" + jColumns.getString(i) + "`";
                            SQL = String.valueOf(SQL) + ",";
                        }
                        ++i;
                    }
                    if (SQL.endsWith(",")) {
                        SQL = SQL.substring(0, SQL.length() - 1);
                    }
                    SQL = String.valueOf(SQL) + ")";
                    SQL = String.valueOf(SQL) + " values (";
                    int c = 0;
                    int i2 = 0;
                    while (i2 < jValues.length()) {
                        if (!jValues.get(i2).equals(null) && !jValues.getString(i2).equals("null")) {
                            SQL = String.valueOf(SQL) + "?";
                            SQL = String.valueOf(SQL) + ",";
                            vals[c] = jValues.get(i2).toString();
                            ++c;
                        }
                        ++i2;
                    }
                    if (SQL.endsWith(",")) {
                        SQL = SQL.substring(0, SQL.length() - 1);
                    }
                    SQL = String.valueOf(SQL) + ")";
                    String[] nonNullVals = new String[c];
                    int i3 = 0;
                    while (i3 < c) {
                        nonNullVals[i3] = vals[i3];
                        ++i3;
                    }
                    try {
                        dao.executeRaw(SQL, nonNullVals);
                    }
                    catch (SQLException e) {
                        logger.error((Object)("Unable to insert values " + SQL + " " + jValues.toString()), (Throwable)e);
                    }
                }
                br.close();
                if (!tableName.isEmpty() && linesCount > 0) {
                    logger.debug((Object)("Inserted " + linesCount + " lines to " + tableName));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            logger.error((Object)("restoreFromFile error " + file + ". Last line: " + line), (Throwable)e);
        }
    }

    public void exportTable(Class claz, String fileName, boolean append) {
        String tableName = "";
        try {
            Dao dao = this.getDao(claz);
            DatabaseTable an = claz.getAnnotation(DatabaseTable.class);
            Class<? extends Annotation> type = an.annotationType();
            Method[] methodArray = type.getDeclaredMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.getName().equals("tableName")) {
                    tableName = method.invoke((Object)an, null).toString();
                    break;
                }
                ++n2;
            }
            File fout = new File(fileName);
            FileOutputStream fos = new FileOutputStream(fout, append);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8));
            JSONObject header = new JSONObject();
            header.put("table", (Object)tableName);
            header.put("class", (Object)claz.getName().toString());
            GenericRawResults rawResults = dao.queryRaw("select * from " + tableName, new String[0]);
            String[] columns = rawResults.getColumnNames();
            header.put("columns", (Object)new JSONArray((Object)columns));
            bw.write(header.toString());
            bw.newLine();
            JSONObject json = new JSONObject();
            for (Object[] resultArray : rawResults) {
                json.put("values", (Object)new JSONArray((Object)resultArray));
                bw.write(json.toString());
                bw.newLine();
            }
            bw.close();
            rawResults.close();
        }
        catch (Exception e) {
            logger.error((Object)("exportTale error " + tableName + " " + claz), (Throwable)e);
        }
    }

    public void exportDB(String fileName) {
        for (Class claz : this.classes) {
            this.exportTable(claz, fileName, true);
        }
    }

    public static boolean isDBExists(String fileName) {
        File f = new File(fileName);
        return f.exists();
    }
}

