/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.db;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import liquibase.database.core.SQLiteDatabase;
import liquibase.structure.DatabaseObject;

public class MySQLiteDatabase
extends SQLiteDatabase {
    private static final Set<String> RESERVED_WORDS = MySQLiteDatabase.createReservedWords();

    public boolean isReservedWord(String string) {
        if (RESERVED_WORDS.contains(string.toUpperCase())) {
            return true;
        }
        return super.isReservedWord(string);
    }

    public String quoteObject(String objectName, Class<? extends DatabaseObject> objectType) {
        if (objectName == null) {
            return null;
        }
        return String.valueOf(this.getQuotingStartCharacter()) + objectName + this.getQuotingEndCharacter();
    }

    protected String getQuotingStartCharacter() {
        return "`";
    }

    protected String getQuotingEndCharacter() {
        return "`";
    }

    private static Set<String> createReservedWords() {
        return new HashSet<String>(Arrays.asList("ACCESSIBLE", "GROUO", "ORDER", "GROUP"));
    }
}

