/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.ldap;

import com.ksoft.ldap.MySSLSocketFactory;
import com.ksoft.tls.TlsHelper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.json.JSONArray;

public class LDAPHelper {
    static Logger logger = Logger.getLogger((String)LDAPHelper.class.getName());
    private String[] hosts;
    private String master_user;
    private String MASTER_USER_DN;
    private String MASTER_PASSWORD;
    boolean useSSL;
    boolean verifySSL;
    private int ldapPoolInitSize = 10;
    private static Integer connectTimeout = 1000;
    private static Integer readTimeout = 10000;

    public LDAPHelper(String hosts, boolean useSSL) {
        this.hosts = hosts.split(";");
        this.useSSL = useSSL;
    }

    public LDAPHelper(String master_user_dn, String master_password, String hosts, boolean useSSL, boolean verifySSL) {
        this.MASTER_USER_DN = master_user_dn;
        this.MASTER_PASSWORD = master_password;
        this.hosts = hosts.split(";");
        this.useSSL = useSSL;
        this.verifySSL = verifySSL;
    }

    private String getLdapUrl(String host) {
        if (this.useSSL) {
            if (host.contains(":")) {
                return "ldaps://" + host.trim();
            }
            return "ldaps://" + host.trim() + ":636";
        }
        return "ldap://" + host.trim();
    }

    public InitialLdapContext getContext() {
        InitialLdapContext ctx = null;
        String[] stringArray = this.hosts;
        int n = this.hosts.length;
        int n2 = 0;
        while (n2 < n) {
            String host = stringArray[n2];
            ctx = this.getContext(host.trim(), this.MASTER_USER_DN, this.MASTER_PASSWORD);
            if (ctx != null) break;
            ++n2;
        }
        return ctx;
    }

    public void close(InitialLdapContext ctx) {
        try {
            if (ctx != null) {
                ctx.close();
            }
            ctx = null;
        }
        catch (NamingException e) {
            logger.error((Object)"Ldap closing error", (Throwable)e);
        }
    }

    private InitialLdapContext getContext(String host, String userName, String password) {
        return this.getContext(host, userName, password, this.ldapPoolInitSize);
    }

    private InitialLdapContext getContext(String host, String userName, String password, int initPoolSize) {
        logger.debug((Object)("Logging to " + host + " with " + userName));
        if (userName.isEmpty() || password.isEmpty()) {
            logger.error((Object)"Blank username or password");
            return null;
        }
        try {
            Hashtable<String, Object> env = new Hashtable<String, Object>();
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("com.sun.jndi.ldap.read.timeout", readTimeout.toString());
            env.put("com.sun.jndi.ldap.connect.timeout", connectTimeout.toString());
            if (initPoolSize > 1) {
                env.put("com.sun.jndi.ldap.connect.pool", "true");
                env.put("com.sun.jndi.ldap.connect.pool.initsize", initPoolSize);
            }
            if (this.useSSL) {
                env.put("java.naming.provider.url", this.getLdapUrl(host));
                logger.debug((Object)("Connecting to ldaps host: " + this.getLdapUrl(host)));
                env.put("java.naming.security.protocol", "ssl");
                System.setProperty("com.sun.jndi.ldap.connect.pool.protocol", "plain ssl");
                System.setProperty("com.sun.jndi.ldap.connect.pool.initsize", "5");
                if (this.verifySSL) {
                    env.put("java.naming.ldap.factory.socket", "com.ksoft.ldap.MySSLSocketFactory");
                } else {
                    env.put("java.naming.ldap.factory.socket", "com.ksoft.ldap.TrustToAllSSLSocketFactory");
                }
            } else {
                logger.debug((Object)("Connecting to ldap " + this.getLdapUrl(host)));
                env.put("java.naming.provider.url", this.getLdapUrl(host));
                env.put("com.sun.jndi.ldap.connect.pool.protocol", "plain");
            }
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.security.principal", userName);
            env.put("java.naming.security.credentials", password);
            env.put("java.naming.authoritative", "true");
            env.put("java.naming.batchsize", "100");
            InitialLdapContext ctx = new InitialLdapContext(env, null);
            return ctx;
        }
        catch (CommunicationException e) {
            Throwable root = e.getRootCause();
            logger.error((Object)"Error connectiong to LDAP", (Throwable)e);
        }
        catch (NamingException e) {
            logger.error((Object)"Error logging into LDAP", (Throwable)e);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void exportAllPaged(String filePath, String searchBase, String searchString, String[] returningAttributes) {
        InitialLdapContext ctx = this.getContext();
        if (ctx == null) {
            logger.error((Object)"Unable to get context");
            return;
        }
        File fout = new File(filePath);
        FileOutputStream fos = null;
        BufferedWriter bw = null;
        try {
            try {
                fos = new FileOutputStream(fout, false);
                bw = new BufferedWriter(new OutputStreamWriter(fos));
                PagedResultsControl prc = new PagedResultsControl(128, false);
                ctx.setRequestControls(new Control[]{prc});
                SearchControls ctls = new SearchControls();
                ctls.setReturningObjFlag(true);
                ctls.setSearchScope(2);
                ctls.setReturningAttributes(returningAttributes);
                byte[] b = null;
                do {
                    ArrayList<HashMap<String, String>> pagedResult = this.get_All(ctx, ctls, searchBase, searchString, returningAttributes);
                    int i = 0;
                    while (i < pagedResult.size()) {
                        HashMap<String, String> r = pagedResult.get(i);
                        String line = "";
                        for (Map.Entry<String, String> entry : r.entrySet()) {
                            String key = entry.getKey();
                            String value = entry.getValue();
                            line = String.valueOf(line) + key + "=" + value + ";";
                        }
                        bw.write(line);
                        bw.newLine();
                        ++i;
                    }
                    Control[] prrcs = ctx.getResponseControls();
                    PagedResultsResponseControl prrc = null;
                    int prrcNum = 0;
                    while (prrcNum < prrcs.length) {
                        if (prrcs[prrcNum] instanceof PagedResultsResponseControl) {
                            prrc = (PagedResultsResponseControl)prrcs[prrcNum];
                        }
                        ++prrcNum;
                    }
                    if (prrc == null || (b = prrc.getCookie()) == null) continue;
                    ctx.setRequestControls(new Control[]{new PagedResultsControl(128, b, true)});
                } while (b != null);
                bw.close();
                return;
            }
            catch (IOException e) {
                logger.error((Object)e);
                if (bw == null) return;
                try {
                    bw.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
            catch (NamingException e) {
                logger.error((Object)e);
                if (bw == null) return;
                try {
                    bw.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public HashMap<String, ArrayList<HashMap<String, String>>> search(String searchBase, String searchString, String[] returningAttributes, int limit, boolean searchAtAllDC) throws NamingException {
        HashMap<String, ArrayList<HashMap<String, String>>> result = new HashMap<String, ArrayList<HashMap<String, String>>>();
        if (searchAtAllDC) {
            InitialLdapContext ctx = null;
            String[] stringArray = this.hosts;
            int n = this.hosts.length;
            int n2 = 0;
            while (n2 < n) {
                String host = stringArray[n2];
                ctx = this.getContext(host, this.MASTER_USER_DN, this.MASTER_PASSWORD, 1);
                if (ctx != null) {
                    ArrayList<HashMap<String, String>> oneResult = this.search(ctx, searchBase, searchString, returningAttributes, limit);
                    if (oneResult.size() > 0) {
                        result.put(host, oneResult);
                    }
                    this.close(ctx);
                } else {
                    logger.error((Object)("Unable to connect to " + host + " will try another host"));
                }
                ++n2;
            }
        } else {
            ArrayList<HashMap<String, String>> oneResult = this.search(searchBase, searchString, returningAttributes, limit);
            if (oneResult.size() > 0) {
                result.put("default", oneResult);
            }
        }
        return result;
    }

    private ArrayList<HashMap<String, String>> search(InitialLdapContext ctx, String searchBase, String searchString, String[] returningAttributes, int limit) throws NamingException {
        ArrayList<HashMap<String, String>> result = new ArrayList();
        SearchControls ctls = new SearchControls();
        ctls.setReturningObjFlag(true);
        ctls.setSearchScope(2);
        ctls.setReturningAttributes(returningAttributes);
        ctls.setCountLimit(limit);
        result = this.get_All(ctx, ctls, searchBase, searchString, returningAttributes);
        return result;
    }

    public ArrayList<HashMap<String, String>> search(String searchBase, String searchString, String[] returningAttributes, int limit) throws NamingException {
        ArrayList<HashMap<String, String>> result = new ArrayList();
        InitialLdapContext ctx = this.getContext();
        if (ctx == null) {
            throw new CommunicationException("Unable to init LDAP context");
        }
        SearchControls ctls = new SearchControls();
        ctls.setReturningObjFlag(true);
        ctls.setSearchScope(2);
        ctls.setReturningAttributes(returningAttributes);
        ctls.setCountLimit(limit);
        result = this.get_All(ctx, ctls, searchBase, searchString, returningAttributes);
        return result;
    }

    public ArrayList<HashMap<String, String>> getAllPaged(String searchBase, String searchString, String[] returningAttributes) {
        ArrayList<HashMap<String, String>> result = new ArrayList<HashMap<String, String>>();
        InitialLdapContext ctx = this.getContext();
        if (ctx == null) {
            return result;
        }
        try {
            PagedResultsControl prc = new PagedResultsControl(128, false);
            ctx.setRequestControls(new Control[]{prc});
            SearchControls ctls = new SearchControls();
            ctls.setReturningObjFlag(true);
            ctls.setSearchScope(2);
            ctls.setReturningAttributes(returningAttributes);
            byte[] b = null;
            do {
                ArrayList<HashMap<String, String>> pagedResult = this.get_All(ctx, ctls, searchBase, searchString, returningAttributes);
                result.addAll(pagedResult);
                Control[] prrcs = ctx.getResponseControls();
                PagedResultsResponseControl prrc = null;
                int prrcNum = 0;
                while (prrcNum < prrcs.length) {
                    if (prrcs[prrcNum] instanceof PagedResultsResponseControl) {
                        prrc = (PagedResultsResponseControl)prrcs[prrcNum];
                    }
                    ++prrcNum;
                }
                if (prrc == null || (b = prrc.getCookie()) == null) continue;
                ctx.setRequestControls(new Control[]{new PagedResultsControl(128, b, true)});
            } while (b != null);
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        catch (NamingException e) {
            logger.error((Object)e);
        }
        return result;
    }

    private ArrayList<HashMap<String, String>> get_All(InitialLdapContext ctx, SearchControls ctls, String searchBase, String searchString, String[] returningAttributes) throws NamingException {
        ArrayList<HashMap<String, String>> result = new ArrayList<HashMap<String, String>>();
        String filter = searchString;
        logger.debug((Object)("Loading from LDAP " + this.getCtxURL(ctx) + ". Filter: " + filter));
        NamingEnumeration<SearchResult> namingEnum = ctx.search(searchBase, filter, ctls);
        while (namingEnum.hasMoreElements()) {
            SearchResult searchResult = (SearchResult)namingEnum.nextElement();
            Attributes attribs = searchResult.getAttributes();
            HashMap<String, String> hashResult = new HashMap<String, String>();
            int i = 0;
            while (i < returningAttributes.length) {
                String at = returningAttributes[i];
                try {
                    BasicAttribute attr = (BasicAttribute)attribs.get(at);
                    if (attr.size() == 1) {
                        String value = attr.get(0).toString();
                        hashResult.put(at, value);
                    }
                    if (attr.size() > 1) {
                        JSONArray arr = new JSONArray();
                        int j = 0;
                        while (j < attr.size()) {
                            Object elem = attr.get(j);
                            if (elem != null) {
                                arr.put((Object)elem.toString());
                            }
                            ++j;
                        }
                        hashResult.put(at, arr.toString());
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("No attribute " + at + " filter: " + filter + " " + this.getCtxURL(ctx)));
                }
                ++i;
            }
            result.add(hashResult);
        }
        if (namingEnum != null) {
            try {
                namingEnum.close();
            }
            catch (Exception e) {
                logger.error((Object)"namingEnum closing error", (Throwable)e);
            }
        }
        logger.debug((Object)("Loaded " + result.size() + " elements from " + this.getCtxURL(ctx) + ". Filter: " + filter));
        return result;
    }

    public boolean removeUserFromGroup(String userDN, String groupDN, boolean applyToAll) {
        boolean result = false;
        if (applyToAll) {
            InitialLdapContext ctx = null;
            String[] stringArray = this.hosts;
            int n = this.hosts.length;
            int n2 = 0;
            while (n2 < n) {
                String host = stringArray[n2];
                ctx = this.getContext(host, this.MASTER_USER_DN, this.MASTER_PASSWORD, 1);
                if (ctx != null) {
                    boolean modResult = this.removeUserFromGroup(ctx, userDN, groupDN);
                    if (!modResult) {
                        logger.error((Object)("Unable at " + host + " remove user " + userDN + " from " + groupDN));
                    } else {
                        result = modResult;
                    }
                    this.close(ctx);
                } else {
                    logger.error((Object)("Unable to connect to " + host + " will try another host"));
                }
                ++n2;
            }
        } else {
            result = this.removeUserFromGroup(userDN, groupDN);
        }
        return result;
    }

    public boolean removeUserFromGroup(String userDN, String groupDN) {
        boolean result = false;
        InitialLdapContext ctx = this.getContext();
        if (ctx == null) {
            return result;
        }
        result = this.removeUserFromGroup(ctx, userDN, groupDN);
        return result;
    }

    public boolean removeUserFromGroup(InitialLdapContext ctx, String userDN, String groupDN) {
        boolean result = false;
        try {
            BasicAttribute member = new BasicAttribute("member", userDN);
            BasicAttributes atts = new BasicAttributes();
            atts.put(member);
            ctx.modifyAttributes(groupDN, 3, (Attributes)atts);
            result = true;
        }
        catch (OperationNotSupportedException ne) {
            result = true;
            logger.warn((Object)("User " + userDN + " was not found at of group " + groupDN));
        }
        catch (Exception e) {
            logger.error((Object)("Unable to remove user " + userDN + " from group " + groupDN), (Throwable)e);
        }
        return result;
    }

    public boolean addUserToGroup(String userDN, String groupDN, boolean applyToAll) {
        boolean result = false;
        if (applyToAll) {
            InitialLdapContext ctx = null;
            String[] stringArray = this.hosts;
            int n = this.hosts.length;
            int n2 = 0;
            while (n2 < n) {
                String host = stringArray[n2];
                ctx = this.getContext(host, this.MASTER_USER_DN, this.MASTER_PASSWORD, 1);
                if (ctx != null) {
                    boolean modResult = this.addUserToGroup(ctx, userDN, groupDN);
                    if (!modResult) {
                        logger.error((Object)("Unable at " + host + " add user " + userDN + " to " + groupDN));
                    } else {
                        result = modResult;
                    }
                    this.close(ctx);
                } else {
                    logger.error((Object)("Unable to connect to " + host + " will try another host"));
                }
                ++n2;
            }
        } else {
            result = this.addUserToGroup(userDN, groupDN);
        }
        return result;
    }

    public boolean addUserToGroup(String userDN, String groupDN) {
        boolean result = false;
        InitialLdapContext ctx = this.getContext();
        if (ctx == null) {
            return result;
        }
        result = this.addUserToGroup(ctx, userDN, groupDN);
        return result;
    }

    public boolean addUserToGroup(InitialLdapContext ctx, String userDN, String groupDN) {
        boolean result = false;
        try {
            BasicAttribute member = new BasicAttribute("member", userDN);
            BasicAttributes atts = new BasicAttributes();
            atts.put(member);
            ctx.modifyAttributes(groupDN, 1, (Attributes)atts);
            result = true;
        }
        catch (NameAlreadyBoundException ne) {
            result = true;
            logger.warn((Object)("User " + userDN + " is already member of group " + groupDN));
        }
        catch (Exception e) {
            logger.error((Object)("Unable to add user " + userDN + " to group " + groupDN), (Throwable)e);
        }
        return result;
    }

    public boolean passwordChangeByLogin(String login, String userSearchString, String searchBase, String oldPassword, String newPassword) {
        boolean result = false;
        try {
            String filter = String.format(userSearchString, login);
            String dn = this.getDN(filter, searchBase);
            logger.debug((Object)("Attempt to change password for DN " + dn));
            result = this.passwordChangeByDN(dn, oldPassword, newPassword);
            logger.debug((Object)("Password changed for login" + login));
        }
        catch (Exception e) {
            logger.error((Object)("passwordChangeByLogin error for login " + login), (Throwable)e);
        }
        return result;
    }

    public boolean passwordChangeByDN(String DN, String oldPassword, String newPassword) {
        boolean result = false;
        InitialLdapContext ctx = null;
        String[] stringArray = this.hosts;
        int n = this.hosts.length;
        int n2 = 0;
        while (n2 < n) {
            String host = stringArray[n2];
            ctx = this.getContext(host, DN, oldPassword);
            if (ctx != null) break;
            ++n2;
        }
        if (ctx == null) {
            return result;
        }
        try {
            String oldQuotedPassword = "\"" + oldPassword + "\"";
            String newQuotedPassword = "\"" + newPassword + "\"";
            BasicAttribute oldAttrib = new BasicAttribute("unicodePwd", oldQuotedPassword.getBytes("UTF-16LE"));
            BasicAttribute newAttrib = new BasicAttribute("unicodePwd", newQuotedPassword.getBytes("UTF-16LE"));
            ModificationItem[] mods = new ModificationItem[]{new ModificationItem(3, oldAttrib), new ModificationItem(1, newAttrib)};
            ctx.modifyAttributes(DN, mods);
            result = true;
            this.close(ctx);
        }
        catch (Exception e) {
            logger.error((Object)("Error passwordChange for " + DN), (Throwable)e);
        }
        return result;
    }

    public boolean modify(String DN, String attribute, Object value, boolean applyToAll) {
        boolean result = false;
        if (applyToAll) {
            InitialLdapContext ctx = null;
            String[] stringArray = this.hosts;
            int n = this.hosts.length;
            int n2 = 0;
            while (n2 < n) {
                String host = stringArray[n2];
                ctx = this.getContext(host, this.MASTER_USER_DN, this.MASTER_PASSWORD, 1);
                if (ctx != null) {
                    boolean modResult = this.modify(ctx, DN, attribute, value);
                    if (!modResult) {
                        logger.error((Object)("Unable to modify at " + host + " " + DN + " " + attribute));
                    } else {
                        result = modResult;
                    }
                    this.close(ctx);
                } else {
                    logger.error((Object)("Unable to connect to " + host + " will try another host"));
                }
                ++n2;
            }
        } else {
            result = this.modify(DN, attribute, value);
        }
        return result;
    }

    private boolean modify(InitialLdapContext ctx, String DN, String attribute, Object value) {
        boolean result = false;
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(2, new BasicAttribute(attribute, value))};
        try {
            logger.debug((Object)("Attempt to modify DN=" + DN + " attribute=" + attribute + " value=" + value.toString() + " at " + this.getCtxURL(ctx)));
            ctx.modifyAttributes(DN, mods);
            result = true;
        }
        catch (NamingException e) {
            logger.error((Object)("LDAP modify error DN=" + DN + " attribute=" + attribute + " value=" + value.toString() + " at " + this.getCtxURL(ctx)), (Throwable)e);
        }
        return result;
    }

    public boolean modify(String DN, String attribute, Object value) {
        boolean result = false;
        InitialLdapContext ctx = this.getContext();
        if (ctx == null) {
            return result;
        }
        result = this.modify(ctx, DN, attribute, value);
        return result;
    }

    public boolean rename(String oldDN, String newDN) {
        boolean result = false;
        InitialLdapContext ctx = this.getContext();
        if (ctx == null) {
            return result;
        }
        try {
            logger.debug((Object)("Attempt to move " + oldDN + " to " + newDN));
            ctx.rename(oldDN, newDN);
            logger.debug((Object)("OK moved " + oldDN + " to " + newDN));
            result = true;
        }
        catch (Exception e) {
            logger.error((Object)("Fail to move " + oldDN + " to " + newDN), (Throwable)e);
        }
        return result;
    }

    public String getDN(String filter, String searchBase) throws NamingException {
        logger.debug((Object)("Attempt to find DN using filter " + filter + " base:" + searchBase));
        InitialLdapContext ctx = this.getContext();
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        searchControls.setReturningAttributes(new String[]{"distinguishedName"});
        NamingEnumeration<SearchResult> searchResults = ctx.search(searchBase, filter, searchControls);
        if (!searchResults.hasMore()) {
            logger.error((Object)("can't resolve DN for filter " + filter));
            throw new NamingException("Can't resolve DN for filter " + filter);
        }
        SearchResult searchResult = searchResults.next();
        Attributes attributes = searchResult.getAttributes();
        Attribute dnAttribute = attributes.get("distinguishedName");
        String distinguishedName = (String)dnAttribute.get();
        logger.debug((Object)("DN found: " + distinguishedName + " filter: " + filter));
        return distinguishedName;
    }

    public void checkPassword(String login, String password, String userSearchString, String searchBase) throws NamingException {
        boolean isDisabled;
        if (login.isEmpty() || password.isEmpty()) {
            throw new AuthenticationException("Blank username or password");
        }
        String filter = String.format(userSearchString, login);
        logger.debug((Object)("Attempt to check password, using filter " + filter));
        InitialLdapContext ctx = this.getContext();
        if (ctx == null) {
            throw new AuthenticationException("Bind user auth fail");
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        searchControls.setReturningAttributes(new String[]{"distinguishedName"});
        NamingEnumeration<SearchResult> searchResults = ctx.search(searchBase, filter, searchControls);
        if (!searchResults.hasMore()) {
            logger.error((Object)("can't resolve DN for user " + login));
            throw new NamingException("Can't resolve DN for user " + login);
        }
        SearchResult searchResult = searchResults.next();
        Attributes attributes = searchResult.getAttributes();
        Attribute dnAttribute = attributes.get("distinguishedName");
        String userObject = (String)dnAttribute.get();
        logger.debug((Object)("DN for login " + login + " is " + userObject));
        int userAccountControl = 0;
        try {
            Attribute uACattrib = attributes.get("userAccountControl");
            if (uACattrib != null) {
                String userAccountControlString = (String)uACattrib.get();
                logger.debug((Object)("userAccountControlString String= " + userAccountControlString));
                int radix = 10;
                if (userAccountControlString.toLowerCase().startsWith("0x")) {
                    radix = 16;
                    userAccountControlString = userAccountControlString.substring(2, userAccountControlString.length());
                }
                if (userAccountControlString != null) {
                    userAccountControl = Integer.parseInt(userAccountControlString, radix);
                }
            }
        }
        catch (NumberFormatException e2) {
            logger.error((Object)e2);
        }
        catch (NamingException e2) {
            // empty catch block
        }
        boolean bl = isDisabled = (userAccountControl & 2) != 0;
        if (isDisabled) {
            logger.debug((Object)(String.valueOf(login) + "'s userAccountControl = " + userAccountControl + ". isDisabled=" + isDisabled));
            throw new NamingException("Login " + login + " is disabled");
        }
        InitialLdapContext userCtx = null;
        String[] stringArray = this.hosts;
        int n = this.hosts.length;
        int n2 = 0;
        while (n2 < n) {
            String host = stringArray[n2];
            userCtx = this.getContext(host, userObject, password);
            if (userCtx != null) break;
            ++n2;
        }
        if (userCtx == null) {
            logger.debug((Object)("Auth fail for user " + login));
            throw new NamingException("Password check fail for " + login);
        }
        logger.debug((Object)("Auth success for user " + userObject));
        userCtx.close();
    }

    private String getCtxURL(Context ctx) {
        String result = "error";
        try {
            result = (String)ctx.getEnvironment().get("java.naming.provider.url");
        }
        catch (Exception e) {
            logger.error((Object)"getCtxUrl error", (Throwable)e);
        }
        return result;
    }

    public static void main(String[] args) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException, SQLException, IOException, NamingException {
        BasicConfigurator.configure();
        TlsHelper.init("c:/temp/keystore.jks", "17atlkATLK");
        MySSLSocketFactory.init(TlsHelper.getSSLctx());
        LDAPHelper lh = new LDAPHelper("lapspc@bastion.local", "FYZxKPsxL4A9JLxOJsQq", "BST-MSK-DC-01.bastion.local", false, true);
        InitialLdapContext ctx = lh.getContext();
        String pc = "nb039625";
        String filter = "(samaccountName=n.klendar)";
        String attribs = "ms-Mcs-AdmPwd,ms-Mcs-AdmPwdExpirationTime,distinguishedName,memberOf,userAccountControl";
        boolean isPwdFound = false;
        HashSet<String> allPasswordsSet = new HashSet<String>();
        HashMap<String, ArrayList<HashMap<String, String>>> searchRes = lh.search("DC=bastion,DC=local", filter, attribs.split(","), 1, true);
        ArrayList<Object> searchResults = new ArrayList();
        for (String adHost : searchRes.keySet()) {
            ArrayList<HashMap<String, String>> sr = searchRes.get(adHost);
            if (sr.size() <= 0) continue;
            HashMap<String, String> r = sr.get(0);
            String pcDN = r.get("distinguishedName");
            if (!r.containsKey("ms-Mcs-AdmPwd")) continue;
            isPwdFound = true;
            allPasswordsSet.add(r.get("ms-Mcs-AdmPwd"));
            searchResults = sr;
        }
        logger.debug((Object)("getCompInfo " + pc + " isPwdFound:" + isPwdFound + " pwdCount: " + allPasswordsSet.size() + " DCcount: " + searchRes.size()));
    }

    public static int getConnectTimeout() {
        return connectTimeout;
    }

    public static void setConnectTimeout(int connectTimeout) {
        LDAPHelper.connectTimeout = connectTimeout;
    }

    public static int getReadTimeout() {
        return readTimeout;
    }

    public static void setReadTimeout(int readTimeout) {
        LDAPHelper.readTimeout = readTimeout;
    }
}

