/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.ldap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import org.apache.log4j.Logger;
import org.json.JSONArray;

public class LDAPImporter {
    InitialLdapContext ctx;
    static Logger logger = Logger.getLogger((String)LDAPImporter.class.getName());
    String base;
    boolean useSSL = false;
    boolean stopped;

    public LDAPImporter(String userName, String password, String host, String base, boolean useSSL) {
        this.base = base;
        this.stopped = false;
        this.useSSL = useSSL;
    }

    public LDAPImporter() {
    }

    public boolean modify(String DN, String attribute, String value) {
        boolean result = false;
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(2, new BasicAttribute(attribute, value))};
        try {
            logger.debug((Object)("Attempt to modify DN=" + DN + " attribute=" + attribute + " value=" + value.toString()));
            this.ctx.modifyAttributes(DN, mods);
            result = true;
        }
        catch (NamingException e) {
            logger.error((Object)("LDAP modify error DN=" + DN + " attribute=" + attribute + " value=" + value.toString()), (Throwable)e);
        }
        return result;
    }

    public ArrayList<HashMap<String, String>> getAllPaged(String searchString, String[] returningAttributes) {
        ArrayList<HashMap<String, String>> result = new ArrayList<HashMap<String, String>>();
        try {
            this.stopped = false;
            PagedResultsControl prc = new PagedResultsControl(128, false);
            this.ctx.setRequestControls(new Control[]{prc});
            SearchControls ctls = new SearchControls();
            ctls.setReturningObjFlag(true);
            ctls.setSearchScope(2);
            ctls.setReturningAttributes(returningAttributes);
            byte[] b = null;
            do {
                ArrayList<HashMap<String, String>> pagedResult = this.get_All(ctls, searchString, returningAttributes);
                result.addAll(pagedResult);
                if (this.stopped) continue;
                Control[] prrcs = this.ctx.getResponseControls();
                PagedResultsResponseControl prrc = null;
                int prrcNum = 0;
                while (prrcNum < prrcs.length) {
                    if (prrcs[prrcNum] instanceof PagedResultsResponseControl) {
                        prrc = (PagedResultsResponseControl)prrcs[prrcNum];
                    }
                    ++prrcNum;
                }
                if (prrc == null || (b = prrc.getCookie()) == null) continue;
                this.ctx.setRequestControls(new Control[]{new PagedResultsControl(128, b, true)});
            } while (b != null && !this.stopped);
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        catch (NamingException e) {
            logger.error((Object)e);
        }
        return result;
    }

    private ArrayList<HashMap<String, String>> get_All(SearchControls ctls, String searchString, String[] returningAttributes) throws NamingException {
        String filter = searchString;
        logger.debug((Object)("Loading from LDAP. Filter: " + filter));
        NamingEnumeration<SearchResult> namingEnum = this.ctx.search(this.base, filter, ctls);
        ArrayList<HashMap<String, String>> result = new ArrayList<HashMap<String, String>>();
        while (namingEnum.hasMoreElements() && !this.stopped) {
            SearchResult searchResult = (SearchResult)namingEnum.nextElement();
            Attributes attribs = searchResult.getAttributes();
            HashMap<String, String> hashResult = new HashMap<String, String>();
            int i = 0;
            while (i < returningAttributes.length) {
                String at = returningAttributes[i];
                try {
                    BasicAttribute attr = (BasicAttribute)attribs.get(at);
                    if (attr.size() == 1) {
                        String value = attr.get(0).toString();
                        hashResult.put(at, value);
                    }
                    if (attr.size() > 1) {
                        JSONArray arr = new JSONArray();
                        int j = 0;
                        while (j < attr.size()) {
                            Object elem = attr.get(j);
                            if (elem != null) {
                                arr.put((Object)elem.toString());
                            }
                            ++j;
                        }
                        hashResult.put(at, arr.toString());
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("No attribute " + at));
                }
                ++i;
            }
            result.add(hashResult);
        }
        if (namingEnum != null) {
            try {
                namingEnum.close();
            }
            catch (Exception e) {
                logger.error((Object)"namingEnum closing error", (Throwable)e);
            }
        }
        return result;
    }

    public void stop() {
        this.stopped = true;
    }
}

