/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.ldap;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Comparator;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.log4j.Logger;

public class MySSLSocketFactory
extends SocketFactory
implements Comparator<String> {
    static Logger logger = Logger.getLogger((String)MySSLSocketFactory.class.getName());
    private static SSLSocketFactory sf;

    public static void init(SSLContext ctx) {
        sf = ctx.getSocketFactory();
    }

    public static SocketFactory getDefault() {
        return new MySSLSocketFactory();
    }

    @Override
    public Socket createSocket() throws IOException {
        SSLSocket sslSocket = (SSLSocket)sf.createSocket();
        return sslSocket;
    }

    @Override
    public Socket createSocket(String arg0, int arg1) throws IOException, UnknownHostException {
        return sf.createSocket(arg0, arg1);
    }

    @Override
    public Socket createSocket(InetAddress arg0, int arg1) throws IOException {
        return sf.createSocket(arg0, arg1);
    }

    @Override
    public Socket createSocket(String arg0, int arg1, InetAddress arg2, int arg3) throws IOException, UnknownHostException {
        return sf.createSocket(arg0, arg1, arg2, arg3);
    }

    @Override
    public Socket createSocket(InetAddress arg0, int arg1, InetAddress arg2, int arg3) throws IOException {
        return sf.createSocket(arg0, arg1, arg2, arg3);
    }

    @Override
    public int compare(String s1, String s2) {
        return s1.compareTo(s2);
    }

    private void addHostNameVerification(SSLSocket sslSocket) {
        try {
            SSLParameters sslParams = new SSLParameters();
            Method m = sslParams.getClass().getMethod("setEndpointIdentificationAlgorithm", String.class);
            m.invoke((Object)sslParams, "LDAPS");
            sslSocket.setSSLParameters(sslParams);
        }
        catch (Throwable ee) {
            logger.warn((Object)"MySSLSocketFactory: Unable to turn on Hostname Verification");
        }
    }
}

