/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CRL;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.security.CertificateUtils;
import org.eclipse.jetty.util.security.CertificateValidator;
import org.eclipse.jetty.util.security.Password;

public class SslContextFactory
extends AbstractLifeCycle {
    public static final TrustManager[] TRUST_ALL_CERTS = new X509TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }};
    private static final Logger LOG = Log.getLogger(SslContextFactory.class);
    public static final String DEFAULT_KEYMANAGERFACTORY_ALGORITHM = Security.getProperty("ssl.KeyManagerFactory.algorithm") == null ? "SunX509" : Security.getProperty("ssl.KeyManagerFactory.algorithm");
    public static final String DEFAULT_TRUSTMANAGERFACTORY_ALGORITHM = Security.getProperty("ssl.TrustManagerFactory.algorithm") == null ? "SunX509" : Security.getProperty("ssl.TrustManagerFactory.algorithm");
    private final Set<String> _excludeProtocols = new LinkedHashSet<String>();
    private Set<String> _includeProtocols = null;
    private final Set<String> _excludeCipherSuites = new LinkedHashSet<String>();
    private Set<String> _includeCipherSuites = null;
    private String _keyStorePath;
    private String _keyStoreProvider;
    private String _keyStoreType = "JKS";
    private InputStream _keyStoreInputStream;
    private String _certAlias;
    private String _trustStorePath;
    private String _trustStoreProvider;
    private String _trustStoreType = "JKS";
    private InputStream _trustStoreInputStream;
    private boolean _needClientAuth = false;
    private boolean _wantClientAuth = false;
    private transient Password _keyStorePassword;
    private transient Password _keyManagerPassword;
    private transient Password _trustStorePassword;
    private String _sslProvider;
    private String _sslProtocol = "TLS";
    private String _secureRandomAlgorithm;
    private String _keyManagerFactoryAlgorithm = DEFAULT_KEYMANAGERFACTORY_ALGORITHM;
    private String _trustManagerFactoryAlgorithm = DEFAULT_TRUSTMANAGERFACTORY_ALGORITHM;
    private boolean _validateCerts;
    private boolean _validatePeerCerts;
    private int _maxCertPathLength = -1;
    private String _crlPath;
    private boolean _enableCRLDP = false;
    private boolean _enableOCSP = false;
    private String _ocspResponderURL;
    private KeyStore _keyStore;
    private KeyStore _trustStore;
    private boolean _sessionCachingEnabled = true;
    private SSLContext _context;
    private boolean _trustAll = true;

    protected void doStart() throws Exception {
        if (this._context == null) {
            if (this._keyStore == null && this._keyStoreInputStream == null && this._keyStorePath == null && this._trustStore == null && this._trustStoreInputStream == null && this._trustStorePath == null) {
                TrustManager[] trust_managers = null;
                if (this._trustAll) {
                    LOG.debug("No keystore or trust store configured.  ACCEPTING UNTRUSTED CERTIFICATES!!!!!", new Object[0]);
                    trust_managers = TRUST_ALL_CERTS;
                }
                SecureRandom secureRandom = this._secureRandomAlgorithm == null ? null : SecureRandom.getInstance(this._secureRandomAlgorithm);
                this._context = SSLContext.getInstance(this._sslProtocol);
                this._context.init(null, trust_managers, secureRandom);
            } else {
                this.checkKeyStore();
                KeyStore keyStore = this.loadKeyStore();
                KeyStore trustStore = this.loadTrustStore();
                Collection<? extends CRL> crls = this.loadCRL(this._crlPath);
                if (this._validateCerts && keyStore != null) {
                    Certificate cert;
                    if (this._certAlias == null) {
                        ArrayList<String> aliases = Collections.list(keyStore.aliases());
                        this._certAlias = aliases.size() == 1 ? (String)aliases.get(0) : null;
                    }
                    Certificate certificate = cert = this._certAlias == null ? null : keyStore.getCertificate(this._certAlias);
                    if (cert == null) {
                        throw new Exception("No certificate found in the keystore" + (this._certAlias == null ? "" : " for alias " + this._certAlias));
                    }
                    CertificateValidator validator = new CertificateValidator(trustStore, crls);
                    validator.setMaxCertPathLength(this._maxCertPathLength);
                    validator.setEnableCRLDP(this._enableCRLDP);
                    validator.setEnableOCSP(this._enableOCSP);
                    validator.setOcspResponderURL(this._ocspResponderURL);
                    validator.validate(keyStore, cert);
                }
                KeyManager[] keyManagers = this.getKeyManagers(keyStore);
                TrustManager[] trustManagers = this.getTrustManagers(trustStore, crls);
                SecureRandom secureRandom = this._secureRandomAlgorithm == null ? null : SecureRandom.getInstance(this._secureRandomAlgorithm);
                this._context = this._sslProvider == null ? SSLContext.getInstance(this._sslProtocol) : SSLContext.getInstance(this._sslProtocol, this._sslProvider);
                this._context.init(keyManagers, trustManagers, secureRandom);
                SSLEngine engine = this.newSslEngine();
                LOG.info("Enabled Protocols {} of {}", new Object[]{Arrays.asList(engine.getEnabledProtocols()), Arrays.asList(engine.getSupportedProtocols())});
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Enabled Ciphers   {} of {}", new Object[]{Arrays.asList(engine.getEnabledCipherSuites()), Arrays.asList(engine.getSupportedCipherSuites())});
                }
            }
        }
    }

    public boolean getNeedClientAuth() {
        return this._needClientAuth;
    }

    public boolean getWantClientAuth() {
        return this._wantClientAuth;
    }

    protected KeyStore loadKeyStore() throws Exception {
        throw new Error("Unresolved compilation problem: \n\tThe method getKeyStore(InputStream, String, String, String, ((_keyStorePassword == null) ? null : _keyStorePassword.toString())) is undefined for the type SslContextFactory\n");
    }

    protected KeyStore loadTrustStore() throws Exception {
        throw new Error("Unresolved compilation problem: \n\tThe method getKeyStore(InputStream, String, String, String, ((_trustStorePassword == null) ? null : _trustStorePassword.toString())) is undefined for the type SslContextFactory\n");
    }

    protected Collection<? extends CRL> loadCRL(String crlPath) throws Exception {
        return CertificateUtils.loadCRL((String)crlPath);
    }

    protected KeyManager[] getKeyManagers(KeyStore keyStore) throws Exception {
        throw new Error("Unresolved compilation problem: \n\tAliasedX509Exten11dedKeyManager cannot be resolved to a type\n");
    }

    protected TrustManager[] getTrustManagers(KeyStore trustStore, Collection<? extends CRL> crls) throws Exception {
        TrustManager[] managers = null;
        if (trustStore != null) {
            if (this._validatePeerCerts && this._trustManagerFactoryAlgorithm.equalsIgnoreCase("PKIX")) {
                PKIXBuilderParameters pbParams = new PKIXBuilderParameters(trustStore, (CertSelector)new X509CertSelector());
                pbParams.setMaxPathLength(this._maxCertPathLength);
                pbParams.setRevocationEnabled(true);
                if (crls != null && !crls.isEmpty()) {
                    pbParams.addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters(crls)));
                }
                if (this._enableCRLDP) {
                    System.setProperty("com.sun.security.enableCRLDP", "true");
                }
                if (this._enableOCSP) {
                    Security.setProperty("ocsp.enable", "true");
                    if (this._ocspResponderURL != null) {
                        Security.setProperty("ocsp.responderURL", this._ocspResponderURL);
                    }
                }
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(this._trustManagerFactoryAlgorithm);
                trustManagerFactory.init(new CertPathTrustManagerParameters(pbParams));
                managers = trustManagerFactory.getTrustManagers();
            } else {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(this._trustManagerFactoryAlgorithm);
                trustManagerFactory.init(trustStore);
                managers = trustManagerFactory.getTrustManagers();
            }
        }
        return managers;
    }

    public void checkKeyStore() {
        if (this._context != null) {
            return;
        }
        if (this._keyStore == null && this._keyStoreInputStream == null && this._keyStorePath == null) {
            throw new IllegalStateException("SSL doesn't have a valid keystore");
        }
        if (this._trustStore == null && this._trustStoreInputStream == null && this._trustStorePath == null) {
            this._trustStore = this._keyStore;
            this._trustStorePath = this._keyStorePath;
            this._trustStoreInputStream = this._keyStoreInputStream;
            this._trustStoreType = this._keyStoreType;
            this._trustStoreProvider = this._keyStoreProvider;
            this._trustStorePassword = this._keyStorePassword;
            this._trustManagerFactoryAlgorithm = this._keyManagerFactoryAlgorithm;
        }
        if (this._keyStoreInputStream != null && this._keyStoreInputStream == this._trustStoreInputStream) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                IO.copy((InputStream)this._keyStoreInputStream, (OutputStream)baos);
                this._keyStoreInputStream.close();
                this._keyStoreInputStream = new ByteArrayInputStream(baos.toByteArray());
                this._trustStoreInputStream = new ByteArrayInputStream(baos.toByteArray());
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    public String[] selectProtocols(String[] enabledProtocols, String[] supportedProtocols) {
        LinkedHashSet<String> selected_protocols = new LinkedHashSet<String>();
        if (this._includeProtocols != null) {
            for (String protocol : this._includeProtocols) {
                if (!Arrays.asList(supportedProtocols).contains(protocol)) continue;
                selected_protocols.add(protocol);
            }
        } else {
            selected_protocols.addAll(Arrays.asList(enabledProtocols));
        }
        if (this._excludeProtocols != null) {
            selected_protocols.removeAll(this._excludeProtocols);
        }
        return selected_protocols.toArray(new String[selected_protocols.size()]);
    }

    public String[] selectCipherSuites(String[] enabledCipherSuites, String[] supportedCipherSuites) {
        LinkedHashSet<String> selected_ciphers = new LinkedHashSet<String>();
        if (this._includeCipherSuites != null) {
            for (String cipherSuite : this._includeCipherSuites) {
                if (!Arrays.asList(supportedCipherSuites).contains(cipherSuite)) continue;
                selected_ciphers.add(cipherSuite);
            }
        } else {
            selected_ciphers.addAll(Arrays.asList(enabledCipherSuites));
        }
        if (this._excludeCipherSuites != null) {
            selected_ciphers.removeAll(this._excludeCipherSuites);
        }
        return selected_ciphers.toArray(new String[selected_ciphers.size()]);
    }

    public boolean isSessionCachingEnabled() {
        return this._sessionCachingEnabled;
    }

    public SSLEngine newSslEngine(String host, int port) {
        SSLEngine sslEngine = this.isSessionCachingEnabled() ? this._context.createSSLEngine(host, port) : this._context.createSSLEngine();
        this.customize(sslEngine);
        return sslEngine;
    }

    public SSLEngine newSslEngine() {
        SSLEngine sslEngine = this._context.createSSLEngine();
        this.customize(sslEngine);
        return sslEngine;
    }

    public void customize(SSLEngine sslEngine) {
        if (this.getWantClientAuth()) {
            sslEngine.setWantClientAuth(this.getWantClientAuth());
        }
        if (this.getNeedClientAuth()) {
            sslEngine.setNeedClientAuth(this.getNeedClientAuth());
        }
        sslEngine.setEnabledCipherSuites(this.selectCipherSuites(sslEngine.getEnabledCipherSuites(), sslEngine.getSupportedCipherSuites()));
        sslEngine.setEnabledProtocols(this.selectProtocols(sslEngine.getEnabledProtocols(), sslEngine.getSupportedProtocols()));
    }

    public String toString() {
        return String.format("%s@%x(%s,%s)", ((Object)((Object)this)).getClass().getSimpleName(), ((Object)((Object)this)).hashCode(), this._keyStorePath, this._trustStorePath);
    }
}

