/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.tls;

import com.ksoft.tls.AliasedX509ExtendedKeyManager;
import com.sun.jersey.client.urlconnection.HTTPSProperties;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import java.util.Enumeration;
import java.util.Random;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.json.JSONArray;
import org.json.JSONObject;
import sun.security.pkcs.PKCS9Attribute;
import sun.security.pkcs10.PKCS10;
import sun.security.pkcs10.PKCS10Attribute;
import sun.security.tools.keytool.CertAndKeyGen;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.DNSName;
import sun.security.x509.Extension;
import sun.security.x509.GeneralName;
import sun.security.x509.GeneralNames;
import sun.security.x509.KeyUsageExtension;
import sun.security.x509.SubjectAlternativeNameExtension;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public class TlsHelper {
    static Logger logger = Logger.getLogger((String)TlsHelper.class.getName());
    static KeyManagerFactory kmf = null;
    static SSLSocketFactory sslSocketFactory = null;
    static KeyStore keyStore = null;
    static HostnameVerifier hostnameVerifier = null;
    static SSLContext ctx = null;
    static SslContextFactory sslContextFactory = null;
    static TrustManagerFactory tmf = null;
    static KeyManager[] keyManagers = null;
    static String keyStoreFile;
    static String certAlias;
    static char[] JKS_PASSWORD;
    static int READ_TIMEOUT;
    static int CONNECT_TIMEOUT;
    static String PROXY_URI;
    static String PROXY_USERNAME;
    static String PROXY_PASSWORD;
    public static final String DEFAULT_KEYMANAGERFACTORY_ALGORITHM;
    public static final String DEFAULT_TRUSTMANAGERFACTORY_ALGORITHM;
    private static String _keyManagerFactoryAlgorithm;

    static {
        certAlias = "jetty";
        READ_TIMEOUT = 10000;
        CONNECT_TIMEOUT = 1000;
        PROXY_URI = "";
        PROXY_USERNAME = "";
        PROXY_PASSWORD = "";
        DEFAULT_KEYMANAGERFACTORY_ALGORITHM = Security.getProperty("ssl.KeyManagerFactory.algorithm") == null ? "SunX509" : Security.getProperty("ssl.KeyManagerFactory.algorithm");
        DEFAULT_TRUSTMANAGERFACTORY_ALGORITHM = Security.getProperty("ssl.TrustManagerFactory.algorithm") == null ? "SunX509" : Security.getProperty("ssl.TrustManagerFactory.algorithm");
        _keyManagerFactoryAlgorithm = DEFAULT_KEYMANAGERFACTORY_ALGORITHM;
    }

    public static void init(String jksFilePath, String password) {
        keyStoreFile = jksFilePath;
        JKS_PASSWORD = password.toCharArray();
        char[] KEY_PASSWORD = password.toCharArray();
        try {
            if (Files.notExists(Paths.get(keyStoreFile, new String[0]), new LinkOption[0])) {
                TlsHelper.createKeyStore(keyStoreFile, password);
            }
            keyStore = KeyStore.getInstance("JKS");
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream is = new FileInputStream(keyStoreFile);){
                keyStore.load(is, JKS_PASSWORD);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, KEY_PASSWORD);
            tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keyStore);
            ctx = SSLContext.getInstance("TLSv1.2");
            ctx.init(keyManagers, tmf.getTrustManagers(), new SecureRandom());
            sslSocketFactory = ctx.getSocketFactory();
            sslContextFactory = new SslContextFactory(jksFilePath);
            sslContextFactory.setKeyStorePassword(password);
            if (keyStore.containsAlias(certAlias) && keyStore.isKeyEntry(certAlias)) {
                sslContextFactory.setCertAlias(certAlias);
                logger.debug((Object)("sslContextFactory.setCertAlia " + certAlias));
            } else {
                logger.error((Object)("Cert alias not found " + certAlias));
            }
            hostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
            logger.debug((Object)"KeyStore init completed");
        }
        catch (Exception e) {
            logger.error((Object)"TLS init error", (Throwable)e);
        }
    }

    public static KeyManager[] getKeyManagers(KeyStore keyStore, String password) throws Exception {
        KeyManager[] managers = null;
        if (keyStore != null) {
            kmf = KeyManagerFactory.getInstance(_keyManagerFactoryAlgorithm);
            kmf.init(keyStore, password.toCharArray());
            managers = kmf.getKeyManagers();
            if (certAlias != null) {
                int idx = 0;
                while (idx < managers.length) {
                    if (managers[idx] instanceof X509KeyManager) {
                        managers[idx] = new AliasedX509ExtendedKeyManager(certAlias, (X509KeyManager)managers[idx]);
                    }
                    ++idx;
                }
            }
        }
        return managers;
    }

    public static void setSslContextFactoryCertAlias(String alias) {
        try {
            certAlias = alias;
            if (keyStore != null && keyStore.containsAlias(certAlias) && keyStore.isKeyEntry(certAlias)) {
                if (sslContextFactory != null) {
                    sslContextFactory.setCertAlias(certAlias);
                }
                logger.debug((Object)("sslContextFactory.setCertAlia " + certAlias));
            } else {
                logger.error((Object)("Cert alias not found " + alias));
            }
        }
        catch (Exception e) {
            logger.error((Object)("setSslContextFactoryCertAlias " + alias + " error"), (Throwable)e);
        }
    }

    public static void reinit() throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException, KeyManagementException, FileNotFoundException, IOException, CertificateException {
        keyStore = KeyStore.getInstance("JKS");
        Throwable throwable = null;
        Object var1_2 = null;
        try (FileInputStream is = new FileInputStream(keyStoreFile);){
            keyStore.load(is, JKS_PASSWORD);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(keyStore, JKS_PASSWORD);
        tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(keyStore);
        ctx = SSLContext.getInstance("TLSv1.2");
        ctx.init(kmf.getKeyManagers(), tmf.getTrustManagers(), new SecureRandom());
        sslSocketFactory = ctx.getSocketFactory();
        sslContextFactory = new SslContextFactory();
        sslContextFactory.setSslContext(ctx);
        hostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
    }

    private static void createKeyStore(String keyPath, String password) {
        try {
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(null, password.toCharArray());
            FileOutputStream fos = new FileOutputStream(keyPath);
            ks.store(fos, password.toCharArray());
            fos.close();
            logger.debug((Object)("Key store created " + keyPath));
        }
        catch (Exception e) {
            logger.error((Object)"create keystore error", (Throwable)e);
        }
    }

    public static void importSignedCertificate(String alias, X509Certificate issuerCert, X509Certificate cert, PrivateKey privateKey) {
        try {
            Certificate[] chain = new X509Certificate[]{cert, issuerCert};
            keyStore.setKeyEntry(alias, privateKey, JKS_PASSWORD, chain);
            FileOutputStream out = new FileOutputStream(keyStoreFile);
            keyStore.store(out, JKS_PASSWORD);
            out.close();
            logger.debug((Object)"============import signed certificate complited");
        }
        catch (Exception e) {
            logger.error((Object)"importSignedCertificate error", (Throwable)e);
        }
    }

    public static void generateSelfSignedCertificate(String certAlias, String CN) {
        try {
            Enumeration<String> aliases = keyStore.aliases();
            logger.debug((Object)("Self signed certificate generation for CN " + CN + " started, please wait"));
            CertAndKeyGen keyGen = new CertAndKeyGen("RSA", "SHA256WithRSA", null);
            keyGen.generate(2048);
            Certificate[] chain = new X509Certificate[1];
            if (!CN.startsWith("CN=")) {
                CN = "CN=" + CN;
            }
            if (CN.contains(";")) {
                CN = CN.substring(0, CN.indexOf(";"));
            }
            chain[0] = keyGen.getSelfCertificate(new X500Name(CN), 315360000L);
            keyStore.setKeyEntry(certAlias, keyGen.getPrivateKey(), JKS_PASSWORD, chain);
            FileOutputStream out = new FileOutputStream(keyStoreFile);
            keyStore.store(out, JKS_PASSWORD);
            out.close();
            logger.debug((Object)"Self signed certificate complited");
        }
        catch (Exception e) {
            logger.error((Object)"generateSSLcertificate error", (Throwable)e);
        }
    }

    public static PKCS10 generateCSR(PublicKey publicKey, PrivateKey privateKey, String sigAlg, String CN) {
        PKCS10 pkcs10 = null;
        try {
            pkcs10 = new PKCS10(publicKey);
            Signature signature = Signature.getInstance(sigAlg);
            signature.initSign(privateKey);
            String _CN = CN;
            if (!CN.startsWith("CN=")) {
                _CN = "CN=" + _CN;
            }
            if (_CN.contains(";")) {
                _CN = _CN.substring(0, _CN.indexOf(";"));
            }
            String[] dnsNames = CN.split(";");
            GeneralNames gNames = new GeneralNames();
            int i = 0;
            while (i < dnsNames.length) {
                DNSName n = new DNSName(dnsNames[i]);
                gNames.add(new GeneralName(new DNSName(dnsNames[i])));
                ++i;
            }
            X500Name x500Name = new X500Name(_CN);
            CertificateExtensions ext = new CertificateExtensions();
            ext.set("SubjectAlternativeName", new SubjectAlternativeNameExtension((Boolean)false, gNames));
            pkcs10.getAttributes().setAttribute("extensions", new PKCS10Attribute(PKCS9Attribute.EXTENSION_REQUEST_OID, ext));
            pkcs10.encodeAndSign(x500Name, signature);
        }
        catch (Exception e) {
            logger.error((Object)("generateCSR for " + CN + " error"), (Throwable)e);
        }
        return pkcs10;
    }

    public static X509Certificate signCSR(PKCS10 csr, X509Certificate signerCert, PrivateKey signerPrivKey, int VALIDITY_DAYS) throws CertificateException, IOException, InvalidKeyException, SignatureException {
        Signature signature;
        String issuerSigAlg = signerCert.getSigAlgName();
        Principal issuer = signerCert.getSubjectDN();
        byte[] inCertBytes = signerCert.getTBSCertificate();
        X509CertInfo signerCertInfo = new X509CertInfo(inCertBytes);
        Date firstDate = new Date();
        Date lastDate = new Date();
        lastDate.setTime(firstDate.getTime() + (long)VALIDITY_DAYS * 1000L * 24L * 60L * 60L);
        CertificateValidity interval = new CertificateValidity(firstDate, lastDate);
        try {
            signature = Signature.getInstance(issuerSigAlg);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        signature.initSign(signerPrivKey);
        X509CertInfo certInfo = new X509CertInfo();
        certInfo.set("validity", interval);
        certInfo.set("serialNumber", new CertificateSerialNumber(new Random().nextInt() & Integer.MAX_VALUE));
        certInfo.set("version", new CertificateVersion(2));
        try {
            certInfo.set("algorithmID", new CertificateAlgorithmId(AlgorithmId.get(issuerSigAlg)));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        certInfo.set("issuer", (X500Name)issuer);
        certInfo.set("key", new CertificateX509Key(csr.getSubjectPublicKeyInfo()));
        certInfo.set("subject", csr.getSubjectName());
        CertificateExtensions extensions = new CertificateExtensions();
        boolean[] keyUsagePolicies = new boolean[9];
        keyUsagePolicies[0] = true;
        keyUsagePolicies[2] = true;
        KeyUsageExtension kue = new KeyUsageExtension(keyUsagePolicies);
        byte[] keyUsageValue = new DerValue(4, kue.getExtensionValue()).toByteArray();
        extensions.set("KeyUsage", new Extension(kue.getExtensionId(), true, keyUsageValue));
        X509CertImpl cert = new X509CertImpl(certInfo);
        try {
            cert.sign(signerPrivKey, issuerSigAlg);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException(e);
        }
        return cert;
    }

    public static HTTPSProperties getHTTPSProperties() {
        HTTPSProperties props = new HTTPSProperties(hostnameVerifier, ctx);
        return props;
    }

    public static SSLContext getSSLctx() {
        return ctx;
    }

    public static X509Certificate getCertificate(String alias) throws KeyStoreException {
        X509Certificate cert = (X509Certificate)keyStore.getCertificate(alias);
        return cert;
    }

    public static PrivateKey getPrivateKey(String alias) {
        PrivateKey privateKey = null;
        try {
            privateKey = (PrivateKey)keyStore.getKey(alias, JKS_PASSWORD);
        }
        catch (Exception e) {
            logger.error((Object)("unable to get private key " + alias), (Throwable)e);
        }
        return privateKey;
    }

    public static JSONArray listCerts() {
        JSONArray array = new JSONArray();
        try {
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                KeyStore.Entry entry;
                String alias = aliases.nextElement();
                try {
                    entry = keyStore.getEntry(alias, null);
                }
                catch (UnrecoverableKeyException une) {
                    entry = keyStore.getEntry(alias, new KeyStore.PasswordProtection(JKS_PASSWORD));
                }
                if (entry == null) continue;
                X509Certificate cert = (X509Certificate)keyStore.getCertificate(alias);
                String type = entry.getClass().getSimpleName().replaceAll("Entry", "");
                JSONObject json = new JSONObject();
                json.put("id", (Object)alias);
                json.put("type", (Object)type);
                json.put("dn", (Object)cert.getSubjectDN().getName());
                json.put("issuer", (Object)cert.getIssuerDN().getName());
                json.put("sig_alg", (Object)cert.getSigAlgName());
                json.put("not_after", (Object)cert.getNotAfter().toString());
                json.put("not_before", (Object)cert.getNotBefore().toString());
                array.put((Object)json);
            }
        }
        catch (Exception e) {
            logger.error((Object)"listCert error", (Throwable)e);
        }
        return array;
    }

    public static void importCert(String certfile, String alias) {
        try {
            logger.debug((Object)("Try to import certificate from file " + certfile + " " + alias + " imported"));
            FileInputStream fis = new FileInputStream(certfile);
            DataInputStream dis = new DataInputStream(fis);
            byte[] bytes = new byte[dis.available()];
            dis.readFully(bytes);
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream certstream = bais;
            X509Certificate certs = (X509Certificate)cf.generateCertificate(certstream);
            if (keyStore.containsAlias(alias)) {
                PrivateKey privateKey = TlsHelper.getPrivateKey(alias);
                if (privateKey != null) {
                    logger.debug((Object)("Private key found for alias " + alias));
                    Certificate[] chain = new X509Certificate[]{certs};
                    keyStore.setKeyEntry(alias, privateKey, JKS_PASSWORD, chain);
                } else {
                    logger.debug((Object)("Certificate for alias " + alias + " already exists, will be replaced by new one"));
                    keyStore.setCertificateEntry(alias, certs);
                }
            } else {
                logger.debug((Object)("New certificate for alias " + alias));
                keyStore.setCertificateEntry(alias, certs);
            }
            FileOutputStream out = new FileOutputStream(keyStoreFile);
            keyStore.store(out, JKS_PASSWORD);
            out.close();
            logger.debug((Object)("Certificate from file " + certfile + " " + alias + " imported"));
        }
        catch (Exception e) {
            logger.error((Object)("Add certificate error " + certfile + " " + alias), (Throwable)e);
        }
    }

    public static HostnameVerifier getHostnameVerifier() {
        return hostnameVerifier;
    }

    public static void flusStore() throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        FileOutputStream out = new FileOutputStream(keyStoreFile);
        keyStore.store(out, JKS_PASSWORD);
        out.close();
    }

    public static void setTimeOuts(int connect_timeout, int read_timeout) {
        READ_TIMEOUT = read_timeout;
        CONNECT_TIMEOUT = connect_timeout;
    }

    public static void setProxy(String proxy_uri, String username, String password) {
        PROXY_URI = proxy_uri;
        PROXY_USERNAME = username;
        PROXY_PASSWORD = password;
    }

    public static Client getTlsClient() {
        Client client = ClientBuilder.newBuilder().hostnameVerifier(TlsHelper.getHostnameVerifier()).sslContext(TlsHelper.getSSLctx()).build();
        client.property("jersey.config.client.readTimeout", (Object)READ_TIMEOUT);
        client.property("jersey.config.client.connectTimeout", (Object)CONNECT_TIMEOUT);
        return client;
    }

    public static Client getTlsClientWithProxy() {
        ClientConfig config = new ClientConfig();
        config.property("jersey.config.client.readTimeout", (Object)READ_TIMEOUT);
        config.property("jersey.config.client.connectTimeout", (Object)CONNECT_TIMEOUT);
        if (PROXY_URI != null && !PROXY_URI.isEmpty()) {
            config.connectorProvider((ConnectorProvider)new ApacheConnectorProvider());
            config.property("jersey.config.client.proxy.uri", (Object)PROXY_URI);
            if (PROXY_USERNAME != null && !PROXY_USERNAME.isEmpty()) {
                config.property("jersey.config.client.proxy.username", (Object)PROXY_USERNAME);
            }
            if (PROXY_PASSWORD != null && !PROXY_PASSWORD.isEmpty()) {
                config.property("jersey.config.client.proxy.password", (Object)PROXY_PASSWORD);
            }
        }
        Client client = ClientBuilder.newBuilder().hostnameVerifier(TlsHelper.getHostnameVerifier()).sslContext(TlsHelper.getSSLctx()).withConfig((Configuration)config).build();
        return client;
    }

    public static Client getTrustAllTlsClient() throws KeyManagementException, NoSuchAlgorithmException {
        Client client = ClientBuilder.newBuilder().hostnameVerifier(TlsHelper.getTrustToAllHostnameVerifier()).sslContext(TlsHelper.getTrusToAllSSLContext()).build();
        client.property("jersey.config.client.readTimeout", (Object)READ_TIMEOUT);
        client.property("jersey.config.client.connectTimeout", (Object)CONNECT_TIMEOUT);
        return client;
    }

    public static Client getTrustAllTlsClientWithProxy() throws KeyManagementException, NoSuchAlgorithmException {
        ClientConfig config = new ClientConfig();
        config.property("jersey.config.client.readTimeout", (Object)READ_TIMEOUT);
        config.property("jersey.config.client.connectTimeout", (Object)CONNECT_TIMEOUT);
        if (PROXY_URI != null && !PROXY_URI.isEmpty()) {
            config.connectorProvider((ConnectorProvider)new ApacheConnectorProvider());
            config.property("jersey.config.client.proxy.uri", (Object)PROXY_URI);
            if (PROXY_USERNAME != null && !PROXY_USERNAME.isEmpty()) {
                config.property("jersey.config.client.proxy.username", (Object)PROXY_USERNAME);
            }
            if (PROXY_PASSWORD != null && !PROXY_PASSWORD.isEmpty()) {
                config.property("jersey.config.client.proxy.password", (Object)PROXY_PASSWORD);
            }
        }
        Client client = ClientBuilder.newBuilder().hostnameVerifier(TlsHelper.getTrustToAllHostnameVerifier()).sslContext(TlsHelper.getTrusToAllSSLContext()).withConfig((Configuration)config).build();
        return client;
    }

    public static Client getTlsClient(boolean doTlsCheck, boolean useProxy) throws KeyManagementException, NoSuchAlgorithmException {
        Client client = null;
        client = useProxy ? (!doTlsCheck ? TlsHelper.getTrustAllTlsClientWithProxy() : TlsHelper.getTlsClientWithProxy()) : (!doTlsCheck ? TlsHelper.getTrustAllTlsClient() : TlsHelper.getTlsClient());
        return client;
    }

    public static void deleteCert(String alias) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        keyStore.deleteEntry(alias);
        TlsHelper.flusStore();
        logger.debug((Object)("Enrty with alias " + alias + " deleted from store"));
    }

    public static SslContextFactory getSslContextFactory() {
        return sslContextFactory;
    }

    public static TrustManagerFactory getTrustManagerFactory() {
        return tmf;
    }

    public static SSLContext getTrusToAllSSLContext() throws KeyManagementException, NoSuchAlgorithmException {
        X509TrustManager tm = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        SSLContext sc = SSLContext.getInstance("TLS");
        sc.init(null, new TrustManager[]{tm}, new SecureRandom());
        return sc;
    }

    public static SSLSocketFactory getTrustToAllSSLSocketFactory() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sc = TlsHelper.getTrusToAllSSLContext();
        return sc.getSocketFactory();
    }

    public static boolean isKeyStoreHasCertForUrl(String httpsUrl) {
        boolean result = false;
        try {
            URL destinationURL = new URL(httpsUrl);
            result = keyStore.containsAlias(destinationURL.getHost());
            logger.debug((Object)("IS key store contains certificate for " + httpsUrl + " => " + result));
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return result;
    }

    public static boolean importHostCertificate(String httpsUrl) {
        boolean imported = false;
        try {
            URL destinationURL = new URL(httpsUrl);
            HttpsURLConnection conn = (HttpsURLConnection)destinationURL.openConnection();
            conn.setHostnameVerifier(TlsHelper.getTrustToAllHostnameVerifier());
            conn.setSSLSocketFactory(TlsHelper.getTrustToAllSSLSocketFactory());
            conn.connect();
            Certificate[] certs = conn.getServerCertificates();
            logger.debug((Object)("Import certificate from host " + httpsUrl));
            boolean i = true;
            Certificate[] certificateArray = certs;
            int n = certs.length;
            int n2 = 0;
            while (n2 < n) {
                Certificate cert = certificateArray[n2];
                logger.debug((Object)("Certificate is: " + cert));
                if (cert instanceof X509Certificate) {
                    try {
                        ((X509Certificate)cert).checkValidity();
                        keyStore.setCertificateEntry(destinationURL.getHost(), cert);
                        FileOutputStream out = new FileOutputStream(keyStoreFile);
                        keyStore.store(out, JKS_PASSWORD);
                        out.close();
                        imported = true;
                    }
                    catch (Exception cee) {
                        System.out.println("Certificate is expired");
                    }
                } else {
                    System.err.println("Unknown certificate type: " + cert);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            logger.error((Object)("importHostCertificate from " + httpsUrl + " error"), (Throwable)e);
        }
        return imported;
    }

    private static HostnameVerifier getTrustToAllHostnameVerifier() {
        return new HostnameVerifier(){

            @Override
            public boolean verify(String arg0, SSLSession arg1) {
                return true;
            }
        };
    }

    public static void SavePublicKey(String filePath, PublicKey key) throws IOException {
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(key.getEncoded());
        FileOutputStream fos = new FileOutputStream(filePath);
        fos.write(x509EncodedKeySpec.getEncoded());
        fos.close();
    }

    public static void SavePrivateKey(String filePath, PrivateKey key) throws IOException {
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(key.getEncoded());
        FileOutputStream fos = new FileOutputStream(filePath);
        fos = new FileOutputStream(filePath);
        fos.write(pkcs8EncodedKeySpec.getEncoded());
        fos.close();
    }

    public static PrivateKey LoadPrivateKey(String path, String algorithm) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        File filePrivateKey = new File(path);
        FileInputStream fis = new FileInputStream(path);
        byte[] encodedPrivateKey = new byte[(int)filePrivateKey.length()];
        fis.read(encodedPrivateKey);
        fis.close();
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(encodedPrivateKey);
        PrivateKey privateKey = keyFactory.generatePrivate(privateKeySpec);
        return privateKey;
    }

    public static PublicKey LoadPublicKey(String path, String algorithm) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        File filePublicKey = new File(path);
        FileInputStream fis = new FileInputStream(path);
        byte[] encodedPublicKey = new byte[(int)filePublicKey.length()];
        fis.read(encodedPublicKey);
        fis.close();
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(encodedPublicKey);
        PublicKey publicKey = keyFactory.generatePublic(publicKeySpec);
        return publicKey;
    }

    public static String keyToBase64String(Key key) {
        byte[] encodedBytes = Base64.encodeBase64((byte[])key.getEncoded());
        return new String(encodedBytes);
    }

    public static PublicKey publicKeyFromBase64String(String key, String algorithm) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] encodedKey = Base64.decodeBase64((String)key);
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(encodedKey);
        PublicKey publicKey = keyFactory.generatePublic(publicKeySpec);
        return publicKey;
    }

    public static PrivateKey privateKeyFromBase64String(String key, String algorithm) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] encodedPrivateKey = Base64.decodeBase64((String)key);
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(encodedPrivateKey);
        PrivateKey privateKey = keyFactory.generatePrivate(privateKeySpec);
        return privateKey;
    }

    public static KeyPair genereateKeyPair(String keyAlgorithm, int numBits) throws NoSuchAlgorithmException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance(keyAlgorithm);
        keyGen.initialize(numBits);
        KeyPair keyPair = keyGen.genKeyPair();
        return keyPair;
    }

    public static String PKCS10ToBase64String(PKCS10 csr) {
        byte[] encodedBytes = Base64.encodeBase64((byte[])csr.getEncoded());
        return new String(encodedBytes);
    }

    public static PKCS10 PKCS10FromBas64(String pkcs10String) throws SignatureException, NoSuchAlgorithmException, IOException {
        byte[] encoded = Base64.decodeBase64((String)pkcs10String);
        PKCS10 pkcs10 = new PKCS10(encoded);
        return pkcs10;
    }

    public static String X509CertToBase64String(X509Certificate cert) throws CertificateEncodingException {
        byte[] encodedBytes = Base64.encodeBase64((byte[])cert.getEncoded());
        return new String(encodedBytes);
    }

    public static X509Certificate X509CertFromBas64(String certString) throws SignatureException, NoSuchAlgorithmException, IOException, CertificateException {
        byte[] encoded = Base64.decodeBase64((String)certString);
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream in = new ByteArrayInputStream(encoded);
        X509Certificate cert = (X509Certificate)certFactory.generateCertificate(in);
        return cert;
    }

    public static void main(String[] args) throws KeyManagementException, NoSuchAlgorithmException {
        TlsHelper.init("c:/temp/jks.jks", "123456");
        TlsHelper.setProxy("http://127.0.0.1:8080", null, null);
        Client client = TlsHelper.getTlsClientWithProxy();
        Response responseEntity = client.target("https://mail.ru").request().get();
        String resp = (String)responseEntity.readEntity(String.class);
        System.out.println(resp);
    }
}

