/*
 * Decompiled with CFR 0.152.
 */
package com.ksoft.utils;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.File;
import java.time.Instant;
import java.util.Date;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.log4j.Logger;

public class Email {
    static Logger logger = Logger.getLogger((String)Email.class.getName());
    public static LoadingCache<String, Long> supression = CacheBuilder.newBuilder().concurrencyLevel(4).maximumSize(10000L).expireAfterWrite(1L, TimeUnit.DAYS).build((CacheLoader)new CacheLoader<String, Long>(){

        public Long load(String key) throws Exception {
            return -1L;
        }
    });

    public static boolean send(Properties sessionProperties, Authenticator passwordAuthenticator, String to, String cc, String bcc, String subject, String body, File attachment) {
        boolean result = false;
        Session session = Session.getInstance((Properties)sessionProperties, (Authenticator)passwordAuthenticator);
        MimeMessage msg = new MimeMessage(session);
        try {
            msg.setFrom();
            if (to != null && !to.isEmpty()) {
                msg.setRecipients(Message.RecipientType.TO, to);
            }
            if (cc != null && !cc.isEmpty()) {
                msg.setRecipients(Message.RecipientType.CC, cc);
            }
            if (bcc != null && !bcc.isEmpty()) {
                msg.setRecipients(Message.RecipientType.BCC, bcc);
            }
            msg.setSubject(subject);
            msg.setSentDate(new Date());
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setText(body, "UTF-8", "html");
            MimeMultipart multipart = new MimeMultipart();
            multipart.addBodyPart((BodyPart)messageBodyPart);
            if (attachment != null) {
                messageBodyPart = new MimeBodyPart();
                FileDataSource source = new FileDataSource(attachment);
                messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
                messageBodyPart.setFileName(attachment.getName());
                multipart.addBodyPart((BodyPart)messageBodyPart);
            }
            msg.setContent((Multipart)multipart);
            if (sessionProperties.containsKey("supress.key") && sessionProperties.containsKey("supress.period")) {
                String supressionKey = sessionProperties.getProperty("supress.key");
                Integer supress_seconds = (Integer)sessionProperties.get("supress.period");
                long now = Instant.now().getEpochSecond();
                Long pre = (Long)supression.getIfPresent((Object)supressionKey);
                if (pre == null) {
                    supression.put((Object)supressionKey, (Object)now);
                    Transport.send((Message)msg);
                    logger.debug((Object)("Email sent to (first, next will be supressed for " + supress_seconds + " seconds by key " + supressionKey + ") " + to));
                } else if (now - pre > (long)supress_seconds.intValue()) {
                    Transport.send((Message)msg);
                    logger.debug((Object)("Email sent to (supression elapsed) " + to));
                    supression.put((Object)supressionKey, (Object)now);
                } else {
                    logger.warn((Object)("Supression (" + supress_seconds + "s) for key " + supressionKey + " activated. Skip sending during" + (now - pre) + " seconds"));
                }
            } else {
                Transport.send((Message)msg);
                logger.debug((Object)("Email sent to (no supression) " + to));
            }
            result = true;
        }
        catch (Exception e) {
            logger.error((Object)"Send email error", (Throwable)e);
        }
        return result;
    }

    public static boolean send(Properties sessionProperties, Authenticator passwordAuthenticator, String to, String subject, String body) {
        return Email.send(sessionProperties, passwordAuthenticator, to, null, null, subject, body, null);
    }

    public static boolean send(Properties sessionProperties, String to, String subject, String body) {
        PasswordAuthenticator passwordAuthenticator = null;
        if (sessionProperties.containsKey("login") && sessionProperties.containsKey("password")) {
            passwordAuthenticator = new PasswordAuthenticator(sessionProperties.getProperty("login"), sessionProperties.getProperty("password"));
        }
        return Email.send(sessionProperties, passwordAuthenticator, to, null, null, subject, body, null);
    }

    public static class PasswordAuthenticator
    extends Authenticator {
        private final PasswordAuthentication passwordAuthentication;

        public PasswordAuthenticator(String userName, String password) {
            this.passwordAuthentication = new PasswordAuthentication(userName, password);
        }

        public PasswordAuthentication getPasswordAuthentication() {
            return this.passwordAuthentication;
        }
    }
}

