var app = angular.module('ui', [
	'authService',
	'ngRoute',
  'ngResource',
  'ngCookies',
  'restangular',
  'ui.bootstrap',
  'angularModalService',
  'angularFileUpload',
  'settingService',
  'ui.bootstrap.contextMenu',
'ui.select', 'ui.sortable','ngSanitize','mysetting',
'ui-notification',
'fx.datetime',
'treeControl',
'mygrid','mymodal','myHttpInterceptor','sessionProvider'
])
.constant('myRoutes',{
  "/login": {
          templateUrl: 'app/pages/login/login.html',
          reloadOnSearch:false,
          requireLogin: false
        },
  "/logs": {
          templateUrl: 'app/pages/logs/logs.html',
          requireLogin: true
        },      
  "/admin":{
          templateUrl: 'app/pages/admin/admin.html',
          reloadOnSearch:false,
          requireLogin: true
        },      
  /*"/laps":{
          templateUrl: 'app/pages/laps/laps.html',
          requireLogin: true,
          requireRole: 'LAPSUSER'    
        },*/
   "/secrets":{
          templateUrl: 'app/pages/secrets/secrets.html',
          requireLogin: true,
          requireRole: 'LAPSUSER'    
        },        
  "/jita":{
          templateUrl: 'app/pages/jita/jita.html',
          requireLogin: true,
          requireRole: 'JIAUSER'    
        },
  "/pc":{
          templateUrl: 'app/pages/pc/pc.html',
          requireLogin: true,
          requireRole: 'LAPSUSER'    
        },
  "/profile":{
          templateUrl: 'app/pages/profile/profile.html',
          requireLogin: true          
        }
  /*"/password":{
        templateUrl: 'app/pages/password/password.html',
        controller: 'PasswordController',
        requireLogin: false    
  }*/


})
.config(function ($locationProvider, $routeProvider,RestangularProvider,$httpProvider,NotificationProvider,myRoutes) {	
  $locationProvider.html5Mode(true);  
  $locationProvider.hashPrefix('!');
  RestangularProvider.setBaseUrl("/api");
  //RestangularProvider.setDefaultHeaders({'Content-Type': 'application/json; charset=UTF-8'});  
  $httpProvider.defaults.headers.delete = { 'Content-Type' : 'application/json' };
  $httpProvider.interceptors.push('myInterceptor');
  for(var path in myRoutes) {
      $routeProvider.when(path, myRoutes[path]);
  }  
  $routeProvider.otherwise({redirectTo: '/login'});    
      NotificationProvider.setOptions({
            delay: 5000,
            startTop: 20,
            startRight: 10,
            verticalSpacing: 10,
            horizontalSpacing: 20,
            positionX: 'right',
            positionY: 'top'
        });
}).run(function($http,SessionProvider,$rootScope,myRoutes){
  /*var header={};
  header[SessionProvider.headerName]=SessionProvider.token; */
  //$http.defaults.headers.common[SessionProvider.headerName] = SessionProvider.token;  
  $rootScope.$on("$locationChangeStart", function(event, next, current) {
    for(var i in myRoutes) {
        if(next.indexOf(i) != -1) {
            if(myRoutes[i].requireLogin && !SessionProvider.isAuthorized()) {
                console.log("You need to be authenticated to access this page!");
                event.preventDefault();
            }
            if(myRoutes[i].hasOwnProperty('requireRole')) {
                if (!SessionProvider.hasRole(myRoutes[i].requireRole)){
                    console.log("You has no rights to view this page");
                    event.preventDefault();
                }
            }
        }
    }
  });

});
app.constant('honeyVersion',"0.1");
app.controller("mainController", ['$scope','SessionProvider','Restangular', function ($scope,SessionProvider,Restangular) {
    let ctrl = this;
    ctrl.SessionProvider=SessionProvider;        
}]);
// Enter key press
app.directive(  'onEnterKey', function onEnterKeyDirective() {
    return function ( scope, element, attrs ) {
        element.bind( "keydown keypress", function ( e ) {
            if ( e.which === 13 ) {
                e.preventDefault();

                scope.$apply( function () {
                    scope.$eval( attrs.onEnterKey );
                } );
            }
        } );
    };
}  );

function clearCookies(){
   var cookies = document.cookie.split(";");
   for (var i = 0; i < cookies.length; i++){   
      var vals =  cookies[i].split("=");
      console.log(vals[0]);
      document.cookie = vals[0] + "=;expires=Thu, 21 Sep 1979 00:00:01 UTC;";                                
   }        
}
$(window).on('beforeunload', function () {  
   clearCookies();

});
if (!String.prototype.startsWith) {
  String.prototype.startsWith = function(searchString, position) {
    position = position || 0;
    return this.indexOf(searchString, position) === position;
  };
}