angular.module('mywidget', [])
.controller('WidgetController', function($scope,$http,$window,$timeout,ModalService,filterService,Restangular,filterService,StatusService,ProcessorService,Notification){
	
	//used by chart do not know what is it
	$scope.selectedindex=-1;
	$scope.processors = ProcessorService.processors;	
	$scope.filterService = filterService;
	filterService.loadFieldList('dash');
	$scope.colors=flx.colors;
	$scope.spin = true;
	$scope.config={};
	//processors data
	$scope.procstatus={};
	$scope.loadSettings=function(){
		
	};
	$scope.getData = function(){
		$scope.spin = true;
		$scope.error=null;
		switch ($scope.widget.source){
			case "elastic":
				let data = {sql:$scope.widget.param};
				if ($scope.hasOwnProperty('from') && $scope.hasOwnProperty('to')){
					data.from = $scope.from.valueOf();
					data.to = $scope.to.valueOf();
				}
				$http.post("/api/elastic/sql?format=json",data).
					then(function(response) { 						
						$scope.spin = false;
						$scope.drawData(response.data);
						
					/*_.forEach(data, function(o) {
						$scope.settings[o.key] = o.value;
					});*/
				},function(response){
					$scope.spin = false;
					$scope.error="Error";
					console.log(response);
				});
				break;
			case "vm":
				break;
			case "system":
				$scope.html = $scope.widget.param;

				break;
		}
	};
	$scope.drawData = function(data){
		$scope.tableHeader = data.headers;
		switch ($scope.widget.type){
			case "bar":
				$scope.data = $scope.convertForChart(data);									
				$scope.$broadcast('render', $scope.data);
				break;
			case "table":				
				$scope.data = data.lines;
				break;


		}
	};
	$scope.convertForChart=function(input){
	    var data=[];
	    var lines = input.lines;
	    $scope.termscolor={};
	    var i=0;
	    _.forEach(lines, function(element) {      
	      d=[element[0],parseInt(element[1])];
	      data.push(d);      
	      $scope.termscolor[element.key]=flx.colors[i];
	      i=i+1;
	    });
	    
	    //console.log(data);
	    return data;
	};

	/*$scope.save = function(){		
		$http.post('/api/dashboard/'+$scope.id,data).
		then(function(response) {                
                var data = response.data;
                Notification.error("S");
                }, function(response) {
                	Notification.error("Unable to save");
               		console.log(response);
        });
	};*/
	$scope.filter = function(field, value,where){
		if ($scope.widget.source==='elastic'){
			filterService.init();
			filterService.addRawQuery($scope.widget.param);
			filterService.setDate($scope.from.valueOf(),$scope.to.valueOf());
			/*data.from = $scope.from.valueOf();
			data.to = $scope.to.valueOf();*/
			/*if (value.includes(" ") || value.includes(":"))
	    		value='"'+value+'"';*/
			filterService.addQuery("=",field,value);
			var query = filterService.buldJsonLocation(true,false);
	    	var json = JSON.parse(query);	    		    	
	    	$window.open(where+'?'+JSON.stringify(json));
			
		}
		
	};
	
	$scope.configure=function(){
		ModalService.showModal({
			templateUrl: "app/directives/dashboard/settingsModal.html",
			controller: "WidgetSettingsController",			
			inputs: {				
				data:{	
					input: $scope.widget,//input
					caption: $scope.widget.caption+ " configuration",
					okButton: "Save"
				}
				
			}

		}).then(function(modal) {
			modal.element.modal({backdrop: 'static', keyboard: false});
			modal.close.then(function(result) {								
				if (typeof result.value !== 'undefined') {
					_.assign($scope.widget,result.value);
					let data = Restangular.stripRestangular(result.value);
					$http.put("/api/dashboard/widgets/"+$scope.widget.id,data);
					$scope.getData();
					//$scope.widget.settings = result.value;
					/*
						process results here
					*/
				}
			});
		});
	};

	$scope.$on('size-changed', function(event,id) {
		if (id==$scope.widget.id){
			event.preventDefault();
			$scope.$broadcast('render', $scope.data);
		}
	});
	$scope.$on('tick',function(event,data){
		//$scope.$apply();
		if ($scope.spin==false){
			$timeout(function() {
	    		$scope.refresh();
			}, 0);
		}		
	});
	$scope.$on('procstatus', function(event,data) {
		let uuid = data.uuid;
		$scope.procstatus[uuid] = data;		
	});    
	$scope.fieldOptions = [
	    ['<i class="fa fa-sitemap"></i> View Aggregated', function ($itemScope) {
	    	let f_value = $itemScope.item[0];
	    	let field = $scope.tableHeader[0];
	    	if (f_value.includes(" ") || f_value.includes(":"))
	    		f_value='"'+f_value+'"';	    	
	    	$scope.filter(field,f_value,"grouped");
	    	
	    }],	    
	    ['<i class="fa fa-table"></i> View Details', function ($itemScope) {
	    	let f_value = $itemScope.item[0];
	    	let field = $scope.tableHeader[0];
	    	if (f_value.includes(" ") || f_value.includes(":"))
	    		f_value='"'+f_value+'"';
	    	$scope.filter(field,f_value,"details");
	        //$scope.selected = $itemScope.item.name;
	    }]
	       
	];
	$scope.refresh = function(){
		$scope.getData();
	};

	/*$scope.$watch('widget', function (newValue, oldValue, scope) {    
      $scope.$broadcast('render', $scope.data);
  	},true);*/

	$scope.loadSettings();
	$scope.getData();
	
	
})
.directive('myWidget', function() {
  return {
  	restrict: 'E',
    templateUrl:'app/directives/dashboard/dash.html',
    //transclude: true,
	scope: {		
		id:'@',
		type:'@',		
		widget: '=',
		from:"=",//moment from
		to:"=",//moment to
		remove: '&onClose'
	},

	
	
  };
})
.directive('dynamic', function ($compile) {
  return {
    restrict: 'A',
    replace: true,
    link: function (scope, ele, attrs) {
      scope.$watch(attrs.dynamic, function(html) {
        ele.html(html);
        $compile(ele.contents())(scope);
      });
    }
  };
})
.controller('WidgetSettingsController', function($scope, $element,data,close) {
	$scope.data=data;	
	$scope.result = _.clone(data.input);
	$scope.close = function() {
		$element.modal('hide');
		$('body').removeClass('modal-open');
		$('.modal-backdrop').remove();
		close({
			value: $scope.result    		
		}); 		
		
	};
	$scope.cancel = function() {
		$element.modal('hide');
		$('body').removeClass('modal-open');
		$('.modal-backdrop').remove();		
		close({});
	};

});
;