angular.module('mygrid', [])
.controller('mygridController', function($scope,$http,Restangular,ModalService,Notification,FileUploader){
	//$scope.allItems = Restangular.all($scope.getAllUrl).getList().$object;	
	$scope.allItems=[];
	$scope.allSelected=false;
	$scope.filteredItems=[];
	$scope.isLoading = false;
	$scope.headers = JSON.parse($scope.headersConfig);

	if (typeof($scope.showEdit)==='undefined'){
		$scope.showEdit=true;
	}
	if (typeof($scope.showNew)==='undefined'){
		$scope.showNew=true;
	}
	if (typeof($scope.showRemove)==='undefined'){
		$scope.showRemove=true;
	}
	if (typeof($scope.showImport)==='undefined'){
		$scope.showImport=false;
	}
	$scope.currentPage = 1; 	
	if (typeof($scope.pageSize)==='undefined'){
		$scope.pageSize = 30;
	}

	if (typeof($scope.showPager)==='undefined'){
		$scope.showPager=false;
		//$scope.pageSize = $scope.allItems.length;
	}
	if (typeof($scope.templateUrl)==='undefined'){
		$scope.templateUrl="/web/app/directives/mygrid/gridModal.html";
	}
	if (typeof($scope.importTemplateUrl)==='undefined'){
		$scope.importTemplateUrl="/web/app/directives/mygrid/importModal.html";
	}
	if (typeof($scope.modalFields)!=='undefined'){
		$scope.modalFields = JSON.parse($scope.modalFields);		
		$scope.modalFields.forEach(function(item, i, arr) {
			if (item.hasOwnProperty('options') && item.options.constructor === Object){			
				if (item.options.hasOwnProperty("url")){
					$http.get(item.options.url).then(function(response){
						item.options = response.data;
						if (!item.options.hasOwnProperty("name"))
							item.options["name"]="name";
						if (!item.options.hasOwnProperty("id"))
							item.options["id"]="id";
					});
				}else{
					item.options = _.get($scope.extraDataModal,item.options);
				}
			 
			}
		});

	}
	
	$scope.refresh = function(){
		//$scope.allItems = Restangular.all($scope.getAllUrl).getList().$object;	
		$scope.isLoading = true;
		Restangular.all($scope.getAllUrl).getList().then(function(response){
			$scope.isLoading = false;
			$scope.allItems = response;
			if ($scope.showPager==false){
				$scope.pageSize = $scope.allItems.length;
			}
		},function(response){
			$scope.isLoading = false;
			Notification.error("Unable to fetch items");
		});	
		
	};
	$scope.refresh();
	$scope.formatValue = function(key,values){
		let out = "";
		if (values.hasOwnProperty(key)){
			out = values[key];
		}else{
			out = key;
		}
		if (_.includes($scope.formatFields,key)){
			let temp = $scope.formatter()(key,values);
			if (temp!="")
				out = temp;
		}
		return out;
	};
	$scope.toggleSelection=function(row){
		if (row['$selected']===undefined){
		  	row.$selected = false;		  	
		}
      	row.$selected = row.$selected ? false : true;      	
	};
	$scope.toggleSelectAll = function(items){
		$scope.allSelected=!$scope.allSelected;
		for (i in $scope.filteredItems){
			$scope.filteredItems[i].$selected = $scope.allSelected;
		}	
	};
	$scope.del=function(item){
		if (confirm("Do you want to remove element?")){    	
			item.remove().then(function(response){
				$scope.allItems = _.without($scope.allItems, item);
				Notification.success('Element deleted');	
			},function(response){
				Notification.error('Unable to delete element');	
			});    		
			
    	}
	};
	$scope.removeSelected=function(){
		let selected=[];
		for (i in $scope.filteredItems){
			if ($scope.filteredItems[i].$selected==true){
				selected.push($scope.filteredItems[i].id);
			}
		}
		if (selected.length>0){
			if (confirm("Do you want to remove selected elements?")){    	
			$http.delete("/api/"+$scope.getAllUrl+"/"+selected.join()).then(function(response) {                	    						
					Notification.success("Elements deleted");						
					$scope.refresh();
					$scope.allSelected=false;		
					},function(response) {
						Notification.error("Unable to delete elements");	
		               console.log(response);
		        });				
			}
		}
	};
	$scope.add=function(){
		let element={};
		if (typeof($scope.buildNewElement)!=='undefined'){
			try{			
				element = $scope.buildNewElement()();
			}catch(e){
			
			}
		}		
		$scope.showModal("add",element);
		//$scope.showModal("edit",result);
	};
	$scope.import = function(){
		let element={};
		element.uploadType = $scope.importType;
		$scope.showModal("import",element);
	};

	$scope.toggle=function(item){			
		let data = Restangular.stripRestangular(item);
		data.enabled=!data.enabled;
		$http.post("/api/"+$scope.getAllUrl+"/toggle/"+item.id,data).then(function(response){
		//$http.put("/api/"+$scope.getAllUrl,data).then(function(response){
			item.enabled=data.enabled;
			let whatHappened="disabled";
			item.enabled===true?whatHappened="enabled":whatHappened="disabled";							
			Notification.success("Element "+whatHappened);	
			//$scope.allItems = Restangular.all($scope.getAllUrl).getList().$object;
		},function(response){
			Notification.error("Unable to update element");	
		});
	};
	$scope.edit=function(item){
		//let element = item;
		let id="id";
		let showItem={};
		if (typeof($scope.lazyLoad)!=='undefined'){			
			if (typeof($scope.lazyId)!=='undefined')
				id = $scope.lazyId;

			if ($scope.lazyLoad==="true" && item.hasOwnProperty(id)){
				Restangular.one($scope.getAllUrl,item[id]).get().then(function(_item){
					let element = _item;
					if (typeof($scope.preprocessModal)!=='undefined'){
						try{
							element = $scope.preprocessModal()(_item);
						}catch(e){
							console.log(e);
						}
					}
					$scope.showModal("edit",element);
				});
			}else{
				console.error("element has no such id property:"+id)
			}

		}else{
			let element = item;
			if (typeof($scope.preprocessModal)!=='undefined'){
				try{
					element = $scope.preprocessModal()(item);
				}catch(e){
					console.error(e);
				}
			}
			$scope.showModal("edit",element);
		}
		

	};
	
//pagination
	/*$scope.setCurrentPage = function(currentPage) {
	    $scope.currentPage = currentPage;
	};

	$scope.getNumberAsArray = function (num) {
	    return new Array(num);
	};

	$scope.numberOfPages = function() {
	    return Math.ceil($scope.allItems.length/ $scope.pageSize);
	};*/

	$scope.showModal = function(modaltype,item){
		var inputData=item;
		var caption="";
    	var okButton="";
    	let extra={};
    	let templateUrl = $scope.templateUrl;
    	switch(modaltype){
    		case "add":    		
    			caption="Add new";
    			okButton="Add";
				break;
			case "edit":
				// inputData = item;
				caption="Edit";				
    			okButton="Save";
				break;
			case "import":
				// inputData = item;
				caption="Import";				
    			okButton="Import";
    			templateUrl = $scope.importTemplateUrl;
				break;
		}
		/*if (typeof($scope.getExtraDataModal)!=='undefined'){
			try{
				extra = $scope.getExtraDataModal()();			
			}catch(err){}

		}*/
		ModalService.showModal({
			templateUrl: templateUrl,//$scope.templateUrl,//"/web/app/pages/admin/fields/fieldsModal.html",
			controller: "modalGridController",	
			controllerAs:"ctrl",
			inputs: {				
				data:{	
					item: inputData,//input
					caption: caption,
					okButton: okButton,
					modaltype: modaltype,
					extra:$scope.extraDataModal,					
					modalFields:$scope.modalFields,					
				}
				
			}

		}).then(function(modal) {
			modal.element.modal({backdrop: 'static', keyboard: false});
			modal.close.then(function(result) {
				if (typeof result.value !== 'undefined') {
					let data={};
	    			switch(modaltype){
	    				case "add":	    				
	    					data = result.value;//.plain();
	    					$http.put("/api/"+$scope.getAllUrl,data).then(function(response) {                	    						
	    						Notification.success("New element added");	
	    						//$scope.allItems = Restangular.all($scope.getAllUrl).getList().$object;
	    						$scope.refresh();
	    						},function(response) {
	    							Notification.error("Unable to add element");	
					               console.log(response);
					        });
    						break;
	    				case "edit":
	    					let updatedItem = Restangular.stripRestangular(result.value);
	    					//field.save();
	    					$http.put("/api/"+$scope.getAllUrl,updatedItem).then(function(response){
	    						Notification.success("Element updated");	
	    						//$scope.allItems = Restangular.all($scope.getAllUrl).getList().$object;
	    						$scope.refresh();
	    					},function(response){
	    						Notification.error("Unable to update element");	
	    					});
    						break;
    					case "import":
    						if (result.value.count>0)
    							$scope.refresh();
    						break;

	    			}

				}
			});
		});
	};
})
.controller('modalGridController', function($scope,$http, $element,$cookies,data,close,FileUploader,Notification) {	
	let ctrl=this;
	let header={};
	header['X-XSRF-TOKEN'] = $cookies.get('XSRF-TOKEN');
	$scope.uploader = new FileUploader({
            url: '/api/file/upload/'+data.item.uploadType,
            autoUpload: true,
            headers:header
            
    });
    $scope.uploader.onAfterAddingFile = function(fileItem) {
    	ctrl.fileSelected = fileItem.file.name;    	
		ctrl.isUploading=true;    	
    };
    $scope.uploader.onCompleteAll = function() {    	
    	ctrl.isUploading=false;       	     
    };
    $scope.uploader.onSuccessItem = function(item, response, status, headers) {    	
    	Notification.success("Imported "+response.count +" items");
    	$scope.result.count = response.count;
    	$element.modal('hide');
		$('body').removeClass('modal-open');
		$('.modal-backdrop').remove();	
    	$scope.close();
    };
    $scope.uploader.onErrorItem = function(item, response, status, headers) {    	
    	Notification.error("Unable to upload file");
    };

	$scope.data=data;
	$scope.result = _.clone(data.item);
	$scope.close = function() {
		close({
			value: $scope.result    		
		}); 
	};
	$scope.cancel = function() {
		$element.modal('hide');
		$('body').removeClass('modal-open');
		$('.modal-backdrop').remove();		
		close({});
	};
	$scope.getModel=function(field){
		if (field.indexOf(".")>-1){
			let arr= field.split('.');
			return $scope.result[arr[0]][arr[1]];
		}else{
			return $scope.result[field];
		}

	};
	$scope.assignDefault=function(result,field,defaultValue){		

		if (_.get(result, field, null)===null ||_.get(result, field, null)==="")
			_.set(result,field,defaultValue);					
	};
	$scope.showField=function(result,field,showif){
		let show=false;		
		if (typeof(showif)==='undefined')
			return true;
		let temp=(_.get(result,showif.path)==showif.value);
		switch (showif.op){
			case "=":
				show = temp;
				break;
			case "!=":
				show = !temp;
				break;
			default:
				show = temp;
		}
		let newone={};
		if (!show)
			_.unset(result,field);
		return show;
	};
	$scope.searchComplete = function(url,val,property){
		return $http.get(url+val).then(function(response){
	      return response.data.map(function(item){
	        return item[property];
	      });
	    });
	};



})
.filter('startFrom', function() {
    return function(input, start) {         
        return input.slice(start);
		};
})
.directive('myGrid', function() {
  return {
  	restrict: 'E',
    templateUrl:'app/directives/mygrid/mygrid.html',
	scope: {		
		headersConfig:"@headers",
		getAllUrl:"@",
		formatFields:"@",
		templateUrl:"@",
		lazyLoad:"@", //optional load data only when edit element clicked
		lazyId:"@", //optional name of id of element to load
		showEdit:"=", //optional name of id of element to load
		caption:"@",
		itemFilter:"@",//filter of table
		formatter:"&",	//optional ext func to format  data in table
		preprocessModal:"&", //
		buildNewElement:"&",	//optional ext function called when creatin new element (add new)
		//getExtraDataModal:"&" //load extradate which will be used in modal like references
		extraDataModal:"=",//extradata for modal dialog (like references)
		showNew:"=", //show or hide add new button
		showRemove:"=", //show or hide add remove button
		showPager:"=", //show page buttons
		pageSize:"=",
		modalFields:"@", //modal feeds configuration
		showImport:"=",
		importType:"@"
	}
	
	
  };
});;