angular.module('mymodal', [])
.controller('myModalController', function($scope,$http,ModalService,Notification){
	let ctrl = this;
	$scope.okSpin = false;
	//$scope.allItems = Restangular.all($scope.getAllUrl).getList().$object;		
	if (typeof($scope.okButtonText)==='undefined'){
		$scope.okButtonText="OK";
	}	
	if (typeof($scope.cancelButtonText)==='undefined'){
		$scope.cancelButtonText="Cancel";
	}	
	
	if (typeof($scope.templateUrl)==='undefined'){
		$scope.templateUrl="/web/app/directives/mymodal/mymodal.html";
	}
	if (typeof($scope.result)==='undefined'){
		$scope.result={};
	}
	if (typeof($scope.modalFields)!=='undefined'){
		$scope.myModalFields = JSON.parse($scope.modalFields);		
		$scope.myModalFields.forEach(function(item, i, arr) {
			if (item.hasOwnProperty('options') && item.options.constructor === Object){			
				if (item.options.hasOwnProperty("url")){
					$http.get(item.options.url).then(function(response){
						item.options = response.data;
						if (!item.options.hasOwnProperty("name"))
							item.options["name"]="name";
						if (!item.options.hasOwnProperty("id"))
							item.options["id"]="id";
					});
				}else{
					item.options = _.get($scope.extraDataModal,item.options);
				}
			 
			}
		});

	}
	
	

	$scope.assignDefault=function(result,field,defaultValue){		
		if (_.get(result, field, null)===null ||_.get(result, field, null)==="")
			_.set(result,field,defaultValue);					
	};
	$scope.showField=function(result,field,showif){
		let show=false;		
		if (typeof(showif)==='undefined')
			return true;
		let temp=(_.get(result,showif.path)==showif.value);
		switch (showif.op){
			case "=":
				show = temp;
				break;
			case "!=":
				show = !temp;
				break;
			default:
				show = temp;
		}
		let newone={};
		if (!show)
			_.unset(result,field);
		return show;
	};
	$scope.searchComplete = function(url,val,property){
		return $http.get(url+val).then(function(response){
	      return response.data.map(function(item){
	        return item[property];
	      });
	    });
	};
	$scope.ok = function() {
		$scope.result['$ok']=true;
		$scope.okSpin = true;
		if (typeof($scope.postUrl)!=='undefined'){
			try{
				let req = $scope.result;
				$http.post($scope.postUrl,req).then(function(response){										
					if (typeof($scope.onOk)!=='undefined'){
						try{
							$scope.onOk({});							
						}catch(e){
							console.error(e);
						}
					}
					$scope.okSpin = false;	     			
					$scope.visible = false;
	     		},function(response){
	     			$scope.okSpin = false;
	     			let data = response.data;
	     			let msg = data.hasOwnProperty('error')?data.error:"";					
	     			Notification.error("Error "+msg);
	     		});
			}catch(e){
				$scope.okSpin = false;	     			
				$scope.visible = false;
				console.error(e);
			}
		}else{
			if (typeof($scope.onOk)!=='undefined'){
				try{
					$scope.onOk({});							
				}catch(e){
					console.error(e);
				}
			}
			$scope.okSpin = false;	     			
			$scope.visible = false;
		}
		/*close({
			value: $scope.result    		
		}); */
	};
	$scope.cancel = function() {
		$scope.visible = false;
		$scope.result['$ok']=false;
		//$element.modal('hide');
		//$('body').removeClass('modal-open');
		//$('.modal-backdrop').remove();		
		//close({});
	};
	
	
})
.directive('myModal', function() {
  return {
  	controller: 'myModalController',
  	restrict: 'E',
    templateUrl:'app/directives/mymodal/mymodal.html',
    transclude: true, // we want to insert custom content inside the directive
    replace: true, // Replace with the template below
	scope: {		
		title:"@",
		okButtonText:"@",
		cancelButtonText:"@",
	//	templateUrl:"@",
		modalFields:"@", //modal feeds configuration
		data:"=",
		visible:"=",
		result:"=",
		postUrl:'@',
		onShown:'&', onHide:'&', onOk:'&'
		
		//getExtraDataModal:"&" //load extradate which will be used in modal like references		
	},
	link:function postLink(scope, element, attrs){
                
        $(element).modal({
            show: false, 
            keyboard: attrs.keyboard, 
            backdrop: attrs.backdrop
        });
        
        scope.$watch(function(){return scope.visible;}, function(value){
            
            if(value == true){
                $(element).modal('show');
            }else{
                $(element).modal('hide');
            }
        });

        scope.$watch(function(){return scope.data;}, function(value){            
            scope.result = _.clone(scope.data);
        });
        /*scope.$watch(function(){return scope.postUrl;}, function(value){            
            //scope.result = _.clone(scope.data);
        });*/
        
        $(element).on('shown.bs.modal', function(){
          //scope.$apply(function(){
          	scope.visible = true;
            //scope.$parent[attrs.visible] = true;
          //});
        });
        
        $(element).on('shown.bs.modal', function(){
          //scope.$apply(function(){
          	if (typeof(scope.onShown)!=='undefined'){
				try{
					scope.onShown({});
				}catch(e){
					console.error(e);
				}
			}
          //});
        });

        /*$(element).on('hidden.bs.modal', function(){
          //scope.$apply(function(){
          	scope.visible = false;
            scope.$parent[attrs.visible] = false;
          //});
        });
*/        
        $(element).on('hidden.bs.modal', function(){
          //scope.$apply(function(){
          	if (typeof(scope.onHide)!=='undefined'){
				try{
					scope.onHide({});
					scope.visible = false;
				}catch(e){
					console.error(e);
				}
			}
          //});
        });
    }
	
  };
});