angular.module('mysetting', [])
.controller('settingController', function($scope,$http,Restangular,Notification){
	//$scope.SettingService = SettingService;
	let ctrl = this;
	ctrl.spin = false;
	ctrl.checkSpin=false;
	var settings = this;
    settings.items = [];
	$scope.items = [];
	if (typeof($scope.settings)==='undefined'){
		$scope.settings={};	
	}
	if (typeof($scope.showCheckButton)==='undefined'){
		$scope.showCheckButton=false;
	}else{
		$scope.showCheckButton=true;
	}
			
	$scope.extra={};
	$scope.loadSettings=function(){
		ctrl.spin = true;
		$http.get('/api/setting/group/'+$scope.group).
		then(function(response) { 
			var data = response.data;
			settings.items = data;
			_.forEach(data, function(o) {
				switch(o.type){
					case "checkbox":
						$scope.settings[o.key] = o.value=="true"? true:false;
						break;
					case "select":
						$scope.settings[o.key] = o.value;						
						$scope.extra[o.key] = JSON.parse(o.extra);
						break;	
					case "number":
						$scope.settings[o.key] = parseInt(o.value);
						break;
					default:
						$scope.settings[o.key] = o.value;
						break;					
				}
				//$scope.target[o.key] = $scope.settings[o.key];

				
			});	
			ctrl.spin = false;		
			
		},function(response){
			Notification.error("Unable to load "+$scope.caption);
			ctrl.spin = false;
		});
		
	};
	$scope.save = function(){
		let data=[];
		_.forEach($scope.settings, function(value, key) {
			var t={};
			t.key = key;
			t.value = value;
			data.push(t);
		});
		$http.post("/api/setting",data).
		then(function(response) {                
                var data = response.data;                
				Notification.success($scope.caption+ ' saved');								
                }, function(response) {
               Notification.error('Unable to save '+$scope.caption);	
               console.log(response.data);
        });
	};
	$scope.check = function(){
		let data=[];
		ctrl.checkSpin=true;
		_.forEach($scope.settings, function(value, key) {
			var t={};
			t.key = key;
			t.value = value;
			data.push(t);
		});
		$http.post('/api/setting/check/'+$scope.group,data).then(function(response){
			ctrl.checkSpin=false;
			let data = response.data;
			if (data.hasOwnProperty('error')){
				Notification.error(data.error);
			}else if (data.hasOwnProperty('success')){
				Notification.success(data.success);
			}

		},function(response){
			ctrl.checkSpin=false;
			Notification.error("Error occured during checking")
		});


	};

	$scope.loadSettings();
	
	
})
.directive('mySetting', function() {
  return {
  	restrict: 'E',
    templateUrl:'app/directives/settings/settings.html',
	scope: {
		group:'@',
		caption:'@',
		/*target:'=',*/
		settings:'=',
		showCheckButton:"="
	}
	
	
  };
});