app.controller('ComputersController', function($scope,$http,$location,SessionProvider,Notification){	
	let ctrl = this;
	$scope.tabs=['container','computers','accessgroups','policies','rules','other'];
	$scope.selectedTab = $location.search()['tab'];	

	if (typeof $scope.selectedTab === 'undefined'){
		$scope.activeTab=0;		
		$scope.selectedTab = $scope.tabs[$scope.activeTab];
	
	}else {
		$scope.activeTab=$scope.tabs.indexOf($scope.selectedTab);		
		$scope.selectedTab = $scope.tabs[$scope.activeTab];
	}
	ctrl.allPcSelected=false;
	ctrl.filteredPcItems=[];
	ctrl.cuttedPcItems=null;
	ctrl.isComputerModalVisible = false;
	ctrl.computerModalOut = {};
	$scope.selectTab = function(tab){
    	$scope.selectedTab = tab;
		$location.search("tab",tab);
		switch (tab){
			case "container":
				if (ctrl.selectedNode!==null)
					$scope.getNodeDetails(ctrl.selectedNode.id);
				//$scope.getContainerDetails()
				break;
			case "computers":
				if (ctrl.selectedNode!==null)
						$scope.loadComputers(ctrl.selectedNode.id);
				break;
		}
    };
    $scope.treeOptions = {
	    nodeChildren: "children",
	    dirSelectable: true,
	    isLeaf: function(){return false}
	};
    $scope.treeData=[
    	{id:1, name:"All Computers",children:[]}
    ];
    $scope.expandedNodes=[];
    ctrl.selectedNode = null;
    ctrl.lastCuttedElement=null;
    ctrl.dummyId = 10;
   	$scope.doSelect = function(node,selected) { 
   		if (selected){
	   		ctrl.selectedNode = node;	   		
			ctrl.selectedNode.pcou = $scope.getPathById(node.id).join("/");        
	   		switch ($scope.selectedTab){
	   			case "computers":
		   			$scope.loadComputers(ctrl.selectedNode.id);
		   			break;
		   		case "container":
		   			$scope.getNodeDetails(ctrl.selectedNode.id);
		   			break;
	   		}
	   		
		}else{
			ctrl.selectedNode = null;
		}
   	};
    ctrl.lastRightClickNode = null;
   	$scope.doRightClick = function(node) { ctrl.lastRightClickNode = node; }
   	$scope.doRename  = function(){
   		let name =prompt('Enter new name','');
   		if (name!=='' && name!=null){
     		let req = {name:name, node_id:ctrl.lastRightClickNode.id};
     		$http.post("/api/computers/pctree/group/rename",req).then(function(response){
     			Notification.success("Group renamed");
     			
     			let newElement = {name: name};
     			$scope.recursiveAction("rename",$scope.treeData, ctrl.lastRightClickNode.id,newElement);  
     		},function(response){
     			Notification.error("Unable to rename computer group");
     		});
     	}
	};
   	$scope.doAdd  = function(){
   		let name =prompt('Name','');
   		if (name!=='' && name!=null){
     		let req = {name:name, node_id:ctrl.lastRightClickNode.id};

     		$http.post("/api/computers/pctree/group/add",req).then(function(response){
     			Notification.success("Group added");
     			let id = response.data.id;
     			let newElement = {name: name, id:id, children: []};
     			$scope.recursiveAction("add",$scope.treeData, ctrl.lastRightClickNode.id,newElement);  
     		},function(response){
     			Notification.error("Unable to add new computer group");
     		});
     		//do request on success
     		//ctrl.dummyId=ctrl.dummyId+1;
     		
     		/*$scope.recursiveAction("expand",$scope.expandedNodes,ctrl.lastRightClickNode.id);  */
     	}
   	};   	
   	$scope.doDelete  = function(){
   		if (confirm("Do you want to remove "+ctrl.lastRightClickNode.name+" ?")){    	
   			$http.delete("/api/computers/pctree/group/"+ctrl.lastRightClickNode.id).then(function(response){   				
   				Notification.success("Group deleted");
   				$scope.recursiveAction("del",$scope.treeData,ctrl.lastRightClickNode.id);  
   			},function(response){
   				Notification.error("Unable to delete group");
   			});
   			
   		}
   	};
   	$scope.doCut  = function(){
   		$scope.recursiveAction("cut",$scope.treeData,ctrl.lastRightClickNode.id).join(",")+",";  
   	};
   	$scope.doPaste  = function(){
   		if (ctrl.lastCuttedElement!==null){
   			let pastePath = $scope.recursiveAction("path",$scope.treeData,ctrl.lastRightClickNode.id,ctrl.lastCuttedElement)  
   			let pastePathStr = pastePath.join(",")+",";
   			let cutPath = ctrl.lastCuttedElement._path
   			let cutPathStr = cutPath.join(",")+",";
   			if (pastePathStr.startsWith(cutPathStr)){
   				//cut:1,11 paste:1,11,12 - forbidden
   				Notification.error("Forbidden to cut and paste: wrong levels");
   			}else{
   				let req={fromid:ctrl.lastCuttedElement.id, toid:ctrl.lastRightClickNode.id};
   				$http.post("/api/computers/pctree/group/paste",req).then(function(response){
	     			Notification.success("Group moved");
	     			$scope.recursiveAction("del",$scope.treeData,ctrl.lastCuttedElement.id);  
   					$scope.recursiveAction("paste",$scope.treeData,ctrl.lastRightClickNode.id,ctrl.lastCuttedElement);  
   					ctrl.lastCuttedElement = null;
	     		},function(response){
	     			ctrl.lastCuttedElement = null;
	     			Notification.error("Unable to add new computer group");
	     		});
   				
   			}
   		}   		
   	};
   	$scope.recursiveAction = function(action,items,id,element){
   		var result,
      	done = false,
      	path = [];
      	path.push([]);
      	recursiveAction = function(action,items,id,root,element){   		      		
	   		for (var i = items.length - 1; i >= 0; i--) {
	   			if (!done) {
		   			let item = items[i];
		   			if(item.id === id){   
		   				done = true;
		   				path[root].push(id);	
		   				result = path[root];			
		   				if (!item.hasOwnProperty("children"))
		         			item.children=[];
		         		switch (action){
		         		case "add":
		         			items[i].children.push(element);
		         			break;		         		
		         		case "paste":
		         			items[i].children.push(element);
		         			break;
		         		case "del":
		         			items.splice(i, 1);         			
		         			break;
		         		case "cut":
		         			ctrl.lastCuttedElement = item;
		         			ctrl.lastCuttedElement._path=result;
		         			break;     
		         		case "rename":
		         			items[i].name=element.name;
		         			break;    		

		         		}

		   			}
		   			if(angular.isArray(item.children) && item.children.length > 0 && !done){
		   				path[root].push(item.id);
		            	recursiveAction(action,item.children,id,root,element);              
		         	}
		        }		    
			}
			if (!done){
      			path[root].pop();
    		}
    		return;
		};
		recursiveAction(action,items,id,0,element);
		return result;

   	};
   	$scope.loadTree = function(){
   		$http.get("/api/computers/pctree").then(function(response){
   			$scope.treeData = response.data;
   		},function(response){
   			Notification.error("Unable to load computers tree");
   		});
   	};
   	$scope.getPathById = function(id){
   		var result,
      	done = false,
      	path = [];
      	path.push([]);
      	recursiveAction = function(items,id,root){   		      		
	   		for (var i = items.length - 1; i >= 0; i--) {
	   			if (!done) {
		   			let item = items[i];
		   			if(item.id === id){   
		   				done = true;
		   				path[root].push(item.name);	
		   				result = path[root];					   				
		   			}
		   			if(angular.isArray(item.children) && item.children.length > 0 && !done){
		   				path[root].push(item.name);
		            	recursiveAction(item.children,id,root);              
		         	}
		        }		    
			}
			if (!done){
      			path[root].pop();
    		}
    		return;
		};
		recursiveAction($scope.treeData,id,0);
		return result;
   	};
   	$scope.loadComputers=function(nodeId){
   		$http.get("/api/computers/pctree/computers/"+nodeId).then(function(response){
   			ctrl.computers = response.data;
   		},function(response){
   			Notification.error("Unable to get computers");
   		});

   	};
   	$scope.formatLibrary = function(key, item){   		
		let out = "";
		switch(key){
			case "config":
				let json = JSON.parse(item.config);
				out = json.type;				
				break;			
			case "modified":
				if (item.modified>0){
					out=$scope.formatDate(item.modified)
				}else
					out="-"
				break;				
			case "ip":
				let json2 = JSON.parse(item.config);
				out = json2.ip;				
				break;
			case "rule_value":
				let json3 = JSON.parse(item.config);
				out = json3.rule_value;				
				break;
			case "rule_type":
				let json4 = JSON.parse(item.config);
				out = json4.type;				
				break;			
			case "container":
				let json5 = JSON.parse(item.config);
				out = $scope.getPathById(json5.node_id).join("/")
				break;	
			case "pc_ou":
				let json6 = JSON.parse(item.config);
				out = json6.pcou;
				break;	

		}
		return out;
	};
	$scope.buildNewGroup = function(){
		let result = {};
		result["config"]={};			
		result.config.node_id=ctrl.selectedNode.id;
		result.config.pcou = $scope.getPathById(ctrl.selectedNode.id).join("/");
		return result;
	};
	$scope.preprocessConfig = function(item){
        //let config = JSON.parse(item.roles);
        item.config.pcou = $scope.getPathById(item.config.node_id).join("/");        
        return item;
	};
	$scope.formatDate=function(ts){
		return moment.unix(ts).format("YYYY-MM-DD HH:mm:ss");
	};
	$scope.togglePcSelection=function(row){
		if (row['$selected']===undefined){
		  	row.$selected = false;		  	
		}
      	row.$selected = row.$selected ? false : true;      	
	};
	$scope.togglePcSelectAll = function(items){
		ctrl.allPcSelected=!ctrl.allPcSelected;
		for (i in ctrl.filteredPcItems){
			ctrl.filteredPcItems[i].$selected = ctrl.allPcSelected;
		}	
	};
	$scope.removePcSelected=function(){
		let selected=[];
		for (i in ctrl.filteredPcItems){
			if (ctrl.filteredPcItems[i].$selected==true){
				selected.push(ctrl.filteredPcItems[i].id);
			}
		}
		if (selected.length>0){
			if (confirm("Do you want to remove selected computers?")){    	
			$http.delete("/api/computers/host/"+selected.join()).then(function(response) {                	    						
					Notification.success("Computers deleted");						
					$scope.loadComputers(ctrl.selectedNode.id);					
					ctrl.allPcSelected=false;							
					},function(response) {
						Notification.error("Unable to delete elements");	
		               console.log(response);
		        });				
			}
		}
	};
	$scope.cutSelected=function(){
		let selected=[];
		for (i in ctrl.filteredPcItems){
			if (ctrl.filteredPcItems[i].$selected==true){
				selected.push(ctrl.filteredPcItems[i].id);
			}
		}
		if (selected.length>0){
			ctrl.cuttedPcItems = selected;
			/*Notification.success()
			if (confirm("Do you want to remove selected computers?")){    	
			$http.delete("/api/computers/host/"+selected.join()).then(function(response) {                	    						
					Notification.success("Computers deleted");						
					$scope.loadComputers(ctrl.selectedNode.id);					
					ctrl.allPcSelected=false;		
					},function(response) {
						Notification.error("Unable to delete elements");	
		               console.log(response);
		        });				
			}*/
		}
	};
	$scope.pasteComputers = function(nodeId){

		if (ctrl.cuttedPcItems!==null && nodeId!==null &&ctrl.cuttedPcItems.length>0){			
			$http.put("/api/computers/moveto/"+nodeId+"/"+ctrl.cuttedPcItems.join()).then(function(response){
				Notification.success("Computers moved");
				//ctrl.selectedNode = ctrl.lastRightClickNode;	   			   		
		   		$scope.loadComputers(nodeId);
				ctrl.cuttedPcItems=null;
				ctrl.allPcSelected=false;		
			},function(response){
				ctrl.cuttedPcItems=null;
				ctrl.allPcSelected=false;		
			});
		}
		
	};
	$scope.getNodeDetails = function(nodeId){
		$http.get("/api/computers/pctree/group/details/"+nodeId).then(function(response){
			ctrl.nodeDetails=response.data;
		},function(response){
			Notification.error("Unable to get details");
		});
	};

    /*$scope.treeData =
		[
			{ "name" : "Joe", "age" : "21", "children" : [
				{ "name" : "Smith", "age" : "42", "children" : [] },
				{ "name" : "Gary", "age" : "21", "children" : [
					{ "name" : "Jenifer", "age" : "23", "children" : [
						{ "name" : "Dani", "age" : "32", "children" : [] },
						{ "name" : "Max", "age" : "34", "children" : [] }
					]}
				]}
			]},
			{ "name" : "Albert", "age" : "33", "children" : [] },
			{ "name" : "Ron", "age" : "29", "children" : [] }
		];*/
    /*$scope.buildNewElement = function(){
		let result = {};
		result["config"]={};			
		return result;
	};*/
	/*
[{"id":"1","name":"a","children":[{"id":"1.1","name":"aa"}]},{"id":"2","name":"b","children":[{"id":"2.1","name":"ab"},{"id":"2.2","name":"ac","children":[{"id":"2.2.1","name":"acd"}]}]},{"id":"3","name":"c","children":[]}]
	*/
	$scope.showComputerModal=function(item){
		ctrl.computerModalOut = {};
		ctrl.isComputerModalVisible = true;
		$scope.activeComputer = item;
	};
	$scope.onHideComputerModal = function(){
		console.log('onHideComputerModal');
		console.log(ctrl.computerModalOut);
		$scope.activeComputer = {};
	};
	$scope.onOkComputerModal = function(){
		$scope.loadComputers(ctrl.selectedNode.id);					
	};
	$scope.loadTree();	
});		
