app.controller('LicenseController', function($scope,$http,$location,Restangular,Notification,FileUploader){	
	let ctrl = this;
	ctrl.license={};
	$scope.selectedTab = $location.search()['tab'];	

	if (typeof $scope.selectedTab === 'undefined'){
		$scope.activeTab=0;		
	
	}else {
		$scope.activeTab=$scope.tabs.indexOf($scope.selectedTab);		
	}

	
	$scope.selectTab = function(tab){
    	$scope.selectedTab = tab;
		$location.search("tab",tab);
    };
    $scope.getLicenseInfo= function(){
    	$http.get("/api/license").then(function(response){
    		let data = response.data;
    		ctrl.license = data;
    	},function(response){
    		Notification.error("Unable to get license info");
    	});
    };
    $scope.updateLicense=function(text){
    	let data = {};
    	data.license=text;
    	$http.post("/api/license/update",data).then(function(response){

    		$scope.getLicenseInfo();
    	},function(response){
    		Notification.error("Unable to update license");
    	});
    };
    $scope.formatLicKey = function(key){
    	let result = key;
    	let keys={"org":"Organization", "maint_till":"Maintanance contract expires","expires":"License expires","elements":"Number of managed computers"};
    	if (keys.hasOwnProperty(key))
    		result = keys[key];
    	return result;
    };

    $scope.uploader = new FileUploader({
            url: '/api/file/upload/license',
            autoUpload: true
            
    });
    $scope.uploader.onAfterAddingFile = function(fileItem) {
    	ctrl.fileSelected = fileItem.file.name;    	
		ctrl.isUploading=true;    	
    };
    $scope.uploader.onCompleteAll = function() {    	
    	ctrl.isUploading=false;       	     
    };
    $scope.uploader.onSuccessItem = function(item, response, status, headers) {    	
    	Notification.success("License imported");    	
    	$scope.getLicenseInfo();
    };
    $scope.uploader.onErrorItem = function(item, response, status, headers) {    	
    	let message = "";
    	if (response.hasOwnProperty("message"))
    		message = response.message;
    	Notification.error("Unable to import license. "+message);
    };
    $scope.getLicenseInfo();

    /*$scope.buildNewElement = function(){
		let result = {};
		result["config"]={};			
		return result;
	};*/
	
});		
