app.controller('SecurityController', function($scope,$location,$http,FileUploader,Restangular,Notification,SessionProvider){	
	$scope.tabs=['users','lapsgroups','jitagroups','tokens','auth','extra'];
	$scope.selectedTab = $location.search()['tab'];		
	let ctrl = this;
	ctrl.authsettings={};
	ctrl.SessionProvider = SessionProvider;
	//ctrl.extAuthTypeS = ['radius','linotp','totp'];
	

    $scope.getDataForModal=function(){
        $scope.dataForModal={};
        Restangular.all('account/roles').getList().then(function(response){        	
            $scope.dataForModal['roles'] = response.plain();
            $scope.roleRef={};
            for (i in $scope.dataForModal['roles']){
            	let code = $scope.dataForModal['roles'][i].code;
            	let name = $scope.dataForModal['roles'][i].name;
            	$scope.roleRef[code] = name;
            }
        });        
    };

	if (typeof $scope.selectedTab === 'undefined'){
		$scope.activeTab=0;		
	
	}else {
		$scope.activeTab=$scope.tabs.indexOf($scope.selectedTab);		
	}

	
	$scope.selectTab = function(tab){
    	$scope.selectedTab = tab;
		$location.search("tab",tab);
    };
    $scope.formatConfig = function(key, item){
		let out = "";
		switch(key){
			case "external":
				out=item.external==true?"<i class='fa fa-windows'></i>":"<i class='fa fa-database'></i>";
				break;		
			case "mobile":
				let device = JSON.parse(item.mobile);
				out=" ";
				if (device.hasOwnProperty("platform")){
					if (device.platform.toLowerCase()=='android')
						out = "<i class='fa fa-android'></i>";
					else if (device.platform.toLowerCase()=='ios')
						out = "<i class='fa fa-apple'></i>";
				}
				break;
		}
		return out;
	};
    $scope.buildNewUser = function(){
		let result = {};
		result.enabled=true;
		result.change_password=true;
		result.external=false;
		//result["config"]={};			
		return result;
	};
	$scope.generateTOTP = function(result){
		result.initial_TOTP="";
		let characters       = 'abcdefghijkmnpqrstuvwxyz23456789';
    	var charactersLength = characters.length;;
		let res ="";
    	for ( var i = 0; i < 6; i++ ) {
        	res += characters.charAt(Math.floor(Math.random() * charactersLength));
    	}
    	result.initial_TOTP = res;
		$scope.setClip(res);
				
	};
	$scope.addRole=function(result,role){
		if (result.external==false && role==='LAPSUSER'){
			alert("LAPS allowed for AD users only");
			return;
		}
		if (result.external==false && role==='JIAUSER'){
			alert("JITA allowed for AD users only");
			return;
		}
		if (result.hasOwnProperty('roles')==false){
			result.roles=[];
		}
		if (result.roles.indexOf(role)<0){
			result.roles.push(role);
		}
	};
	$scope.delRole=function(result,role){
		result.roles = _.without(result.roles,role);
	};
	$scope.preprocessUserData = function(item){
        let roles = JSON.parse(item.roles);
        item.roles = roles;        
        return item;
	};
	$scope.getDataForModal();

	$scope.formatLibrary = function(key, item){
		let out = "";
		switch(key){
			case "config":
				let json = JSON.parse(item.config);
				out = json.type;				
				break;			
			case "modified":
				if (item.modified>0){
					out=$scope.formatDate(item.modified)
				}else
					out="-"
				break;		
			case "ip":
				let json2 = JSON.parse(item.config);
				out = json2.ip;				
				break;
		}
		return out;
	};

	$scope.buildNewUI = function(){
		let result = {};
		result["config"]={};		
		return result;
	};
	
	$scope.formatDate=function(ts){
		return moment.unix(ts).format("YYYY-MM-DD HH:mm:ss");
	};
	$scope.loadSettings = function(){

		$http.get("/api/setting/group/auth").then(function(response){
			let data = response.data;


			ctrl.extAuthType = response.data.value;

		});
	};
	$scope.applyAuthSettings = function(item,model){
		let data=[];


		let extAuthType={key:"auth:extauth_type", value: ctrl.extAuthType};
		data.put(extAuthType);
		let requrePassword = {key:"auth:requirePassword", value: ctrl.requirePassword};
		data.put(requrePassword);
		let requireExternalAuth = {key:"auth:requireExternalAuth", value: ctrl.requireExternalAuth};
		
		$http.post("/api/setting",data).then(function(response){
			Notification.success("External authentification provider changed");
		},function(response){
			Notification.errpr("Unable to set authentification provider");
		});
	};
	$scope.buildNewJIA = function(){
		let result = {};
		result.config={};
		result.config.description="";
		result.config.priv_groups=[];			
		return result;
	};
	$scope.addJIAPrivGroup=function(result,element){
		if (result.hasOwnProperty('config')==false){
			result.config={};
			result.config.priv_groups=[];
		}
		if (result.config.hasOwnProperty('priv_groups')==false){
			result.config.priv_groups=[];
		}
		if (result.config.priv_groups.indexOf(element)<0){
			result.config.priv_groups.push(element);
		}
	};
	$scope.delJIAPrivGroup=function(result,element){
		result.config.priv_groups = _.without(result.config.priv_groups,element);
	};

	$scope.setClip = function(value){
		var tempInput = document.createElement("input");
    	tempInput.style = "position: absolute; left: -1000px; top: -1000px";
    	tempInput.value = value;
    	document.body.appendChild(tempInput);
    	tempInput.select();
    	document.execCommand("copy");
    	document.body.removeChild(tempInput);
	};

	$scope.loadSettings();
});		
