app.controller('SystemController', function($scope,$http,$location,Restangular,Notification,$interval){	
	let ctrl = this;
	ctrl.logFile="";
	$scope.tabs=['service','backup','logs','filelog'];
	$scope.selectedTab = $location.search()['tab'];	
	$scope.refreshTimer=null;	
	ctrl.hostInfo = {};
	if (typeof $scope.selectedTab === 'undefined'){
		$scope.activeTab=0;		
	
	}else {
		$scope.activeTab=$scope.tabs.indexOf($scope.selectedTab);		
	}
	ctrl.maxRows=100;
	ctrl.searchText="";
	ctrl.logs="";
	ctrl.logFiles=[];

	$scope.selectTab = function(tab){
    	$scope.selectedTab = tab;
		$location.search("tab",tab);
    };
    $scope.restart = function(){
    	ctrl.status = "Restarting";
    	ctrl.restarting=true;
    	$scope.initTimer(5000);
    	$http.get("/api/system/restart").then(function(response){    		

    	},function(response){
    		/*$interval.cancel($scope.refreshTimer);*/
    		//Notification.error("Unable to send restart command");
    		//ctrl.status = "n/a";
    		ctrl.restarting=true;
    	});
    };
    $scope.checkStatus=function(){
    	$http.get("/api/system/health").then(function(response){
    		ctrl.status = response.data.status;
    		ctrl.restarting=false;
    		$interval.cancel($scope.refreshTimer);    		

    	},function(response){
    		ctrl.status = "n/a";

    	});

    };
    $scope.initTimer = function(interval){
		if ($scope.refreshTimer!=null){
			$interval.cancel($scope.refreshTimer);
		}
		if (interval){
			$scope.refreshTimer=$interval(function(){
		        //console.log("timer");        
		        if (interval >0){
		        	$scope.checkStatus();
		    		
		        }

			},interval);
		}
	
	};
	$scope.selectMaxRows=function(maxRows){
		ctrl.maxRows = maxRows;
	};
	$scope.search = function(){
		if (ctrl.logFile === ""){
			ctrl.logFile = ctrl.logFiles[0];
		}
		let data={filter:ctrl.searchText, limit:ctrl.maxRows, file:ctrl.logFile};
		$http.post("/api/system/log/search",data).then(function(response){
			let result = response.data;
			ctrl.logs = result.result;
			document.getElementById("logs").rows = result.count;
			

		},function(response){
			Notification.error("Unable to perform search");
		});

	};
	$scope.download = function(){
		let anchor = angular.element('<a/>');
		     anchor.attr({
		         href: "/api/file/download/log/"+ctrl.logFile
		         //target: '_blank'
		         //download: filename
		     })[0].click();
	};
	$scope.loadFiles=function(){
		$http.get("/api/system/log/files").then(function(response){
			let data = response.data;
			ctrl.logFiles = data;
		},function(response){
			Notification.error("Unable to load log files");
		});
	};
	$scope.getHostInfo = function(){
		ctrl.hostInfo = {};
		$http.get("/api/system/host").then(function(response){
			let data = response.data;
			ctrl.hostInfo = data;
		},function(response){
			Notification.error("Unable to get host information");
		});
	};


	$scope.$on("$destroy",function(){
        $interval.cancel($scope.refreshTimer);
	});
	$scope.checkStatus();
	$scope.loadFiles();
	$scope.getHostInfo();
    /*$scope.buildNewElement = function(){
		let result = {};
		result["config"]={};			
		return result;
	};*/
	
});		
