app.controller('JIAController', function($scope,$location,$http,$q,$interval,Restangular,Notification,ModalService,SessionProvider){	
	let ctrl = this;
	ctrl.sessionsSpin=false;
	ctrl.rolesSpin = false;
	ctrl.sessionsTimer=null;
	ctrl.sessionsMap = {};
	ctrl.rolesMap={};
	//ctrl.sessions=[{name:"vm"},{name:"ad"},{name:"fim"}];
	$scope.getMyRoles = function(){
		ctrl.rolesSpin = true;
		ctrl.rolesMap={};
		$http.get("/api/jia/myroles").then(function(response){
			ctrl.rolesSpin = false;
			let data = response.data;
			ctrl.roles = data;
			for (var i=0; i < ctrl.roles.length; i++){
				let element = ctrl.roles[i];
				ctrl.rolesMap[element.name] = element.config;
			}
		},function(error){
			ctrl.rolesSpin=false;
			Notification.error("Unable to load roles");
		});
	};
	$scope.getActiveSessions = function(){
		ctrl.sessionsMap = {};
		ctrl.sessionsSpin = true;
		$http.get("/api/jia/sessions").then(function(response){
			ctrl.sessionsSpin=false;
			let data = response.data;
			ctrl.sessions = data;
			for (var i=0; i < ctrl.sessions.length; i++){
				let element = ctrl.sessions[i];
				ctrl.sessionsMap[element.name] = element;
				let now = (new Date()).getTime();
				let rest = 100*(element.ts_till-now)/(element.ts_till-element.ts_committed);
				ctrl.sessionsMap[element.name]["elapsed"] = rest;
			}
			if (ctrl.sessions.length>0){
				$scope.runSessionsMonitor();
			}else{
				$interval.cancel(ctrl.sessionsTimer);
			}
			
			

		},function(error){
			ctrl.sessionsSpin=false;
			Notification.error("Unable to load roles");
		});
	};
	$scope.startSession=function(roleName){
		let modalData={};
		modalData.role = roleName;
		modalData.roleConfig = ctrl.rolesMap[roleName];
		$scope.showModal('start',modalData);
	};
	$scope.extendSession=function(roleName){
		let modalData={};
		modalData.role = roleName;
		modalData.roleConfig = ctrl.rolesMap[roleName];
		$scope.showModal('extend',modalData);
	};
	$scope.stopSession = function(sessionId){
		if (confirm("Do you want to stop session")){
			$http.delete("/api/jia/session/"+sessionId).then(function(response){
				Notification.success("Session stopped");
				$scope.getActiveSessions();
			},function(error){
				Notification.error("Unable to stop role session");
			})
		}
	};
	$scope.formatDate=function(ts){
		return moment.unix(ts).format("YYYY-MM-DD HH:mm:ss");
	};
	$scope.runSessionsMonitor = function(){
		if (ctrl.sessionsTimer!=null){
            $interval.cancel(ctrl.sessionsTimer);    
        }
        ctrl.sessionsTimer = $interval(function(){
        	/*console.log("SessionTimer"); */
        	if (ctrl.sessions.length<=0)
        		$interval.cancel(ctrl.sessionsTimer);    
        	for (var i=0; i < ctrl.sessions.length; i++){
				let element = ctrl.sessions[i];
				let now = (new Date()).getTime();
				let rest = 100*(element.ts_till-now)/(element.ts_till-element.ts_committed);
				ctrl.sessionsMap[element.name]["elapsed"] = rest;
				if (rest<=0){
					$interval.cancel(ctrl.sessionsTimer);    
					$scope.getActiveSessions();
				}
				
			}
				
        	
        },5000);
	};
	$scope.showModal = function(modaltype,item){
		var inputData=item;
		var caption="";
    	var okButton="";
    	let extra={};
    	let templateUrl = $scope.templateUrl;
    	switch(modaltype){
    		case "start":    		
    			caption="Start session "+item.role;
    			okButton="Start";
				break;
			case "extend":
				caption="Extend session "+item.role;				
    			okButton="Extend";
				break;
		}
		
		ModalService.showModal({
			templateUrl: "/web/app/pages/jita/jitaModal.html",
			controller: "JIAModalController",	
			controllerAs:"ctrl",
			inputs: {				
				data:{	
					item: inputData,//input
					caption: caption,
					okButton: okButton,
					modaltype: modaltype/*,
					role:ctrl.rolesMap[item.role]*/				
				}
				
			}

		}).then(function(modal) {
			modal.element.modal({backdrop: 'static', keyboard: false});
			modal.close.then(function(result) {
				if (result.result==true)
					$scope.getActiveSessions();
			});
			/*modal.apply.then(function(result){
				console.log("apply");
			});*/
		});
	};
	$scope.getElapsed=function(start,end){
		let now = (new Date()).getTime();
		let rest = 100*(end-now)/(end-start);
		if (rest<=0)
			$scope.getActiveSessions();
		return rest;
	}

	$scope.getMyRoles();
	$scope.getActiveSessions();
})
.controller('JIAModalController', function($scope, $element,data,close,Notification,$http) {
	let ctrl=this;
	$scope.data=data;
	$scope.TTLwarning="Please set duration (HH:mm:ss)";
	$scope.result = _.clone(data.item);
	$scope.duration = new Date();
	$scope.duration.setHours(0,0,0,0);
	$scope.till = new Date();
	$scope.durationChanged=function(){
		let h = $scope.duration.getHours();
		let m = $scope.duration.getMinutes();
		let s = $scope.duration.getSeconds();
		let seconds = h*60*60+m*60+s;
		let roleTTL =data.item.roleConfig.ttl; 
		if (h==0&&m==0&&s==0){
			$scope.TTLwarning="Please set duration (HH:mm:ss)";
			return;
		}
		if (seconds > roleTTL){
			let aH=Math.floor(roleTTL/3600);
			let aM = Math.floor((roleTTL-aH*3600)/60);
			let aS = roleTTL -aH*3600 - aM*60;
			let warning = "";
			if (aH>0){
				warning+=aH;
				warning+= (aH>1)?" hours ":"hour ";
			}
			if (aM>0){
				warning+=aM;
				warning+=(aM>1)?" minutes ":" minute ";
			}
			if (aS>0){
				warning+=aS;
				warning+=(aS>1)?" seconds":" second";
			}
			
			$scope.TTLwarning="Maximum allowed duration for this role is "+ warning;
		}else{
			$scope.TTLwarning="";
			$scope.till = moment(new Date()).add(h, 'h').add(m, 'm').add(s, 's').toDate();
		}
	};
	$scope.apply = function(){
		let postData ={};
		postData.role = data.item.role;
		let till = $scope.till.getTime();
		postData.till = till;
		$http.post("/api/jia/apply",postData).then(function(response){
			Notification.success("Role applied");
			$element.modal('hide');
			$('body').removeClass('modal-open');
			$('.modal-backdrop').remove();
			close({
				result: true    		
			}); 
		},function(error){
			Notification.error("Unable to apply to role");
		});
	};
	$scope.close = function() {
		$element.modal('hide');
		$('body').removeClass('modal-open');
		$('.modal-backdrop').remove();
		close({
			value: $scope.result    		
		}); 
	};
	$scope.cancel = function() {
		$element.modal('hide');
		$('body').removeClass('modal-open');
		$('.modal-backdrop').remove();		
		close({});
	};
});