app.controller('LapsController', function($scope,$location,$http,$q,Restangular,Notification,$localStorage,SessionProvider){	
	//$scope.SessionProvider = SessionProvider;
	let ctrl = this;
	ctrl.pc="";
	ctrl.password="";
	ctrl.otherPasswords=[];
	ctrl.expire="";
	ctrl.dn="";
	ctrl.showResult=false;
	ctrl.spin = false;
	ctrl.spinIP=false;
	ctrl.pc_commands=[];
	ctrl.objShell=null;
	//ctrl.searchHistroy=[];
	ctrl.history=[];
	$scope.newexpire={};
	$scope.newexpire.h=00;
	$scope.newexpire.m=00;
	$scope.newexpire.s=00;
	//$scope.pwdType = "password";

	$scope.searchPC=function(computer){		
		
		ctrl.password="";	
		ctrl.otherPasswords=[];
		ctrl.expire="";	
		ctrl.pc = computer.trim();
		ctrl.extra=[];		
		ctrl.spin = true;
		$scope.historyModify("add",computer.trim().toLowerCase());				
		$http.get("/api/laps/password/"+computer.trim()).then(function(response){			
			let data = response.data;
			ctrl.password = data.password;
			if (data.hasOwnProperty('expire'))
				ctrl.expire = $scope.formatDate(data.expire);
			ctrl.dn = data.dn;
			ctrl.showResult=true;
			if (data.hasOwnProperty('extra')){
				ctrl.extra = data.extra;
			}
			if (data.hasOwnProperty('other_passwords')){
				ctrl.otherPasswords = data.other_passwords;
			}
			if (data.hasOwnProperty('error')){
				Notification.error(data.error);
			}
			if (data.hasOwnProperty('warning')){
				Notification.warning(data.warning);
			}
			else if (data.hasOwnProperty('password')){				
				$scope.historyModify("add",computer.toLowerCase());				
				
			}
			ctrl.spin = false;
			
			/*$('#password').focus();
			$('#password').select();*/

		},function(response){
			ctrl.spin = false;
			if(response.status == 429){
                Notification.error("Too many requests");
            }else if (response.status==-1){
				Notification.error("Server is down");
            }
            else{
            	let msg = "";
            	if (response.data.hasOwnProperty("error"))
            		msg = response.data.error;
            	Notification.error("Error "+msg);
				console.log(response);
            }
						
		});
		
	};
	$scope.searchPC2 = function(val) {		
	    return $http.get("/api/search/computer/"+val).then(function(response){
	      return response.data.map(function(item){
	        return item.cn;
	      });
	    });
	};

	$scope.lookupIP = function(val) {		
		ctrl.spinIP=true;
	    return $http.get("/api/search/ip/"+val).then(function(response){
	    	ctrl.spinIP=false;	     
	    	let data = response.data;
	    	if (data.length>0) {
	    		ctrl.pc=data[0]['pc'];
	    		$scope.searchPC(ctrl.pc);
	    	}else{
	    		Notification.error("Unable to resolve IP");
	    	}
	    },function(response){
	    	ctrl.spinIP=false;	 
	    	Notification.error("Unable to resolve IP");
	    });
	};
	$scope.lookupMyIP = function(){
		ctrl.spinMyIP=true;
	    $http.get("/api/search/myip").then(function(response){
	    	ctrl.spinMyIP=false;	     
	    	let data = response.data;
	    	
    		ctrl.ip = data.ip;
    		ctrl.pc = data.pc;
    		$scope.searchPC(ctrl.pc);
	    	
	    },function(response){
	    	ctrl.spinMyIP=false;	 
	    	Notification.error("Unable to resolve current computer name");
	    });
	};

	$scope.onSearchSelect = function($item, $model, $label){
		ctrl.pc = $item;
		//$scope.searchPC(ctrl.pc);		
	};
	$scope.setExpire=function(){
		let temp = $scope.newexpire.date.getTime()+$scope.newexpire.h*60*60*1000+$scope.newexpire.m*60*1000+$scope.newexpire.s*1000;
		let data={};
		data.computer=ctrl.pc;
		data.expire = temp;
		ctrl.spin = true;
		$http.post("/api/laps/expire",data).then(function(response){
			Notification.success("New expiration set");
			ctrl.expire = $scope.formatDate(temp/1000);
			ctrl.spin = false;
		},function(response){
			Notification.error("Unable to set new expiration");
			ctrl.spin = false;
		})

	}
	$scope.formatDate=function(ts){
		return moment.unix(ts).format("YYYY-MM-DD HH:mm:ss");
	};
	$scope.parseDates = function(){
		let from = $scope.lastFrom;
		let to = $scope.lastTo;
		let fromParts = from.toString().split('-');
		let relativeParts = [];

		 // Try to parse the relative time, if we can't use moment duration to guestimate
		 if (to.toString() === 'now' && fromParts[0] === 'now' && fromParts[1]) {
		   relativeParts = fromParts[1].match(/([0-9]+)([smhdwMy]).*/);		   
			if (relativeParts[1] && relativeParts[2]) {		 	
				let count = parseInt(relativeParts[1], 10);
			   	let unit = relativeParts[2];
				$scope.to = moment();
				$scope.from = moment().subtract(count,unit);							   
			} 
		 }
		
	};
	$scope.copyPasswd=function(){
		$('#password').select();
		document.execCommand("Copy");
	};
	$scope.copyExtraToClipboard = function(id){
		$('#extra'+id).select();
		document.execCommand("Copy");
	};
	$scope.setClip = function(value){
		var tempInput = document.createElement("input");
    	tempInput.style = "position: absolute; left: -1000px; top: -1000px";
    	tempInput.value = value;
    	document.body.appendChild(tempInput);
    	tempInput.select();
    	document.execCommand("copy");
    	document.body.removeChild(tempInput);
	};

	$scope.favoritesModify=function(operation,item){
		if (item!=""){
			let data={value:item};
			$http.post("/api/account/profile/FAVORITES_PC/"+operation,data).then(function(response){
				let index = ctrl.favorites.indexOf(item.toLowerCase());
				switch (operation){
					case "add":
						if (index ===-1){
							ctrl.favorites.push(item.toLowerCase());
						}
						break;
					case "del":
						if (index!==-1){
							ctrl.favorites.splice(index, 1);
						}
						break;

				}
				
			},function(response){
				Notification.error("Unable to modify favorites");
			});
		}
	};


	$scope.historyModify=function(operation,item){
		if (item!=""){
			let data={value:item};
			$http.post("/api/account/profile/HISTORY_PC/"+operation,data).then(function(response){
				if (ctrl.history.length>0 && ctrl.history[0].toLowerCase()!==item.toLowerCase()){
					ctrl.history.unshift(item.toLowerCase());					
					if (ctrl.history.length>14){
						ctrl.history.pop();
					}				
				}else if (ctrl.history.length==0){					
					ctrl.history.unshift(item.toLowerCase());
				}
				
			},function(response){
				Notification.error("Unable to modify history");
			});
		}
	};

	$scope.getProfile=function(){
		ctrl.favorites=[];
		$http.get("/api/account/profile").then(function(response){
			let data = response.data;
			if (data.hasOwnProperty('FAVORITES_PC'))
				ctrl.favorites = data.FAVORITES_PC;
			if (data.hasOwnProperty('HISTORY_PC')){
				ctrl.history=data.HISTORY_PC.reverse();
			}
		},function(response){
			Notification.error("Unable to get favorites");
		});

	};
	$scope.getCommands=function(){
		$http.get("/api/account/profile/CMD_PATTERN").then(function(response){
			ctrl.pc_commands = response.data;			
		},function(response){
			Notification.error("Unable to fetch commands");
		});	
	};
	$scope.runCommand=function(cmd){
		let _cmd = cmd.replace(/%pc%/g,ctrl.pc);
		_cmd = _cmd.replace(/%pwd%/g,ctrl.password)
		if (_cmd.search("%copypwd%")!=-1){
			$scope.copyPasswd();
			_cmd = _cmd.replace(/%copypwd%/g,"");
		}
		let cmd_notify = cmd.replace(/%pc%/g,ctrl.pc).replace(/%copypwd%/g,"").replace(/%pwd%/g,"******");
		try{					
			ctrl.objShell.run(_cmd);
			Notification.success("Command "+cmd_notify+" executed");
		}
		catch (e){
			Notification.error("Unable to run "+cmd_notify);
		}		

	};

	/*if (!$localStorage.hasOwnProperty('searchHistroy')){
		$localStorage.searchHistroy=[];
	}*/
	//ctrl.searchHistroy=$localStorage.searchHistroy;
	if (SessionProvider.isAuthorized()){
		$scope.getCommands();
		$scope.getProfile();	
	}else{
		console.log("Unable to get commands and profile: you are not authorized")
	}
	
	try{
		ctrl.objShell = new ActiveXObject("WScript.shell");
	}
	catch (e){
		console.log("Unable to get WScript.shell");
	}
	//ctrl.favorites=[];
	/*ctrl.searchHistroy[0]="pc1";
	ctrl.searchHistroy[1]="pc2";*/
});		
