app.controller("loginController", function ($scope,$http,$location,AuthService,Notification,SessionProvider,$localStorage) {
    let ctrl = this;
    ctrl.SessionProvider = SessionProvider;
    ctrl.settings={};
    ctrl.login="";    
    ctrl.password="";
    ctrl.otp="";
    ctrl.confirm_otp="";
    ctrl.status="";
    ctrl.statusToken="";    
    ctrl.qrcode="";
    ctrl.secret="";
    ctrl.capcha_uuid="";    
    ctrl.capcha="";
    ctrl.capcha_img="";
    ctrl.capcha_uuid="";

    ctrl.newPassword=null;
    ctrl.newPassword2=null;
    ctrl.spin = false;
    ctrl.spinPush = false;
    ctrl.logonType="external";
	
    //$scope.token;



    $scope.doLogin=function(){
        ctrl.spin = true;
        let data={login:ctrl.login, password:ctrl.password, otp:ctrl.otp, capcha:ctrl.capcha,capcha_uuid:ctrl.capcha_uuid, secret:ctrl.secret, confirm_otp: ctrl.confirm_otp};
        AuthService.doLogin(data);
    };    
    $scope.doPushLogin = function(){
        //ctrl.spinPush = true;
        AuthService.doPushLogin(ctrl.login,ctrl.settings['mobile:push_auth_wait']);

    };
    $scope.$on('onAuthStatus', function (event, data) {
        ctrl.spin = false;
        ctrl.spinPush = false;
        ctrl.status = data.status;
        if (data.hasOwnProperty('token')){
            ctrl.statusToken = data.token
        }
        if (ctrl.status==="CAPCHA_REQUIRED"||ctrl.status==="WRONG_CAPCHA"){            
            ctrl.capcha_img = data.capcha_img;
            ctrl.capcha_uuid = data.capcha_uuid;
            //$scope.getCapcha();
        }
        if (ctrl.status==="GENERATE_OTP"){
            //ctrl.otp="";
            ctrl.confirm_otp="";
        }
        if (ctrl.status==="WRONG_OTP"){
            ctrl.otp="";
            ctrl.confirm_otp="";
        }
        //else if(ctrl.status)

    });
    $scope.$on('onAuthOK', function (event, data) {
        ctrl.spin = false;
        ctrl.spinPush = false;
        ctrl.status="";
        ctrl.password="";
        ctrl.otp="";
        ctrl.qrcode="";
        ctrl.secret="";
        ctrl.newPassword2="";
        ctrl.newPassword="";
        ctrl.capcha_uuid="";
        ctrl.capcha_img="";
        ctrl.capcha="";
        $localStorage.login = ctrl.login;
        $localStorage.logonType = ctrl.logonType;
    });
    $scope.getQRcode=function(){
        let data = {};
        data.token = ctrl.statusToken;
        $http.post("/api/account/totp/generate",data).then(function(response){
            let data = response.data;
            ctrl.qrcode = data.qrcode;
            ctrl.secret = data.secret;

        },function(response){
            Notification.error("Unable to generate TOTP");
        });

    };
    $scope.changePassword = function(){
        if (ctrl.newPassword!==ctrl.newPassword2)
            alert('Confirm new password again');
        else if (ctrl.newPassword === ctrl.password){
            alert("New password must be different!");
        }
        else{
            let data ={};
            data.login = ctrl.login;
            data.password = ctrl.newPassword;
            data.oldpassword=ctrl.password;
            data.token = ctrl.statusToken;            
            $http.post('/api/account/updatepassword',data).then(function(response){
                ctrl.password = ctrl.newPassword;
                let data={login:ctrl.login, password:ctrl.password, otp:ctrl.otp};
                AuthService.doLogin(data);                
            },function(response){
                let data = response.data;
                let msg = "Change password error";
                if (data!=null && data.hasOwnProperty("error"))
                    msg = data.error;
                Notification.error(msg);
            });
            
            
        }
    };
    $scope.getCapcha = function(){
        ctrl.capcha_img="";
        ctrl.capcha_uuid="";
        $http.get("/api/account/capcha/generate/"+ctrl.login).then(function(response){
            let data = response.data;
            ctrl.capcha_img = data.capcha_img;
            ctrl.capcha_uuid = data.capcha_uuid;
        },function(response){
            Notification.error("Load capcha error");
        });
    };
    $http.get("/api/setting/default").then(
        function(response){
            let data = response.data;
            _.forEach(data, function(o) {
                switch(o.type){
                    case "checkbox":
                        ctrl.settings[o.key] = o.value=="true"? true:false;
                        break;
                    case "select":
                        ctrl.settings[o.key] = o.value;                       
                        break;  
                    case "number":
                        ctrl.settings[o.key] = Number(o.value);                       
                        break;
                    default:
                        ctrl.settings[o.key] = o.value;
                        break;                  
                }                
                //$scope.target[o.key] = $scope.settings[o.key];                
            });
            AuthService.setProtectorActive(ctrl.settings["laps_extra:logoff_onscreenchange"]);            
            //AuthService.push_auth_wait=ctrl.settings['mobile:push_auth_wait'];
        });

    ctrl.login = $localStorage.login;
    if ($localStorage.hasOwnProperty('logonType'))
        ctrl.logonType = $localStorage.logonType;
	
    if (SessionProvider.isAuthorized()){
        if ($location.path()==='/login'){
            $location.path('/secrets');    

        }        
        
    }
});
