app.controller('LogsController', function($scope,$location,$http,Restangular,Notification){	
	$scope.lastTimes=flx.lastTimes;
	$scope.pageSize = 100;
	$scope.currentPage=1;
	let ctrl = this;
	ctrl.headers = [{caption:"Timestamp",field:'ts_created'},{caption:"Category",field:'category'},{caption:"Type",field:'event_type'},{caption:"Source IP",field:'source_ip'},
	{caption:"Src User",field:'user_src'},{caption:"Dst User",field:'user_dst'},{caption:"Computer",field:'computer'},{caption:"Details",field:'message'}];
	ctrl.filter={};
	ctrl.filter.from={};
	ctrl.filter.to={};
	ctrl.lastFrom=null;
	ctrl.lastTo = null;
	$http.get("/api/logs/categories").then(function(response){
		ctrl.categories=response.data;
	});
	
    $scope.selectLast=function(last){
		ctrl.lastSelected=last;
		ctrl.lastFrom = last.from;
		ctrl.lastTo = last.to;		
		$scope.parseDates();	
		$scope.setDate(ctrl.from,ctrl.to);			 					
        $scope.search();

	};
	$scope.refreshSelected = function(){
		if (ctrl.hasOwnProperty('lastSelected')){
			$scope.selectLast(ctrl.lastSelected);
		}
	};
	$scope.intervalToString=function(from,to){
		let index = _.findIndex($scope.lastTimes, { from: from, to:to});
		if (index>=0)
			return $scope.lastTimes[index].display;
		else
			return "Last...";
	};
	$scope.parseDates = function(){
		let from = ctrl.lastFrom;
		let to = ctrl.lastTo;
		let fromParts = from.toString().split('-');
		let relativeParts = [];

		 // Try to parse the relative time, if we can't use moment duration to guestimate
		 if (to.toString() === 'now' && fromParts[0] === 'now' && fromParts[1]) {
		   relativeParts = fromParts[1].match(/([0-9]+)([smhdwMy]).*/);		   
			if (relativeParts[1] && relativeParts[2]) {		 	
				let count = parseInt(relativeParts[1], 10);
			   	let unit = relativeParts[2];
				ctrl.to = moment();
				ctrl.from = moment().subtract(count,unit);							   
			} 
		 }
		
	};
	$scope.setDate=function(from,to){
		ctrl.filter.from.datetime = from;				
		ctrl.filter.to.datetime = to;

		/*self.filter.from.datetime = flx.convertToUTC(from);				
		self.filter.to.datetime = flx.convertToUTC(to);*/

		var dFrom = new Date(ctrl.filter.from.datetime);
		var dTo = new Date(ctrl.filter.to.datetime);

		ctrl.filter.from.date = new Date(dFrom.getFullYear(), dFrom.getMonth(), dFrom.getDate(), 0, 0, 0);

		ctrl.filter.from.h = dFrom.getHours();
		ctrl.filter.from.m = dFrom.getMinutes();
		ctrl.filter.from.s = dFrom.getSeconds();
		
		ctrl.filter.to.date = new Date(dTo.getFullYear(), dTo.getMonth(), dTo.getDate(), 0, 0, 0);
		ctrl.filter.to.h = dTo.getHours();
		ctrl.filter.to.m = dTo.getMinutes();
		ctrl.filter.to.s = dTo.getSeconds();
		
	};
	
	$scope.search = function(){
		ctrl.spin = true;
		ctrl.filter.from.datetime = ctrl.filter.from.date.getTime()+ctrl.filter.from.h*60*60*1000+ctrl.filter.from.m*60*1000+ctrl.filter.from.s*1000;
        ctrl.filter.to.datetime = ctrl.filter.to.date.getTime()+ctrl.filter.to.h*60*60*1000+ctrl.filter.to.m*60*1000+ctrl.filter.to.s*1000;        
        var request=_.clone(ctrl.filter);
        request.from = ctrl.filter.from.datetime;
		request.to = ctrl.filter.to.datetime;		
		$http.post("/api/logs/search",request).then(function(response){
			$scope.allItems = response.data;
			ctrl.spin = false;
		},function(response){
			Notification.error("Unable to get logs");
			console.log(response);
			ctrl.spin = false;

		});
	};

	$scope.export = function(){
		ctrl.spin = true;
		ctrl.filter.from.datetime = ctrl.filter.from.date.getTime()+ctrl.filter.from.h*60*60*1000+ctrl.filter.from.m*60*1000+ctrl.filter.from.s*1000;
        ctrl.filter.to.datetime = ctrl.filter.to.date.getTime()+ctrl.filter.to.h*60*60*1000+ctrl.filter.to.m*60*1000+ctrl.filter.to.s*1000;        
        var request=_.clone(ctrl.filter);
        request.from = ctrl.filter.from.datetime;
		request.to = ctrl.filter.to.datetime;		
		$http.post("/api/logs/export",request).then(function(response){			
			ctrl.spin = false;
			var contentType = response.headers("content-type");
			var file = new Blob([response.data], { type: contentType });
            saveAs(file, response.headers("x-filename"));
		},function(response){
			Notification.error("Unable to export logs");
			console.log(response);
			ctrl.spin = false;

		});
	};
	$scope.prepareRequest = function(){		
		var request={};
		request.date={};
		request.date.from = ctrl.filter.from.datetime;
		request.date.to = ctrl.filter.to.datetime;		
		request.filter=ctrl.filter;

		/*request.loadLimit = data.loadLimit;*/
		request.fields = [];			
		angular.forEach(data.queries,function(value,index){
			if (value.enabled===true){
                request.queries.push(value.text);
			}
        });
        request.sorts = data.sorts;
        return request;

	};
	$scope.categorySelected=function(item,model){
		if (typeof(item)!=="undefined"){
			switch (item.code){
				case "audit":
						ctrl.headers = [{caption:"Timestamp",field:'ts_created'},{caption:"Category",field:'category'},{caption:"Type",field:'event_type'},{caption:"Source IP",field:'source_ip'},
		{caption:"Src User",field:'user_src'},{caption:"Dst User",field:'user_dst'},{caption:"Details",field:'message'}];
					break;
				case "laps":
					ctrl.headers = [{caption:"Timestamp",field:'ts_created'},{caption:"Category",field:'category'},{caption:"Type",field:'event_type'},{caption:"Source IP",field:'source_ip'},
		{caption:"User",field:'user_src'},{caption:"Computer",field:'computer'},{caption:"Details",field:'message'}];
					break;
				default:
					ctrl.headers = [{caption:"Timestamp",field:'ts_created'},{caption:"Category",field:'category'},{caption:"Type",field:'event_type'},{caption:"Source IP",field:'source_ip'},
		{caption:"Src User",field:'user_src'},{caption:"Dst User",field:'user_dst'},{caption:"Computer",field:'computer'},{caption:"Details",field:'message'}];
			}
		}else{
			ctrl.headers = [{caption:"Timestamp",field:'ts_created'},{caption:"Category",field:'category'},{caption:"Type",field:'event_type'},{caption:"Source IP",field:'source_ip'},
		{caption:"Src User",field:'user_src'},{caption:"Dst User",field:'user_dst'},{caption:"Computer",field:'computer'},{caption:"Details",field:'message'}];
		}
		$scope.search();
		//console.log(item.code);

	};
	$scope.formatDate = function(utcDate){
		return moment(utcDate).format("YYYY-MM-DD HH:mm:ss (Z)");
		//return flx.utcToLocalString(utcDate);
	};
	$scope.fieldOptions = [
	    ['Filter', function ($itemScope) {
	    	let field = $itemScope.h.field
	    	let f_value = $itemScope.$parent.item[field];
	    	ctrl.filter[field]=f_value;
	    	/*if (f_value.includes(" ") || f_value.includes(":"))
	    		f_value='"'+f_value+'"';*/
	    	//filterService.addQuery($itemScope.result.agg+":"+$itemScope.result.key);					    	
	    	//filterService.addQuery($itemScope.result.agg+":"+f_value);					    	
	    	//filterService.addQuery("=",$itemScope.result.agg,f_value);					    	
	        //$scope.selected = $itemScope.item.name;
	    }]  
	];
	ctrl.to = moment();
	ctrl.from = moment().subtract(24,'hours');							   
	$scope.setDate(ctrl.from.valueOf(),ctrl.to.valueOf());
	$scope.search();

})
.filter('startFrom', function() {
    return function(input, start) {         
        return input.slice(start);
		};
});		
