app.controller('NavigationController', function($scope,ModalService,$http,$location,AuthService,SessionProvider,Notification){
	$scope.SessionProvider = SessionProvider;
	$scope.showModal=function(source){
		ModalService.showModal({
			templateUrl: "/web/app/pages/navigation/myProfileModal.html",
			controller: "NaviModalController",			
			inputs: {				
				data:{	
					//input: controller,//input
					caption: "Profile",
					okButton: "Save"
				}
				
			}
	
		}).then(function(modal) {
			modal.element.modal();
			modal.close.then(function(result) {
				//console.log(result);				
				if (typeof result.value !== 'undefined') {
					switch (source){
						case 'myprofile':
							result.oldPassword="";
							result.newPassword="";
							result.newPassword2="";
							break;
					}
					/*
						process results here
					*/
				}
			});
		});
	};
	$scope.logout = function(){
		AuthService.logout();
		/*$http.get("/api/account/logout").then(function(response){
			$location.path('/login');

		},function(response){
			console.log(response);
		});*/
	};
	$scope.goTo = function(path){
		// Clear the current search
		$location.search({});
		$location.path(path);
	};
	
	
	
})
.controller('NaviModalController', function($scope, $element,data,close,AuthService,$http,$location,Notification) {
	$scope.data=data;
	$scope.result={};	

	$scope.close = function() {
		$element.modal('hide');
		$('body').removeClass('modal-open');
		$('.modal-backdrop').remove();
		close({
			value: $scope.result    		
		}); 
	};
	$scope.cancel = function() {
		$element.modal('hide');
		$('body').removeClass('modal-open');
		$('.modal-backdrop').remove();		
		close({});
	};
	
	$scope.updateProfile = function(){
		if ($scope.result.newPassword!=$scope.result.newPassword2)
			alert('Confirm new password again');
		else{
			let data={password:$scope.result.newPassword,oldpassword:$scope.result.oldPassword};
			$http.post('/api/account/updatepassword',data).then(function(response){
				Notification.success('Password updated');
				$scope.close();
				/*if (response.data.token){
					AuthService.updateToken(response.data.token);		
					$scope.close();
					console.log('token updated');
				}*/
			},function(response){
				$scope.result.oldPassword="";
				$scope.result.newPassword="";
				$scope.result.newPassword2="";
				Notification.error('Unable to update password');				
				console.log(response);
			});
			
			
		}
	};
	
});